/*
 * Decompiled with CFR 0.152.
 */
package savilerow.solver;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.model.Model;
import savilerow.solver.InteractiveSMTSolver;
import savilerow.solver.Stats;

public class InteractiveYicesSolver
extends InteractiveSMTSolver {
    public static final int YICES_OUT_OF_MEMORY = 16;
    public static final String RUN_TIME = "total-run-time";
    public static final String DECISIONS = "decisions";
    public static final String RESTARTS = "restarts";
    public static final String BOOL_PROP = "boolean-propagations";
    public static final String THEORY_PROP = "theory-propagations";

    public InteractiveYicesSolver(Model model) {
        super(model);
    }

    @Override
    protected void detectErrors(int n, ArrayList<String> arrayList, ArrayList<String> arrayList2, Stats stats) {
        stats.putValue("SolverMemOut", "0");
        if (arrayList2.size() != 0 || n != 10 && n != 20) {
            CmdFlags.println("yices exited with error code:" + n + " and error message:");
            CmdFlags.println(arrayList2);
            if (n == 16) {
                stats.putValue("SolverMemOut", "1");
                CmdFlags.typeError("yices ran out of memory");
            }
        } else {
            stats.putValue("SolverTimeOut", "0");
        }
    }

    @Override
    protected String getHeader(String string) {
        switch (string) {
            case "total-run-time": {
                return "SolverTotalTime";
            }
            case "decisions": {
                return "SolverNodes";
            }
            case "restarts": {
                return "Restarts";
            }
            case "boolean-propagations": {
                return "BoolPropagations";
            }
            case "theory-propagations": {
                return "TheoryPropagations";
            }
        }
        return null;
    }
}

