/*
 * Decompiled with CFR 0.152.
 */
package savilerow.treetransformer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import savilerow.CmdFlags;
import savilerow.TupleCompress;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Identifier;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.Table;
import savilerow.expression.TableShort;
import savilerow.model.Model;
import savilerow.treetransformer.NodeReplacement;
import savilerow.treetransformer.TreeTransformerBottomUpNoWrapper;

public class TransformTableToShortTable
extends TreeTransformerBottomUpNoWrapper {
    public TransformTableToShortTable(Model model) {
        super(model);
    }

    public static ArrayList<ArrayList<Intpair>> getDomainLists(ArrayList<ASTNode> arrayList, Model model) {
        ArrayList<ArrayList<Intpair>> arrayList2 = new ArrayList<ArrayList<Intpair>>();
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList<Intpair> arrayList3;
            if (arrayList.get(i) instanceof Identifier) {
                arrayList3 = model.global_symbols.getDomain(arrayList.get(i).toString()).getIntervalSet();
            } else {
                arrayList3 = new ArrayList<Intpair>();
                arrayList3.add(arrayList.get(i).getBounds());
            }
            arrayList2.add(arrayList3);
        }
        return arrayList2;
    }

    public static ASTNode convertHashSet(HashSet<ArrayList<Long>> hashSet) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (ArrayList<Long> arrayList2 : hashSet) {
            ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
            for (int i = 0; i < arrayList2.size(); ++i) {
                if (arrayList2.get(i) == TupleCompress.free_value) continue;
                ArrayList<ASTNode> arrayList4 = new ArrayList<ASTNode>(2);
                arrayList4.add(NumberConstant.make(i + 1));
                arrayList4.add(NumberConstant.make(arrayList2.get(i)));
                arrayList3.add(new CompoundMatrix(arrayList4));
            }
            if (arrayList3.isEmpty()) {
                return CompoundMatrix.make(CompoundMatrix.make(new ArrayList<ASTNode>()));
            }
            arrayList.add(new CompoundMatrix(arrayList3));
        }
        return CompoundMatrix.make(arrayList);
    }

    @Override
    protected NodeReplacement processNode(ASTNode aSTNode) {
        if (aSTNode instanceof Table) {
            Serializable serializable;
            ASTNode aSTNode2 = aSTNode.getChildConst(1);
            assert (aSTNode.getChild(0) instanceof CompoundMatrix && aSTNode2 instanceof CompoundMatrix);
            ArrayList<ASTNode> arrayList = aSTNode.getChild(0).getChildren(1);
            ArrayList<ArrayList<Intpair>> arrayList2 = TransformTableToShortTable.getDomainLists(arrayList, this.m);
            HashSet<ArrayList<Long>> hashSet = new HashSet<ArrayList<Long>>();
            for (int i = 1; i < aSTNode2.numChildren(); ++i) {
                serializable = new ArrayList();
                for (int j = 1; j <= arrayList.size(); ++j) {
                    ((ArrayList)serializable).add(aSTNode2.getChild(i).getChild(j).getValue());
                }
                hashSet.add((ArrayList<Long>)serializable);
            }
            HashSet<ArrayList<Long>> hashSet2 = TupleCompress.full_squeeze_tuples(hashSet, arrayList2, false);
            if (CmdFlags.verbose_make_short) {
                System.out.println("Squashed a long table. " + hashSet.size() + " -> " + hashSet2.size());
            }
            if ((serializable = TransformTableToShortTable.convertHashSet(hashSet2)) == null) {
                if (CmdFlags.verbose_make_short) {
                    System.out.println("Table is just 'true'!");
                }
                return new NodeReplacement(new BooleanConstant(true));
            }
            return new NodeReplacement(new TableShort(this.m, (ASTNode)new CompoundMatrix(arrayList), (ASTNode)serializable));
        }
        return null;
    }
}

