/*
 * Decompiled with CFR 0.152.
 */
package savilerow.treetransformer;

import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.Absolute;
import savilerow.expression.AllDifferent;
import savilerow.expression.And;
import savilerow.expression.Divide;
import savilerow.expression.ElementOne;
import savilerow.expression.Equals;
import savilerow.expression.InSet;
import savilerow.expression.Less;
import savilerow.expression.LessEqual;
import savilerow.expression.Mapping;
import savilerow.expression.Mod;
import savilerow.expression.Negate;
import savilerow.expression.SafeElementOne;
import savilerow.expression.ShiftMapper;
import savilerow.expression.Times;
import savilerow.expression.ToVariable;
import savilerow.expression.UnaryMinus;
import savilerow.expression.WeightedSum;
import savilerow.model.Model;
import savilerow.treetransformer.NodeReplacement;
import savilerow.treetransformer.TreeTransformerBottomUp;

public class TransformToFlatSMT
extends TreeTransformerBottomUp {
    public TransformToFlatSMT(Model model, boolean bl) {
        super(model);
        assert (CmdFlags.getSMTtrans());
        assert (!bl);
    }

    @Override
    protected NodeReplacement processNode(ASTNode aSTNode) {
        if (aSTNode.toFlatten(false) && (aSTNode.getParent() == null || !(aSTNode.getParent() instanceof ToVariable))) {
            if (!TransformToFlatSMT.shouldFlattenSMT(aSTNode)) {
                return null;
            }
            ASTNode aSTNode2 = this.m.global_symbols.newAuxHelper(aSTNode);
            ToVariable toVariable = new ToVariable(aSTNode, aSTNode2);
            this.m.global_symbols.auxVarRepresentsConstraint(aSTNode2.toString(), aSTNode.toString());
            return new NodeReplacement(aSTNode2, null, toVariable);
        }
        return null;
    }

    private static boolean shouldFlattenSMT(ASTNode aSTNode) {
        if (CmdFlags.getUseUF()) {
            return true;
        }
        if (CmdFlags.getUseFlat()) {
            return true;
        }
        ASTNode aSTNode2 = aSTNode.getParent();
        if (aSTNode2 instanceof ElementOne || aSTNode2 instanceof SafeElementOne) {
            return true;
        }
        if (aSTNode2 instanceof Mapping) {
            return true;
        }
        if (aSTNode instanceof ElementOne || aSTNode instanceof SafeElementOne) {
            return true;
        }
        if (CmdFlags.getUseLIA() || CmdFlags.getUseIDL()) {
            if (!aSTNode2.willSMTEncode()) {
                return aSTNode.toFlatten(false);
            }
            if (aSTNode instanceof Divide) {
                return true;
            }
            if (aSTNode instanceof Negate) {
                return true;
            }
            if (aSTNode instanceof UnaryMinus) {
                return true;
            }
            if (aSTNode instanceof Times) {
                return true;
            }
            if (aSTNode instanceof Mod) {
                return true;
            }
        }
        if (CmdFlags.getUseIDL()) {
            if (aSTNode instanceof ShiftMapper) {
                return true;
            }
            if (aSTNode instanceof Absolute) {
                return true;
            }
            if (aSTNode instanceof WeightedSum) {
                return true;
            }
            if (aSTNode instanceof Equals) {
                return true;
            }
            if (aSTNode instanceof Less) {
                return true;
            }
            if (aSTNode instanceof LessEqual) {
                return true;
            }
            if (aSTNode instanceof ToVariable) {
                return true;
            }
            if (aSTNode instanceof And) {
                return true;
            }
            if (aSTNode instanceof AllDifferent) {
                return true;
            }
            if (aSTNode instanceof InSet) {
                return true;
            }
        }
        return false;
    }
}

