package savilerow.treetransformer;
/*

    Savile Row http://savilerow.cs.st-andrews.ac.uk/
    Copyright (C) 2014-2024 Peter Nightingale
    
    This file is part of Savile Row.
    
    Savile Row is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    
    Savile Row is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with Savile Row.  If not, see <http://www.gnu.org/licenses/>.

*/




import java.util.*;

import savilerow.expression.*;

public class SubstituteValueSatLiteral extends TreeTransformerBottomUpNoWrapper
{
    HashSet<Long> positiveLits=new HashSet<>();
    
    public SubstituteValueSatLiteral(ArrayList<String> satSol)
    {
        super(null);
        
        // populate it from currentSolution, need to parse the strings to longs and store the +ve ones.
        for(int i=0; i<satSol.size(); i++) {
            long assign=Long.valueOf(satSol.get(i));
            if(assign>0) {
                positiveLits.add(assign);
            }
        }
    }
    
    protected NodeReplacement processNode(ASTNode curnode)
    {
        if(curnode instanceof SATLiteral) {
            return new NodeReplacement(new BooleanConstant(positiveLits.contains(((SATLiteral)curnode).getLit())));
        }
        return null;
    }
}
