/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.expression.ASTNode;
import savilerow.expression.AllDifferent;
import savilerow.expression.BinOp;
import savilerow.expression.BooleanConstant;
import savilerow.expression.ElementOne;
import savilerow.expression.Identifier;
import savilerow.expression.Iff;
import savilerow.expression.InSet;
import savilerow.expression.Intpair;
import savilerow.expression.Less;
import savilerow.expression.LessEqual;
import savilerow.expression.Negate;
import savilerow.expression.NotEqual;
import savilerow.expression.NumberConstant;
import savilerow.expression.ShiftMapper;
import savilerow.expression.UnaryMinus;
import savilerow.expression.WeightedSum;
import savilerow.model.BitVector;
import savilerow.model.PB;
import savilerow.model.SMT;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;
import savilerow.treetransformer.TransformSimplify;

public class Equals
extends BinOp {
    public static final long serialVersionUID = 1L;

    public Equals(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Equals(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp() && this.getChild(1).strongProp();
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!super.typecheck(symbolTable)) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            if (!(this.getChild(i) instanceof Less) && !(this.getChild(i) instanceof LessEqual) && !(this.getChild(i) instanceof Equals) && !(this.getChild(i) instanceof NotEqual)) continue;
            CmdFlags.println("ERROR: Nested non-associative operators: " + String.valueOf(this));
            CmdFlags.println("ERROR: Add brackets to remove ambiguity.");
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        long l;
        long l2;
        long l3;
        Object object;
        if (this.getChild(0).equals(this.getChild(1))) {
            return new BooleanConstant(true);
        }
        if (this.getChild(0).isRelation() && this.getChild(1).isRelation()) {
            return new Iff(this.getChild(0), this.getChild(1));
        }
        if (this.getChild(0) instanceof UnaryMinus && this.getChild(1).isConstant()) {
            return new Equals(this.getChild(0).getChild(0), NumberConstant.make(-this.getChild(1).getValue()));
        }
        if (this.getChild(1) instanceof UnaryMinus && this.getChild(0).isConstant()) {
            return new Equals(this.getChild(1).getChild(0), NumberConstant.make(-this.getChild(0).getValue()));
        }
        if (this.getChild(0).isConstant() && this.getChild(1).isConstant()) {
            return new BooleanConstant(this.getChild(0).getValue() == this.getChild(1).getValue());
        }
        Intpair intpair = this.getChild(0).getBounds();
        Intpair intpair2 = this.getChild(1).getBounds();
        if (intpair.lower > intpair2.upper || intpair.upper < intpair2.lower) {
            return new BooleanConstant(false);
        }
        ASTNode aSTNode = this.getChild(0);
        ASTNode aSTNode2 = this.getChild(1);
        if (aSTNode2 instanceof Identifier) {
            aSTNode = aSTNode2;
            aSTNode2 = this.getChild(0);
        }
        if (aSTNode instanceof Identifier && aSTNode2.isConstant()) {
            TransformSimplify transformSimplify;
            object = ((Identifier)aSTNode).getDomain();
            if (((ASTNode)object).getCategory() == 0 && !((ASTNode)(object = (transformSimplify = new TransformSimplify()).transform((ASTNode)object))).containsValue(aSTNode2.getValue())) {
                return new BooleanConstant(false);
            }
            if (aSTNode.isRelation()) {
                long l4 = aSTNode2.getValue();
                if (l4 == 0L) {
                    return new Negate(aSTNode);
                }
                if (l4 == 1L) {
                    return aSTNode;
                }
            }
        }
        if (this.getChild(0) instanceof WeightedSum && this.getChild(1) instanceof WeightedSum) {
            this.detachChildren();
            return new Equals(BinOp.makeBinOp("-", this.getChild(0), this.getChild(1)), NumberConstant.make(0L));
        }
        if (this.getChild(0) instanceof WeightedSum && this.getChild(0).getCategory() == 3 && this.getChild(1).getCategory() < 3 && (object = ((WeightedSum)this.getChild(0)).retrieveConstant()) != null) {
            this.getChild(1).setParent(null);
            return new Equals((ASTNode)((Pair)object).getSecond(), BinOp.makeBinOp("-", this.getChild(1), ((Pair)object).getFirst()));
        }
        if (this.getChild(1) instanceof WeightedSum && this.getChild(1).getCategory() == 3 && this.getChild(0).getCategory() < 3 && (object = ((WeightedSum)this.getChild(1)).retrieveConstant()) != null) {
            this.getChild(0).setParent(null);
            return new Equals(BinOp.makeBinOp("-", this.getChild(0), ((Pair)object).getFirst()), (ASTNode)((Pair)object).getSecond());
        }
        if (this.getChild(0) instanceof WeightedSum && this.getChild(1).isConstant() && (object = ((WeightedSum)this.getChild(0)).factorOutGCD()) != null) {
            long l5 = ((Pair)object).getFirst().getValue();
            long l6 = this.getChild(1).getValue();
            if (l6 % l5 != 0L) {
                return new BooleanConstant(false);
            }
            return new Equals((ASTNode)((Pair)object).getSecond(), NumberConstant.make(l6 / l5));
        }
        if (this.getChild(1) instanceof WeightedSum && this.getChild(0).isConstant() && (object = ((WeightedSum)this.getChild(1)).factorOutGCD()) != null) {
            long l7 = ((Pair)object).getFirst().getValue();
            long l8 = this.getChild(0).getValue();
            if (l8 % l7 != 0L) {
                return new BooleanConstant(false);
            }
            return new Equals((ASTNode)((Pair)object).getSecond(), NumberConstant.make(l8 / l7));
        }
        if (this.getChild(0) instanceof WeightedSum && this.getChild(0).numChildren() == 2 && this.getChild(1).isConstant() && this.getChild(1).getValue() == 0L && (l3 = ((WeightedSum)this.getChild(0)).getWeight(0)) + (l2 = ((WeightedSum)this.getChild(0)).getWeight(1)) == 0L) {
            this.getChild(0).detachChildren();
            return new Equals(this.getChild(0).getChild(0), this.getChild(0).getChild(1));
        }
        if (this.getChild(1) instanceof WeightedSum && this.getChild(1).numChildren() == 2 && this.getChild(0).isConstant() && this.getChild(0).getValue() == 0L && (l = ((WeightedSum)this.getChild(1)).getWeight(0)) + (l2 = ((WeightedSum)this.getChild(1)).getWeight(1)) == 0L) {
            this.getChild(1).detachChildren();
            return new Equals(this.getChild(1).getChild(0), this.getChild(1).getChild(1));
        }
        if (this.getChild(0).isConstant() && this.getChild(1) instanceof ElementOne && this.getChild(1).getChild(0).getCategory() == 0) {
            ArrayList<Intpair> arrayList = new ArrayList<Intpair>();
            for (int i = 1; i < this.getChild(1).getChild(0).numChildren(); ++i) {
                if (this.getChild(0).getValue() != this.getChild(1).getChild(0).getChild(i).getValue()) continue;
                arrayList.add(new Intpair(i, i));
            }
            return new InSet(this.getChild(1).getChild(1), Intpair.makeDomain(arrayList, false));
        }
        if (this.getChild(1).isConstant() && this.getChild(0) instanceof ElementOne && this.getChild(0).getChild(0).getCategory() == 0) {
            ArrayList<Intpair> arrayList = new ArrayList<Intpair>();
            for (int i = 1; i < this.getChild(0).getChild(0).numChildren(); ++i) {
                if (this.getChild(1).getValue() != this.getChild(0).getChild(0).getChild(i).getValue()) continue;
                arrayList.add(new Intpair(i, i));
            }
            return new InSet(this.getChild(0).getChild(1), Intpair.makeDomain(arrayList, false));
        }
        return null;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        return new AllDifferent(this.getChild(0), this.getChild(1));
    }

    @Override
    public ASTNode normalise() {
        if (this.getChild(0).hashCode() > this.getChild(1).hashCode()) {
            this.detachChildren();
            return new Equals(this.getChild(1), this.getChild(0));
        }
        return this;
    }

    @Override
    public ASTNode normaliseAlpha() {
        if (this.getChild(0).toString().compareTo(this.getChild(1).toString()) > 0) {
            this.detachChildren();
            return new Equals(this.getChild(1), this.getChild(0));
        }
        return null;
    }

    @Override
    public String toString() {
        return "(" + String.valueOf(this.getChild(0)) + "=" + String.valueOf(this.getChild(1)) + ")";
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        if (this.getChild(0).isConstant()) {
            if (CmdFlags.getUseBoundVars() && this.getChild(1).exceedsBoundThreshold()) {
                bufferedWriter.append("eq(");
            } else {
                bufferedWriter.append("w-literal(");
            }
            this.getChild(1).toMinion(bufferedWriter, false);
            bufferedWriter.append(",");
            this.getChild(0).toMinion(bufferedWriter, false);
            bufferedWriter.append(")");
        } else if (this.getChild(1).isConstant()) {
            if (CmdFlags.getUseBoundVars() && this.getChild(0).exceedsBoundThreshold()) {
                bufferedWriter.append("eq(");
            } else {
                bufferedWriter.append("w-literal(");
            }
            this.getChild(0).toMinion(bufferedWriter, false);
            bufferedWriter.append(",");
            this.getChild(1).toMinion(bufferedWriter, false);
            bufferedWriter.append(")");
        } else {
            if (CmdFlags.getUseBoundVars() && (this.getChild(0).exceedsBoundThreshold() || this.getChild(1).exceedsBoundThreshold())) {
                bufferedWriter.append("eq(");
            } else {
                bufferedWriter.append("gaceq(");
            }
            this.getChild(0).toMinion(bufferedWriter, false);
            bufferedWriter.append(",");
            this.getChild(1).toMinion(bufferedWriter, false);
            bufferedWriter.append(")");
        }
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        bufferedWriter.append("constraint int_eq(");
        this.getChild(0).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(",");
        this.getChild(1).toFlatzinc(bufferedWriter, false);
        bufferedWriter.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append("==");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public Long toSATLiteral(Sat sat) {
        if (this.getChild(0).isConstant()) {
            return this.getChild(1).directEncode(sat, this.getChild(0).getValue());
        }
        if (this.getChild(1).isConstant()) {
            return this.getChild(0).directEncode(sat, this.getChild(1).getValue());
        }
        return null;
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        this.encodeEquality(sat, false, 0L);
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        this.encodeEquality(sat, true, l);
        ArrayList<Intpair> arrayList = this.getChild(0).getIntervalSetExp();
        ArrayList<Intpair> arrayList2 = this.getChild(1).getIntervalSetExp();
        for (Intpair intpair : arrayList) {
            for (long i = intpair.lower; i <= intpair.upper; ++i) {
                sat.addClause(-this.getChild(0).directEncode(sat, i), -this.getChild(1).directEncode(sat, i), l);
            }
        }
    }

    private void encodeEquality(Sat sat, boolean bl, long l) throws IOException {
        long l2;
        ArrayList<Intpair> arrayList = this.getChild(0).getIntervalSetExp();
        ArrayList<Intpair> arrayList2 = this.getChild(1).getIntervalSetExp();
        for (Intpair intpair : arrayList) {
            for (l2 = intpair.lower; l2 <= intpair.upper; ++l2) {
                if (bl) {
                    sat.addClause(-this.getChild(0).directEncode(sat, l2), this.getChild(1).directEncode(sat, l2), -l);
                    continue;
                }
                sat.addClause(-this.getChild(0).directEncode(sat, l2), this.getChild(1).directEncode(sat, l2));
            }
        }
        for (Intpair intpair : arrayList2) {
            for (l2 = intpair.lower; l2 <= intpair.upper; ++l2) {
                if (bl) {
                    sat.addClause(-this.getChild(1).directEncode(sat, l2), this.getChild(0).directEncode(sat, l2), -l);
                    continue;
                }
                sat.addClause(-this.getChild(1).directEncode(sat, l2), this.getChild(0).directEncode(sat, l2));
            }
        }
    }

    @Override
    public void toPB(PB pB) throws IOException {
        System.out.println("Woot!");
        if (this.getChild(0) instanceof WeightedSum) {
            ((WeightedSum)this.getChild(0)).toPBOp(pB, 0, this.getChild(1).getValue());
        } else if (this.getChild(1) instanceof WeightedSum) {
            ((WeightedSum)this.getChild(1)).toPBOp(pB, 0, this.getChild(0).getValue());
        } else {
            WeightedSum weightedSum = new WeightedSum(new ASTNode[]{this.getChild(0), this.getChild(1)}, new long[]{1L, -1L});
            weightedSum.toPBOp(pB, 0, 0L);
        }
    }

    @Override
    public void toSMT(SMT sMT) throws IOException {
        if (this.usesSMTEncoding()) {
            sMT.addSMTClause(this.smtEncodeBool(sMT));
        } else {
            this.toSAT(sMT);
        }
    }

    @Override
    public boolean usesSMTEncoding() {
        return CmdFlags.getUseBV() || CmdFlags.getUseNIA() || CmdFlags.getUseLIA() || CmdFlags.getUseIDL() && this.canIDLEncode();
    }

    @Override
    public boolean canIDLEncode() {
        if (this.getChild(0).canVariableEncode() && this.getChild(1).canVariableEncode()) {
            return true;
        }
        if (this.getChild(0) instanceof ShiftMapper && this.getChild(1) instanceof Identifier) {
            return true;
        }
        if (this.getChild(0) instanceof Identifier && this.getChild(1) instanceof ShiftMapper) {
            return true;
        }
        boolean bl = this.getChild(0) instanceof NumberConstant && this.getChild(1).canIDLEncode();
        boolean bl2 = this.getChild(0).canIDLEncode() && this.getChild(1) instanceof NumberConstant;
        return bl || bl2;
    }

    @Override
    public String smtEncodeBool(SMT sMT) {
        Object object = "(= ";
        object = CmdFlags.getUseBV() ? (String)object + this.getChild(0).smtEncodeBV(sMT) + " " + this.getChild(1).smtEncodeBV(sMT) + ")" : (String)object + this.getChild(0).smtEncodeInt(sMT) + " " + this.getChild(1).smtEncodeInt(sMT) + ")";
        return object;
    }

    @Override
    public String smtEncodeInt(SMT sMT) {
        return "(ite " + this.smtEncodeBool(sMT) + " 1 0)";
    }

    @Override
    public String smtEncodeBV(SMT sMT) {
        return "(ite " + this.smtEncodeBool(sMT) + " " + BitVector.toHexString(1L) + " " + BitVector.toHexString(0L) + ")";
    }

    @Override
    public void toMIP(BufferedWriter bufferedWriter) throws IOException {
        if (this.getChild(0) instanceof WeightedSum || this.getChild(0) instanceof UnaryMinus || this.getChild(0) instanceof Identifier) {
            assert (this.getChild(1).isConstant());
            this.getChild(0).toMIP(bufferedWriter);
            bufferedWriter.append(" = ");
            bufferedWriter.append(this.getChild(1).toString());
        } else if (this.getChild(1) instanceof WeightedSum || this.getChild(1) instanceof UnaryMinus || this.getChild(1) instanceof Identifier) {
            assert (this.getChild(0).isConstant());
            this.getChild(1).toMIP(bufferedWriter);
            bufferedWriter.append(" = ");
            bufferedWriter.append(this.getChild(0).toString());
        } else {
            System.out.println(this);
            assert (false) : "missing case in toMip";
        }
    }

    @Override
    public boolean childrenAreSymmetric() {
        return true;
    }

    @Override
    public boolean canChildBeConvertedToDifference(int n) {
        return this.isMyOnlyOtherSiblingEqualZero(n);
    }
}

