/*
 * Decompiled with CFR 0.152.
 */
package savilerow.mdd;

import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.mdd.MDD;
import savilerow.model.Sat;

public class AbioMDDEncoding {
    public static final long serialVersionUID = 1L;
    private Sat satModel;

    public AbioMDDEncoding(Sat sat) {
        this.satModel = sat;
    }

    public long assertMDD(MDD mDD) throws IOException {
        long[] lArray = new long[mDD.getId() + 1];
        for (int i = 0; i <= mDD.getId(); ++i) {
            lArray[i] = Long.MIN_VALUE;
        }
        return this.assertMDD(mDD, lArray);
    }

    private long assertMDD(MDD mDD, long[] lArray) throws IOException {
        if (mDD.isTrueMDD()) {
            return this.satModel.getTrue();
        }
        if (mDD.isFalseMDD()) {
            return -this.satModel.getTrue();
        }
        long l = lArray[mDD.getId()];
        if (l == Long.MIN_VALUE) {
            lArray[mDD.getId()] = l = this.satModel.createAuxSATVariable();
            long l2 = this.assertMDD(mDD.getElseChild(), lArray);
            this.satModel.addClause(l2, -l);
            if (!CmdFlags.getAuxNonFunctional()) {
                ArrayList<Long> arrayList = new ArrayList<Long>();
                arrayList.addAll(mDD.getSelectors());
                arrayList.add(-l2);
                arrayList.add(l);
                this.satModel.addClause(arrayList);
            }
            for (int i = 0; i < mDD.getNSelectors(); ++i) {
                Pair<Long, MDD> pair = mDD.getSelectorAndChild(i);
                if (pair.getSecond() == mDD.getElseChild()) continue;
                long l3 = this.assertMDD(pair.getSecond(), lArray);
                this.satModel.addClause(l3, -pair.getFirst().longValue(), -l);
                if (CmdFlags.getAuxNonFunctional()) continue;
                this.satModel.addClause(-l3, -pair.getFirst().longValue(), l);
            }
        }
        return l;
    }
}

