package savilerow.expression;
/*

    Savile Row http://savilerow.cs.st-andrews.ac.uk/
    Copyright (C) 2014-2024 Peter Nightingale and Luke Ryan
    
    This file is part of Savile Row.
    
    Savile Row is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    
    Savile Row is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with Savile Row.  If not, see <http://www.gnu.org/licenses/>.

*/

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;

import savilerow.CmdFlags;
import savilerow.model.SymbolTable;
import savilerow.treetransformer.TransformDecomposeCumulative;

// Multi-dimensional non-overlap constraint.

public class DiffN extends ASTNodeC {
    public static final long serialVersionUID = 1L;
    public DiffN(ASTNode x, ASTNode y, ASTNode dx, ASTNode dy) {
        super(x, y, dx, dy);
    }
    
    public ASTNode copy() {
        return new DiffN(getChild(0), getChild(1), getChild(2), getChild(3));
    }
    
    public boolean isRelation() {
        return true;
    }
    
    public boolean typecheck(SymbolTable st) {
        for(int i=0; i<4; i++) {
            if(!getChild(i).typecheck(st)) {
                return false;
            }
        }
        if (getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in first argument of diffn: " + this);
            return false;
        }
        if (getChild(1).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in second argument of diffn: " + this);
            return false;
        }
        if (getChild(2).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in third argument of diffn: " + this);
            return false;
        }
        if(getChild(3).getDimension()!=1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in fourth argument of diffn: " + this);
            return false;
        }
        
        return true;
    }
    
    public ASTNode simplify() {
        ASTNode x = getChildConst(0);
        ASTNode y = getChildConst(1);
        ASTNode dx = getChildConst(2);
        ASTNode dy = getChildConst(3);
        
        return null;
    }
    
    /*
    public ASTNode normalise() {
        // sort by hashcode
        if(!(getChild(0) instanceof CompoundMatrix && getChild(1) instanceof CompoundMatrix && getChild(2) instanceof CompoundMatrix)) {
            return this;
        }
        
        ArrayList<ASTNode> ch=new ArrayList<>();
        for(int i=1; i<getChild(0).numChildren(); i++) {
            ch.add(new Container(getChild(0).getChild(i), getChild(1).getChild(i), getChild(2).getChild(i)));
        }
        
        boolean changed = sortByHashcode(ch);
        if (changed) {
            //  Unpack
            ArrayList<ASTNode> x=new ArrayList<>();
            ArrayList<ASTNode> dur=new ArrayList<>();
            ArrayList<ASTNode> res=new ArrayList<>();
            
            for(int i=0; i<ch.size(); i++) {
                x.add(ch.get(i).getChild(0));
                dur.add(ch.get(i).getChild(1));
                res.add(ch.get(i).getChild(2));
            }
            
            return new Cumulative(CompoundMatrix.make(x), CompoundMatrix.make(dur), CompoundMatrix.make(res), getChild(3));
        } else {
            return this;
        }
    }
    
    public ASTNode normaliseAlpha() {
        // sort alphabetically
        if(!(getChild(0) instanceof CompoundMatrix && getChild(1) instanceof CompoundMatrix && getChild(2) instanceof CompoundMatrix)) {
            return null;
        }
        
        ArrayList<ASTNode> ch=new ArrayList<>();
        for(int i=1; i<getChild(0).numChildren(); i++) {
            ch.add(new Container(getChild(0).getChild(i), getChild(1).getChild(i), getChild(2).getChild(i)));
        }
        
        boolean changed = sortByAlpha(ch);
        if (changed) {
            //  Unpack
            ArrayList<ASTNode> x=new ArrayList<>();
            ArrayList<ASTNode> dur=new ArrayList<>();
            ArrayList<ASTNode> res=new ArrayList<>();
            
            for(int i=0; i<ch.size(); i++) {
                x.add(ch.get(i).getChild(0));
                dur.add(ch.get(i).getChild(1));
                res.add(ch.get(i).getChild(2));
            }
            
            return new Cumulative(CompoundMatrix.make(x), CompoundMatrix.make(dur), CompoundMatrix.make(res), getChild(3));
        } else {
            return null;
        }
    }
    */
    
    @Override 
    public void toFlatzinc(BufferedWriter b, boolean bool_context) throws IOException {
        if(CmdFlags.getGecodetrans()) {
            b.append("constraint gecode_nooverlap(");
            getChild(0).toFlatzinc(b, false);
            b.append(",");
            getChild(2).toFlatzinc(b, false);
            b.append(",");
            getChild(1).toFlatzinc(b, false);
            b.append(",");
            getChild(3).toFlatzinc(b, false);
            b.append(");");
        }
        else {
            b.append("constraint fzn_diffn(");
            getChild(0).toFlatzinc(b, false);
            b.append(",");
            getChild(1).toFlatzinc(b, false);
            b.append(",");
            getChild(2).toFlatzinc(b, false);
            b.append(",");
            getChild(3).toFlatzinc(b, false);
            b.append(");");
        }
    }

    @Override
    public void toMinizinc(StringBuilder b, boolean bool_context) {
        b.append("diffn(");
        getChild(0).toMinizinc(b, false);
        b.append(",");
        getChild(1).toMinizinc(b, false);
        b.append(",");
        getChild(2).toMinizinc(b, false);
        b.append(",");
        getChild(3).toMinizinc(b, false);
        b.append(")");
    }
    
    public String toString() {
        return generic_to_string("diffn");
    }
    
    ////////////////////////////////////////////////////////////////////////////
    //  JSON output for symmetry detection
    
    //  Todo
}
