package savilerow.expression;
/*

    Savile Row http://savilerow.cs.st-andrews.ac.uk/
    Copyright (C) 2014-2024 Peter Nightingale
    
    This file is part of Savile Row.
    
    Savile Row is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    
    Savile Row is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with Savile Row.  If not, see <http://www.gnu.org/licenses/>.

*/

import java.io.BufferedWriter;
import java.io.IOException;

import savilerow.CmdFlags;
import savilerow.model.*;

//  Wraps a Boolean expression.  Used by where statements.
//  Outputs a message if child evaluates to false. 

public class FailWhenFalse extends ASTNodeC
{
    public static final long serialVersionUID = 1L;
    private String messageWhenFalse;
    
    public FailWhenFalse(ASTNode ch, String w1) {
        super(ch);
        messageWhenFalse=w1;
    }
    
    public ASTNode copy() {
        return new FailWhenFalse(getChild(0), messageWhenFalse);
    }
    
    public ASTNode simplify() {
        if(getChild(0).isConstant()) {
            long val=getChild(0).getValue();
            if(val==0) {
                CmdFlags.errorExit(messageWhenFalse);
            }
            getChild(0).setParent(null);
            return getChild(0);
        }
        return null;
    }
    
    public boolean isRelation() {
        return true;
    }
}
