/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import savilerow.CmdFlags;
import savilerow.SRWorkThread;
import savilerow.solver.Stats;

public final class EPrimeTailor {
    public static void main(String[] stringArray) {
        CmdFlags.parseArguments(stringArray);
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                if (throwable instanceof OutOfMemoryError) {
                    Stats stats = new Stats();
                    stats.putValue("SavileRowTotalTime", String.valueOf(((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0));
                    stats.putValue("SavileRowUncaughtException", "1");
                    stats.putValue("SavileRowOutOfMemory", "1");
                    stats.makeInfoFiles();
                    CmdFlags.errorExit("Out of Memory");
                } else {
                    Stats stats = new Stats();
                    stats.putValue("SavileRowTotalTime", String.valueOf(((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0));
                    stats.putValue("SavileRowUncaughtException", "1");
                    stats.makeInfoFiles();
                    throwable.printStackTrace(System.err);
                    CmdFlags.errorExit("Savile Row killed by: " + throwable.toString());
                }
            }
        });
        SRWorkThread sRWorkThread = new SRWorkThread();
        sRWorkThread.start();
        if (CmdFlags.getTimeLimit() > 0L) {
            while (System.currentTimeMillis() - CmdFlags.startTime < CmdFlags.getTimeLimit()) {
                try {
                    long l = CmdFlags.getTimeLimit() - (System.currentTimeMillis() - CmdFlags.startTime);
                    if (l <= 0L) continue;
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!CmdFlags.runningSolver) {
                Stats stats = new Stats();
                stats.putValue("SavileRowTotalTime", String.valueOf(((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0));
                stats.putValue("SavileRowTimeOut", "1");
                stats.makeInfoFiles();
                CmdFlags.errorExit("Savile Row timed out.");
            }
        }
    }
}

