/*
 * Decompiled with CFR 0.152.
 */
package savilerow.solver;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.model.Model;
import savilerow.solver.MinisatStats;
import savilerow.solver.ReadProcessOutput;
import savilerow.solver.RunCommand;
import savilerow.solver.SATSolver;
import savilerow.solver.Stats;

public class MinisatSATSolver
extends SATSolver {
    public MinisatSATSolver(Model model) {
        super(model);
    }

    @Override
    public Pair<ArrayList<String>, Stats> runSatSolver(String string, String string2, Model model, Stats stats) throws IOException, InterruptedException {
        CmdFlags.runningSolver = true;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.addAll(CmdFlags.getSolverExtraFlags());
            arrayList.add(string2);
            arrayList.add(CmdFlags.getMinionSolsTempFile());
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ReadProcessOutput readProcessOutput = new ReadProcessOutput(arrayList3);
            double d = System.currentTimeMillis();
            int n = RunCommand.runCommand(true, arrayList, arrayList2, readProcessOutput);
            d = ((double)System.currentTimeMillis() - d) / 1000.0;
            MinisatStats minisatStats = new MinisatStats(arrayList3);
            if (n == 10) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(CmdFlags.getMinionSolsTempFile()));
                ArrayList<Object> arrayList4 = new ArrayList<String>();
                while (bufferedReader.ready()) {
                    String string3 = bufferedReader.readLine();
                    arrayList4.add(string3);
                }
                arrayList4 = new ArrayList<String>(Arrays.asList(((String)arrayList4.get(1)).trim().split(" ")));
                arrayList4.remove(arrayList4.size() - 1);
                return new Pair<ArrayList<String>, Stats>(arrayList4, minisatStats);
            }
            if (n == 20) {
                return new Pair<Object, MinisatStats>(null, minisatStats);
            }
            if (arrayList2.size() != 0 || n != 10 && n != 20) {
                CmdFlags.println("SAT solver exited with error code:" + n + " and message:");
                CmdFlags.println(arrayList2);
            }
            return new Pair<Object, MinisatStats>(null, minisatStats);
        }
        catch (IOException iOException) {
            System.err.println("IOException");
            iOException.printStackTrace();
            CmdFlags.rmTempFiles();
            return new Pair<Object, Object>(null, null);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("InterruptedException.");
            CmdFlags.rmTempFiles();
            return new Pair<Object, Object>(null, null);
        }
    }
}

