/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.Identifier;
import savilerow.expression.Iff;
import savilerow.expression.Less;
import savilerow.expression.LessEqual;
import savilerow.expression.LogicBinOp;
import savilerow.expression.Negate;
import savilerow.expression.Or;
import savilerow.model.SMT;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class Implies
extends LogicBinOp {
    public static final long serialVersionUID = 1L;

    public Implies(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Implies(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean strongProp() {
        return this.getChild(0).strongProp() && this.getChild(1).strongProp();
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0).isConstant() && this.getChild(0).getValue() == 1L) {
            this.getChild(1).setParent(null);
            return this.getChild(1);
        }
        if (this.getChild(0).isConstant() && this.getChild(0).getValue() == 0L) {
            return new BooleanConstant(true);
        }
        if (this.getChild(1).isConstant() && this.getChild(1).getValue() == 1L) {
            return new BooleanConstant(true);
        }
        if (this.getChild(1).isConstant() && this.getChild(1).getValue() == 0L) {
            this.getChild(0).setParent(null);
            return new Negate(this.getChild(0));
        }
        if (this.getChild(0).equals(this.getChild(1))) {
            return new BooleanConstant(true);
        }
        if (this.getChild(0) instanceof And || this.getChild(1) instanceof Or) {
            this.detachChildren();
            return new Or((ASTNode)new Negate(this.getChild(0)), this.getChild(1));
        }
        if (this.getChild(1) instanceof And) {
            ASTNode[] aSTNodeArray = new ASTNode[this.getChild(1).numChildren()];
            for (int i = 0; i < this.getChild(1).numChildren(); ++i) {
                this.getChild(1).getChild(i).setParent(null);
                aSTNodeArray[i] = new Implies(this.getChild(0), this.getChild(1).getChild(i));
            }
            return new And(aSTNodeArray);
        }
        if ((this.getChild(0) instanceof Less || this.getChild(0) instanceof LessEqual) && (this.getChild(1) instanceof Less || this.getChild(1) instanceof LessEqual) && this.getChild(0).getChild(1).equals(this.getChild(1).getChild(1))) {
            ASTNode aSTNode = this.getChild(0).getChild(0);
            ASTNode aSTNode2 = this.getChild(1).getChild(0);
            if (aSTNode.isConstant() && aSTNode2.isConstant()) {
                long l = aSTNode.getValue();
                long l2 = aSTNode2.getValue();
                if (this.getChild(0) instanceof Less) {
                    ++l;
                }
                if (this.getChild(1) instanceof Less) {
                    ++l2;
                }
                if (l2 <= l) {
                    return new BooleanConstant(true);
                }
            }
        }
        if (this.getChild(0) instanceof Negate && this.getChild(1) instanceof Negate) {
            return new Implies(this.getChild(1).getChild(0), this.getChild(0).getChild(0));
        }
        return null;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        return new And(this.getChild(0), new Negate(this.getChild(1)));
    }

    @Override
    public int polarity(int n) {
        if (n == 0) {
            return -this.polarity();
        }
        assert (n == 1);
        return this.polarity();
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (ASTNode aSTNode : this.getChildren()) {
            if (!aSTNode.typecheck(symbolTable)) {
                return false;
            }
            if (aSTNode.isRelation()) continue;
            System.out.println("ERROR: Implication contains non-Boolean expression:" + String.valueOf(aSTNode));
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            if (!(this.getChild(i) instanceof Iff) && !(this.getChild(i) instanceof Implies)) continue;
            CmdFlags.println("ERROR: Nested non-associative operators: " + String.valueOf(this));
            CmdFlags.println("ERROR: Add brackets to remove ambiguity.");
            return false;
        }
        return true;
    }

    @Override
    public void toMinion(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        assert (bl);
        if (this.getChild(1) instanceof Identifier || this.getChild(1) instanceof Negate && this.getChild(1).getChild(0) instanceof Identifier) {
            bufferedWriter.append("ineq(");
            this.getChild(0).toMinion(bufferedWriter, false);
            bufferedWriter.append(", ");
            this.getChild(1).toMinion(bufferedWriter, false);
            bufferedWriter.append(", 0)");
        } else {
            bufferedWriter.append("reifyimply(");
            this.getChild(1).toMinion(bufferedWriter, true);
            bufferedWriter.append(", ");
            this.getChild(0).toMinion(bufferedWriter, false);
            bufferedWriter.append(")");
        }
    }

    @Override
    public void toFlatzinc(BufferedWriter bufferedWriter, boolean bl) throws IOException {
        if (CmdFlags.getOrtoolstrans()) {
            bufferedWriter.append("constraint bool_le(");
            this.getChild(0).toFlatzinc(bufferedWriter, true);
            bufferedWriter.append(",");
            this.getChild(1).toFlatzinc(bufferedWriter, true);
            bufferedWriter.append(");");
        } else {
            bufferedWriter.append("constraint bool_clause([");
            boolean bl2 = false;
            if (this.getChild(0) instanceof Negate) {
                this.getChild(0).getChild(0).toFlatzinc(bufferedWriter, true);
                bl2 = true;
            }
            if (!(this.getChild(1) instanceof Negate)) {
                if (bl2) {
                    bufferedWriter.append(",");
                }
                this.getChild(1).toFlatzinc(bufferedWriter, true);
            }
            bufferedWriter.append("],[");
            bl2 = false;
            if (!(this.getChild(0) instanceof Negate)) {
                this.getChild(0).toFlatzinc(bufferedWriter, true);
                bl2 = true;
            }
            if (this.getChild(1) instanceof Negate) {
                if (bl2) {
                    bufferedWriter.append(",");
                }
                this.getChild(1).getChild(0).toFlatzinc(bufferedWriter, true);
            }
            bufferedWriter.append("]);");
        }
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, true);
        stringBuilder.append("->");
        this.getChild(1).toMinizinc(stringBuilder, true);
        stringBuilder.append(")");
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        assert (this.getChild(0).hasLiteralEncoding());
        if (this.getChild(1).hasLiteralEncoding()) {
            sat.addClause(this.getChild(0).directEncode(sat, 0L), this.getChild(1).directEncode(sat, 1L));
        } else {
            sat.addContextLit(this.getChild(0).directEncode(sat, 0L));
            this.getChild(1).toSAT(sat);
            sat.deleteContextLit();
        }
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(this.getChild(0).directEncode(sat, 0L));
        arrayList.add(this.getChild(1).directEncode(sat, 1L));
        sat.addClauseReified(arrayList, l);
    }

    @Override
    public boolean usesSMTEncoding() {
        return CmdFlags.getUseBV() || CmdFlags.getUseNIA() || CmdFlags.getUseLIA() || CmdFlags.getUseIDL();
    }

    @Override
    public void toSMT(SMT sMT) throws IOException {
        sMT.addSMTClause(this.smtEncodeBool(sMT));
    }

    @Override
    public String smtEncodeBool(SMT sMT) {
        return "(or (not " + this.getChild(0).smtEncodeBool(sMT) + ") " + this.getChild(1).smtEncodeBool(sMT) + ")";
    }

    @Override
    public String smtEncodeBV(SMT sMT) {
        return "(ite " + this.smtEncodeBool(sMT) + " " + SMT.toSMTBV(1L) + " " + SMT.toSMTBV(0L) + ")";
    }

    @Override
    public String smtEncodeInt(SMT sMT) {
        return "(ite " + this.smtEncodeBool(sMT) + " 1 0)";
    }

    @Override
    public String toString() {
        return "(" + String.valueOf(this.getChild(0)) + " -> " + String.valueOf(this.getChild(1)) + ")";
    }
}

