/*
 * Decompiled with CFR 0.152.
 */
package savilerow.model;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.model.Model;
import savilerow.model.Sat;
import savilerow.solver.InteractiveAllMinisatSATSolver;
import savilerow.solver.InteractiveCadicalSATSolver;
import savilerow.solver.InteractiveGlucoseSATSolver;
import savilerow.solver.InteractiveSATSolver;

public class InteractiveSat
extends Sat {
    private InteractiveSATSolver iSolver;
    public static long top = 100000000L;

    public InteractiveSat(Model model) {
        super(model.global_symbols);
        this.initInteractiveSolver(model);
        this.trueVar = this.getNextVariableNumber();
        this.addClause(this.trueVar);
    }

    private void initInteractiveSolver(Model model) {
        if (CmdFlags.getSatFamily().equals("nbc_minisat_all") || CmdFlags.getSatFamily().equals("bc_minisat_all")) {
            this.iSolver = new InteractiveAllMinisatSATSolver(model);
        } else if (CmdFlags.getSatFamily().equals("glucose")) {
            this.iSolver = new InteractiveGlucoseSATSolver(model);
        } else if (CmdFlags.getSatFamily().equals("cadical")) {
            this.iSolver = new InteractiveCadicalSATSolver(model);
        } else {
            CmdFlags.warning("Using default SAT solver: glucose");
            this.iSolver = new InteractiveGlucoseSATSolver(model);
        }
        for (String string : CmdFlags.getSolverExtraFlags()) {
            if (!string.startsWith("seed")) continue;
            String[] stringArray = string.split("=");
            this.iSolver.setRndSeedToISATSolver(Long.parseLong(stringArray[1].trim()));
        }
    }

    public InteractiveSATSolver getInteractiveSolver() {
        return this.iSolver;
    }

    @Override
    public void addComment(String string) {
    }

    @Override
    public void addClause(long l2) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (CmdFlags.getMaxsattrans()) {
            arrayList.add(top);
        }
        if (l2 != -this.trueVar) {
            arrayList.add(l2);
        }
        this.iSolver.addClauseToISATSolver(arrayList.stream().mapToLong(l -> l).toArray());
        ++this.numClauses;
    }

    @Override
    public void addClause(long l2, long l3) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (CmdFlags.getMaxsattrans()) {
            arrayList.add(top);
        }
        if (l2 != -this.trueVar) {
            arrayList.add(l2);
        }
        if (l3 != -this.trueVar) {
            arrayList.add(l3);
        }
        this.iSolver.addClauseToISATSolver(arrayList.stream().mapToLong(l -> l).toArray());
        ++this.numClauses;
    }

    @Override
    public void addClause(long l2, long l3, long l4) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (CmdFlags.getMaxsattrans()) {
            arrayList.add(top);
        }
        if (l2 != -this.trueVar) {
            arrayList.add(l2);
        }
        if (l3 != -this.trueVar) {
            arrayList.add(l3);
        }
        if (l4 != -this.trueVar) {
            arrayList.add(l4);
        }
        this.iSolver.addClauseToISATSolver(arrayList.stream().mapToLong(l -> l).toArray());
        ++this.numClauses;
    }

    @Override
    public void addClause(ArrayList<Long> arrayList) {
        if (CmdFlags.getMaxsattrans()) {
            arrayList.add(0, top);
        }
        arrayList.remove(-this.trueVar);
        this.iSolver.addClauseToISATSolver(arrayList.stream().mapToLong(l -> l).toArray());
        ++this.numClauses;
    }

    @Override
    public void addClauseReified(ArrayList<Long> arrayList, long l) {
        ArrayList<Long> arrayList2 = new ArrayList<Long>(arrayList);
        arrayList2.add(0, -l);
        this.addClause(arrayList2);
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList2.clear();
            arrayList2.add(-arrayList.get(i).longValue());
            arrayList2.add(l);
            this.addClause(arrayList2);
        }
    }

    @Override
    public void addSoftClause(long l, long l2) {
        this.iSolver.addClauseToISATSolver(new long[]{l2, l});
        ++this.numClauses;
    }

    @Override
    public void addClauseAfterFinalise(long l, boolean bl) {
        if (bl) {
            this.iSolver.addToAssumptionQueue(l);
        } else {
            this.addClause(l);
        }
    }

    @Override
    public void addClauseAfterFinalise2(long l, long l2, boolean bl) {
        if (bl) {
            this.iSolver.addToAssumptionQueue(l);
            this.iSolver.addToAssumptionQueue(l2);
        } else {
            this.addClause(l);
            this.addClause(l2);
        }
    }

    @Override
    public void addClauseAfterFinalise(ArrayList<Long> arrayList) {
        this.addClause(arrayList);
    }

    @Override
    public void removeFinalClause() {
    }
}

