/*
 * Decompiled with CFR 0.152.
 */
package savilerow.solver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.expression.ASTNode;
import savilerow.expression.Identifier;
import savilerow.expression.Intpair;
import savilerow.expression.Minimising;
import savilerow.expression.Negate;
import savilerow.expression.Solution;
import savilerow.model.Model;
import savilerow.model.NumberMap;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;
import savilerow.solver.Solver;
import savilerow.solver.Stats;
import savilerow.treetransformer.SubstituteAllValues;
import savilerow.treetransformer.SubstituteValueSatLiteral;
import savilerow.treetransformer.TransformSimplify;
import savilerow.treetransformer.TreeTransformer;

public abstract class SATSolver
extends Solver {
    static int solutionNumber = 1;
    private ArrayList<String> stdout_lines = new ArrayList();
    Model m;

    public SATSolver(Model model) {
        this.m = model;
    }

    @Override
    public void findSolutions(String string, String string2, Model model) throws IOException, InterruptedException {
        if (model.objective != null) {
            this.findObjective(string, string2, model);
        } else if (CmdFlags.getFindAllSolutions() || CmdFlags.getFindNumSolutions() > 1L) {
            if (CmdFlags.getMaxsattrans()) {
                CmdFlags.warning("Ignoring -all-solutions or -num-solutions flag with -maxsat.");
                this.findOneSolution(string, string2, model);
            } else {
                this.findMultipleSolutions(string, string2, model);
            }
        } else {
            this.findOneSolution(string, string2, model);
        }
        CmdFlags.rmTempFiles();
    }

    public abstract Pair<ArrayList<String>, Stats> runSatSolver(String var1, String var2, Model var3, Stats var4) throws IOException, InterruptedException;

    public void findMultipleSolutions(String string, String string2, Model model) {
        double d = ((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0;
        try {
            Stats stats = null;
            while (CmdFlags.getFindAllSolutions() || this.solutionCounter < CmdFlags.getFindNumSolutions()) {
                Pair<ArrayList<String>, Stats> pair = this.runSatSolver(string, string2, model, stats);
                ArrayList<String> arrayList = pair.getFirst();
                Stats stats2 = pair.getSecond();
                stats = stats == null ? stats2 : stats.add(stats2);
                if (arrayList == null) break;
                Solution solution = this.solverSolToAST(arrayList, model.global_symbols);
                model.incumbentSolution = solution;
                this.createSolutionFile(solution, true);
                ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
                ArrayList<Long> arrayList3 = new ArrayList<Long>();
                HashMap<String, Long> hashMap = this.readAllAssignments(arrayList, model.global_symbols);
                for (int i = 1; i < model.branchingon.numChildren(); ++i) {
                    ASTNode aSTNode = model.branchingon.getChild(i);
                    if (aSTNode instanceof Negate) {
                        aSTNode = aSTNode.getChild(0);
                    }
                    if (aSTNode instanceof Identifier) {
                        String string3 = aSTNode.toString();
                        Long l = hashMap.get(string3);
                        if (l == null) continue;
                        Identifier identifier = new Identifier(model, string3);
                        arrayList2.add(identifier);
                        arrayList3.add(l);
                        continue;
                    }
                    if (aSTNode.isConstant()) continue;
                    CmdFlags.errorExit("When using SAT and finding multiple solutions, only variables or negated variables are allowed in the branching on list: " + aSTNode.toString());
                }
                this.addBlockingClause(arrayList2, arrayList3);
            }
            stats.putValue("SavileRowTotalTime", String.valueOf(d));
            this.writeToFileSolutionStats(stats);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addBlockingClause(ArrayList<ASTNode> arrayList, ArrayList<Long> arrayList2) throws IOException {
        ArrayList<Long> arrayList3 = new ArrayList<Long>();
        for (int i = 0; i < arrayList.size(); ++i) {
            long l;
            ASTNode aSTNode = arrayList.get(i);
            long l2 = -aSTNode.directEncode(this.m.satModel, l = arrayList2.get(i).longValue());
            if (l2 == this.m.satModel.getTrue()) {
                arrayList3.add(aSTNode.orderEncode(this.m.satModel, l - 1L));
                arrayList3.add(-aSTNode.orderEncode(this.m.satModel, l));
                continue;
            }
            arrayList3.add(l2);
        }
        this.m.satModel.addClauseAfterFinalise(arrayList3);
    }

    public void findObjective(String string, String string2, Model model) {
        if (CmdFlags.getMaxsattrans() || model.objective.getChild(0).isConstant()) {
            this.findOneSolution(string, string2, model);
        } else if (CmdFlags.getOptStrategy().equals("linear")) {
            this.findObjectiveLinear(string, string2, model);
        } else if (CmdFlags.getOptStrategy().equals("unsat")) {
            this.findObjectiveUnsatMethod(string, string2, model);
        } else {
            assert (CmdFlags.getOptStrategy().equals("bisect"));
            this.findObjectiveBisect(string, string2, model);
        }
    }

    public void findObjectiveLinear(String string, String string2, Model model) {
        double d = ((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0;
        Identifier identifier = (Identifier)model.objective.getChild(0);
        ArrayList<Intpair> arrayList = model.global_symbols.getDomain(identifier.getName()).getIntervalSet();
        ArrayList<String> arrayList2 = null;
        int n = 0;
        Stats stats = null;
        try {
            Object object;
            while (true) {
                if (((Pair)(object = this.runSatSolver(string, string2, model, stats))).getFirst() != null) {
                    arrayList2 = ((Pair)object).getFirst();
                }
                Stats stats2 = ((Pair)object).getSecond();
                if (stats == null) {
                    stats = stats2;
                    stats.putValue("OptimumFound", "0");
                } else {
                    stats = stats.add(stats2);
                }
                if (((Pair)object).getFirst() == null) break;
                HashMap<String, Long> hashMap = this.readAllAssignments(arrayList2, model.global_symbols);
                Long l = hashMap.get(model.objective.getChild(0).toString());
                System.out.println("While optimising, found value: " + l);
                stats.putValue("ObjectiveValue", l.toString());
                CmdFlags.recordIntermediateObjectiveValue(l);
                if (CmdFlags.output_all_sols) {
                    this.createSolutionFile(this.solverSolToAST(arrayList2, model.global_symbols), true);
                }
                this.findObjectiveLinearAddBound(identifier, l);
                ++n;
            }
            if (n > 0) {
                model.incumbentSolution = object = this.solverSolToAST(arrayList2, model.global_symbols);
                if (!CmdFlags.output_all_sols) {
                    this.createSolutionFile((ASTNode)object, false);
                    if (stats.getValue("SolverTimeOut") == "0") {
                        stats.putValue("OptimumFound", "1");
                    }
                }
            } else if (model.incumbentSolution != null) {
                this.createSolutionFile(model.incumbentSolution, CmdFlags.output_all_sols);
                if (stats.getValue("SolverTimeOut") == "0") {
                    stats.putValue("OptimumFound", "1");
                }
            }
            stats.putValue("SavileRowTotalTime", String.valueOf(d));
            this.writeToFileSolutionStats(stats);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void findObjectiveLinearAddBound(Identifier identifier, long l) throws IOException {
        if (this.m.objective instanceof Minimising) {
            this.m.satModel.addClauseAfterFinalise(this.m.satModel.getOrderVariable(identifier.getName(), l - 1L), false);
        } else {
            this.m.satModel.addClauseAfterFinalise(-this.m.satModel.getOrderVariable(identifier.getName(), l), false);
        }
    }

    public void findObjectiveUnsatMethod(String string, String string2, Model model) {
        double d = ((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0;
        Identifier identifier = (Identifier)model.objective.getChild(0);
        ArrayList<Intpair> arrayList = model.global_symbols.getDomain(identifier.getName()).getIntervalSet();
        ArrayList<String> arrayList2 = null;
        boolean bl = false;
        Stats stats = null;
        try {
            block15: {
                long l;
                int n;
                if (model.objective instanceof Minimising) {
                    for (n = 0; n < arrayList.size(); ++n) {
                        for (l = arrayList.get((int)n).lower; l <= arrayList.get((int)n).upper; ++l) {
                            Pair<Stats, ArrayList<String>> pair = this.optTestValue(string, string2, identifier, l, stats);
                            stats = pair.getFirst();
                            stats.putValue("OptimumFound", "0");
                            arrayList2 = pair.getSecond();
                            if (!(arrayList2 != null || stats.hasValue("SolverTimeOut") && stats.getValue("SolverTimeOut").equals("1"))) {
                                continue;
                            }
                            break block15;
                        }
                    }
                } else {
                    for (n = arrayList.size() - 1; n >= 0; --n) {
                        for (l = arrayList.get((int)n).upper; l >= arrayList.get((int)n).lower; --l) {
                            Pair<Stats, ArrayList<String>> pair = this.optTestValue(string, string2, identifier, l, stats);
                            stats = pair.getFirst();
                            stats.putValue("OptimumFound", "0");
                            arrayList2 = pair.getSecond();
                            if (!(arrayList2 != null || stats.hasValue("SolverTimeOut") && stats.getValue("SolverTimeOut").equals("1"))) {
                                continue;
                            }
                            break block15;
                        }
                    }
                }
            }
            if (arrayList2 != null) {
                HashMap<String, Long> hashMap = this.readAllAssignments(arrayList2, model.global_symbols);
                Long l = hashMap.get(model.objective.getChild(0).toString());
                System.out.println("While optimising, found value: " + l);
                stats.putValue("ObjectiveValue", l.toString());
                if (stats.getValue("SolverTimeOut") == "0") {
                    stats.putValue("OptimumFound", "1");
                }
                CmdFlags.recordIntermediateObjectiveValue(l);
                Solution solution = this.solverSolToAST(arrayList2, model.global_symbols);
                model.incumbentSolution = solution;
                this.createSolutionFile(solution, CmdFlags.output_all_sols);
            } else if (model.incumbentSolution != null) {
                if (stats.getValue("SolverTimeOut") == "0") {
                    stats.putValue("OptimumFound", "1");
                }
                this.createSolutionFile(model.incumbentSolution, CmdFlags.output_all_sols);
            }
            stats.putValue("SavileRowTotalTime", String.valueOf(d));
            this.writeToFileSolutionStats(stats);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Pair<Stats, ArrayList<String>> optTestValue(String string, String string2, ASTNode aSTNode, long l, Stats stats) throws IOException, InterruptedException {
        System.out.println("Testing value: " + l);
        this.boundSearchRemovable(aSTNode, l, l);
        Pair<ArrayList<String>, Stats> pair = this.runSatSolver(string, string2, this.m, stats);
        this.m.satModel.removeFinalClause();
        ArrayList<String> arrayList = null;
        if (pair.getFirst() != null) {
            arrayList = pair.getFirst();
        }
        Stats stats2 = pair.getSecond();
        stats = stats == null ? stats2 : stats.add(stats2);
        return new Pair<Stats, ArrayList<String>>(stats, arrayList);
    }

    public void findObjectiveBisect(String string, String string2, Model model) {
        double d = ((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0;
        Identifier identifier = (Identifier)model.objective.getChild(0);
        ArrayList<Intpair> arrayList = model.global_symbols.getDomain(identifier.getName()).getIntervalSet();
        ArrayList<String> arrayList2 = null;
        int n = 0;
        Stats stats = null;
        try {
            long l;
            long l2;
            if (arrayList.size() == 0) {
                l2 = 0L;
                l = 0L;
            } else {
                l2 = arrayList.get((int)0).lower;
                l = arrayList.get((int)(arrayList.size() - 1)).upper;
            }
            System.out.println("In dichotomic search, lower: " + l2 + " upper: " + l);
            Pair<ArrayList<String>, Stats> pair = this.runSatSolver(string, string2, model, stats);
            if (pair.getFirst() != null) {
                arrayList2 = pair.getFirst();
            }
            stats = pair.getSecond();
            stats.putValue("OptimumFound", "0");
            if (pair.getFirst() == null) {
                if (model.incumbentSolution != null) {
                    this.createSolutionFile(model.incumbentSolution, false);
                    stats.putValue("ObjectiveValue", String.valueOf(((Solution)model.incumbentSolution).optval));
                }
                stats.putValue("SavileRowTotalTime", String.valueOf(d));
                this.writeToFileSolutionStats(stats);
                return;
            }
            Serializable serializable = this.readAllAssignments(arrayList2, model.global_symbols);
            Long l3 = serializable.get(model.objective.getChild(0).toString());
            stats.putValue("ObjectiveValue", l3.toString());
            System.out.println("While optimising, found value: " + l3);
            CmdFlags.recordIntermediateObjectiveValue(l3);
            if (CmdFlags.output_all_sols) {
                this.createSolutionFile(this.solverSolToAST(arrayList2, model.global_symbols), true);
            }
            ++n;
            if (model.objective instanceof Minimising) {
                l = l3 - 1L;
            } else {
                l2 = l3 + 1L;
            }
            while (l2 <= l) {
                Stats stats2;
                long l4 = (l - l2 + 1L) / 2L + l2;
                System.out.println("In dichotomic search, lower: " + l2 + " upper: " + l + " midpoint: " + l4);
                this.dichotomicSearch(identifier, l4);
                pair = this.runSatSolver(string, string2, model, stats);
                if (pair.getFirst() != null) {
                    arrayList2 = pair.getFirst();
                }
                if ((stats = stats.add(stats2 = pair.getSecond())).hasValue("SolverTimeOut") && stats.getValue("SolverTimeOut").equals("1")) break;
                if (pair.getFirst() == null) {
                    if (model.objective instanceof Minimising) {
                        l2 = l4 + 1L;
                    } else {
                        l = l4 - 1L;
                    }
                } else {
                    HashMap<String, Long> hashMap = this.readAllAssignments(arrayList2, model.global_symbols);
                    Long l5 = hashMap.get(model.objective.getChild(0).toString());
                    stats.putValue("ObjectiveValue", l5.toString());
                    System.out.println("While optimising, found value: " + l5);
                    CmdFlags.recordIntermediateObjectiveValue(l5);
                    if (CmdFlags.output_all_sols) {
                        this.createSolutionFile(this.solverSolToAST(arrayList2, model.global_symbols), true);
                    }
                    ++n;
                    if (model.objective instanceof Minimising) {
                        l = l5 - 1L;
                    } else {
                        l2 = l5 + 1L;
                    }
                }
                model.satModel.removeFinalClause();
                this.boundSearch(identifier, l, l2);
            }
            if (n > 0) {
                serializable = this.solverSolToAST(arrayList2, model.global_symbols);
                model.incumbentSolution = serializable;
                if (!CmdFlags.output_all_sols) {
                    this.createSolutionFile((ASTNode)serializable, false);
                    if (stats.getValue("SolverTimeOut") == "0") {
                        stats.putValue("OptimumFound", "1");
                    }
                }
            } else if (model.incumbentSolution != null) {
                this.createSolutionFile(model.incumbentSolution, CmdFlags.output_all_sols);
                if (stats.getValue("SolverTimeOut") == "0") {
                    stats.putValue("OptimumFound", "1");
                }
            }
            stats.putValue("SavileRowTotalTime", String.valueOf(d));
            this.writeToFileSolutionStats(stats);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void dichotomicSearch(Identifier identifier, long l) throws IOException {
        if (this.m.objective instanceof Minimising) {
            this.m.satModel.addClauseAfterFinalise(this.m.satModel.getOrderVariable(identifier.getName(), l), true);
        } else {
            this.m.satModel.addClauseAfterFinalise(-this.m.satModel.getOrderVariable(identifier.getName(), l - 1L), true);
        }
    }

    protected void boundSearch(ASTNode aSTNode, long l, long l2) throws IOException {
        this.m.satModel.addClauseAfterFinalise2(this.m.satModel.getOrderVariable(aSTNode.toString(), l), -this.m.satModel.getOrderVariable(aSTNode.toString(), l2 - 1L), false);
    }

    protected void boundSearchRemovable(ASTNode aSTNode, long l, long l2) throws IOException {
        this.m.satModel.addClauseAfterFinalise2(this.m.satModel.getOrderVariable(aSTNode.toString(), l), -this.m.satModel.getOrderVariable(aSTNode.toString(), l2 - 1L), true);
    }

    public void findOneSolution(String string, String string2, Model model) {
        double d = ((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0;
        try {
            Pair<ArrayList<String>, Stats> pair = this.runSatSolver(string, string2, model, null);
            ArrayList<String> arrayList = pair.getFirst();
            Stats stats = pair.getSecond();
            stats.putValue("SavileRowTotalTime", String.valueOf(d));
            if (arrayList != null) {
                ASTNode aSTNode;
                if (model.objective != null) {
                    if (model.objective.getChild(0).isConstant()) {
                        stats.putValue("ObjectiveValue", model.objective.getChild(0).toString());
                        stats.putValue("OptimumFound", "1");
                    } else {
                        aSTNode = model.objective.copy();
                        HashMap<String, Long> hashMap = this.readAllAssignments(arrayList, model.global_symbols);
                        SubstituteAllValues substituteAllValues = new SubstituteAllValues(hashMap);
                        aSTNode = ((TreeTransformer)substituteAllValues).transform(aSTNode);
                        SubstituteValueSatLiteral substituteValueSatLiteral = new SubstituteValueSatLiteral(arrayList);
                        aSTNode = ((TreeTransformer)substituteValueSatLiteral).transform(aSTNode);
                        TransformSimplify transformSimplify = new TransformSimplify();
                        aSTNode = transformSimplify.transform(aSTNode);
                        stats.putValue("ObjectiveValue", aSTNode.getChild(0).toString());
                        if (CmdFlags.getSatSolver().equals("wmaxcdcl")) {
                            stats.putValue("OptimumFound", "1");
                        }
                    }
                }
                model.incumbentSolution = aSTNode = this.solverSolToAST(arrayList, model.global_symbols);
                this.createSolutionFile(aSTNode, false);
            } else if (model.incumbentSolution != null && !CmdFlags.dominanceRelation) {
                this.createSolutionFile(model.incumbentSolution, false);
            } else {
                System.out.println("No solution found.");
            }
            this.writeToFileSolutionStats(stats);
            CmdFlags.rmTempFiles();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    Solution parseOneSolverSolution(SymbolTable symbolTable, BufferedReader bufferedReader) {
        return null;
    }

    @Override
    Solution parseLastSolverSolution(SymbolTable symbolTable, BufferedReader bufferedReader) {
        return null;
    }

    protected void writeToFileSolutionStats(Stats stats) {
        stats.putValue("SATVars", String.valueOf(this.m.satModel.getNumVars()));
        stats.putValue("SATClauses", String.valueOf(this.m.satModel.getNumClauses()));
        if (stats != null) {
            stats.makeInfoFiles();
        }
    }

    @Override
    HashMap<String, Long> readAllAssignments(ArrayList<String> arrayList, SymbolTable symbolTable) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        Sat sat = symbolTable.m.satModel;
        long l = 0L;
        for (int i = 0; i < arrayList.size(); ++i) {
            long l2 = Long.valueOf(arrayList.get(i));
            NumberMap numberMap = sat.getDimacsMapping(l2);
            if (numberMap != null) {
                hashMap.put(numberMap.getVariable(), numberMap.getValue());
                l = l2;
                continue;
            }
            if (l2 > 0L && (numberMap = sat.orderMappingMin.get(l2)) != null) {
                hashMap.put(numberMap.getVariable(), numberMap.getValue());
                l = l2;
                continue;
            }
            if (l2 > 0L && l < 0L && (numberMap = sat.orderMappingMid.get(l2)) != null) {
                hashMap.put(numberMap.getVariable(), numberMap.getValue());
                l = l2;
                continue;
            }
            if (l2 < 0L && (numberMap = sat.orderMappingMax.get(l2)) != null) {
                hashMap.put(numberMap.getVariable(), numberMap.getValue());
                l = l2;
                continue;
            }
            l = l2;
        }
        if (CmdFlags.test_solutions) {
            this.checkSolution(hashMap);
        }
        return hashMap;
    }
}

