/*
 * Decompiled with CFR 0.152.
 */
package savilerow.treetransformer;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.AllDifferent;
import savilerow.expression.And;
import savilerow.expression.Circuit;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Equals;
import savilerow.expression.Identifier;
import savilerow.expression.Implies;
import savilerow.expression.IntegerDomainConcrete;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.SafeElementOne;
import savilerow.expression.ToVariable;
import savilerow.expression.WeightedSum;
import savilerow.model.Model;
import savilerow.treetransformer.NodeReplacement;
import savilerow.treetransformer.TreeTransformerBottomUpNoWrapper;

public class TransformDecomposeCircuit
extends TreeTransformerBottomUpNoWrapper {
    private boolean propagate;

    public TransformDecomposeCircuit(Model model, boolean bl) {
        super(model);
        this.propagate = bl;
    }

    @Override
    protected NodeReplacement processNode(ASTNode aSTNode) {
        if (aSTNode instanceof Circuit) {
            boolean bl;
            boolean bl2 = bl = (CmdFlags.getOrtoolstrans() || CmdFlags.getChuffedtrans() || CmdFlags.getMinizinctrans() || CmdFlags.getGecodetrans() || CmdFlags.getChocotrans()) && !this.propagate;
            if (!bl && !aSTNode.getParent().inTopAnd()) {
                CmdFlags.errorExit("Reified circuit not supported for the chosen backend solver.");
            }
            if (!bl) {
                return new NodeReplacement(this.decomp(aSTNode));
            }
            long l = aSTNode.getChild((int)0).getChild((int)0).getBounds().lower;
            if (l < 0L) {
                ArrayList<ASTNode> arrayList = aSTNode.getChild(0).getChildren(1);
                for (int i = 0; i < arrayList.size(); ++i) {
                    arrayList.set(i, new WeightedSum(arrayList.get(i), NumberConstant.make(-l)));
                }
                IntegerDomainConcrete integerDomainConcrete = new IntegerDomainConcrete(0, arrayList.size() - 1);
                ASTNode aSTNode2 = CompoundMatrix.make((ASTNode)integerDomainConcrete, arrayList, false);
                aSTNode.setChild(0, aSTNode2);
            }
        }
        return null;
    }

    private ASTNode decomp(ASTNode aSTNode) {
        int n;
        ASTNode aSTNode2 = aSTNode.getChildConst(0);
        assert (aSTNode2 instanceof CompoundMatrix);
        ArrayList<Intpair> arrayList = aSTNode2.getChild(0).getIntervalSet();
        if (arrayList.size() > 1) {
            CmdFlags.errorExit("Index domain of matrix in circuit constraint must be a single interval.");
        }
        long l = arrayList.get((int)0).lower;
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        for (n = 1; n < aSTNode2.numChildren(); ++n) {
            arrayList2.add(new AllDifferent(aSTNode2.getChild(n), NumberConstant.make((long)(n - 1) + l)));
        }
        arrayList2.add(new AllDifferent(aSTNode2));
        n = 0;
        if (n != 0) {
            int n2;
            ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
            for (n2 = 1; n2 < aSTNode2.numChildren(); ++n2) {
                Identifier identifier = this.m.global_symbols.newAuxiliaryVariable(aSTNode2.getChild(0));
                arrayList3.add(identifier);
            }
            for (n2 = 0; n2 < arrayList3.size() - 1; ++n2) {
                arrayList2.add(new ToVariable((ASTNode)new SafeElementOne(aSTNode2, new WeightedSum((ASTNode)arrayList3.get(n2), NumberConstant.make(-l + 1L))), (ASTNode)arrayList3.get(n2 + 1)));
            }
            arrayList2.add(new ToVariable((ASTNode)new SafeElementOne(aSTNode2, new WeightedSum((ASTNode)arrayList3.get(arrayList3.size() - 1), NumberConstant.make(-l + 1L))), (ASTNode)arrayList3.get(0)));
            arrayList2.add(new AllDifferent(CompoundMatrix.make(arrayList3)));
            arrayList2.add(new Equals(arrayList3.get(0), NumberConstant.make(l)));
        } else {
            int n3;
            ArrayList<ASTNode> arrayList4 = new ArrayList<ASTNode>();
            for (n3 = 1; n3 < aSTNode2.numChildren(); ++n3) {
                Identifier identifier = this.m.global_symbols.newAuxiliaryVariable(1L, aSTNode2.numChildren() - 1);
                arrayList4.add(identifier);
            }
            arrayList2.add(new AllDifferent(CompoundMatrix.make(arrayList4)));
            arrayList2.add(new Equals(arrayList4.get(0), NumberConstant.make(1L)));
            for (n3 = 0; n3 < arrayList4.size(); ++n3) {
                arrayList2.add(new Implies((ASTNode)new AllDifferent(arrayList4.get(n3), NumberConstant.make(aSTNode2.numChildren() - 1)), new Equals((ASTNode)new SafeElementOne(CompoundMatrix.make(arrayList4), new WeightedSum(aSTNode2.getChild(n3 + 1), NumberConstant.make(-l + 1L))), new WeightedSum(arrayList4.get(n3), NumberConstant.make(1L)))));
                arrayList2.add(new Implies((ASTNode)new Equals(arrayList4.get(n3), NumberConstant.make(aSTNode2.numChildren() - 1)), new Equals(aSTNode2.getChild(n3 + 1), NumberConstant.make(l))));
            }
        }
        return new And(arrayList2);
    }
}

