/*
Copyright 2001 Periklis Sochos

This file is part of PascalFCv1.0.

PascalFCv1.0 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

PascalFCv1.0 is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with PascalFCv1.0; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

package pfc.bin.engine;

import pfc.bin.ui.PFCInterface;
import pfc.bin.console.Console;

import java.io.File;

/**
    The facade class
    for the PFCI system
 */
public class PascalFC {
    static private Console c;
    static private PFCInterface p;
    
    public static void main(String args[]) {
        // Create a platform dependent console
        c = new Console();
        
        // Check if an instance of the 
        // applications already exists
        if(c.anotherInstance()) {
            System.out.println("An instance of the Pascal FC" +
                " is already running!");
            System.exit(0);
        }
        
        if (!c.setEnv()) {
            System.out.println("Unable to Set Up the Environment. Exiting...");        
            System.exit(0);
        }
        p = new PFCInterface();
    }
    
    /**
        It submits the specified file for execution
        @param f the pfc file currently loaded
        @param mode the mode of execution either "-f"
            for a "fair" execution or "-uf" for "unfair"
            execution
     */    
    public void executeFile(File f, String mode) {
        c.executeFile(f, mode);   
    }
    
    /**
        A method to check if the running pfc file
        has completed execution
        @rerutn true if the file has completed execution
            false otherwise
     */    
    public boolean isEndOfFile() {
        return c.isEndOfFile();   
    }
    
    /**
        Returns the next character of running files
        output
        @return a char
     */    
    public char getChar() {
        return c.getChar();   
    }                  
    
    /**
        Stops the currenly running file
        @return a char
     */    
    public void stopExecution() {
        c.stopExecution();   
    }
    
    public String getListFilePath(File loadedFile) {
        return c.getListFilePath(loadedFile);
    }
    
    public String getPmdFilePath(File loadedFile) {
        return c.getPmdFilePath(loadedFile);
    }
}

// To compile any kind of packaged java class you need to:
//    1. Insert the package statement at the top of the file, pfc.bin.engine
//	2. Save the source in: pfc\bin\engine\PascalFC.java
//	3. cd to one dir above the top dir (e.g. above pfc here)
//	4. Compile: javac .\pfc\bin\engine\PascalFC.java
//	5. Run: java -cp .\ pfc.bin.engine.PascalFC







