########################################################################
#
# bigfunc is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
########################################################################
#
#  Project      :  File Preprocessor - bigfunc module
#  Filename     :  $RCSfile: bigfunc.pm,v $
#  Author       :  $Author: darren $
#  Maintainer   :  Darren Miller: darren@cabaret.demon.co.uk
#  File version :  $Revision: 1.3 $
#  Last changed :  $Date: 2002/11/03 22:18:37 $
#  Description  :  This allows last minute processing of stuff
#  Licence      :  GNU copyleft
#
########################################################################
# THIS IS A FILEPP MODULE, YOU NEED FILEPP TO USE IT!!!
# usage: filepp -m bigfunc.pm <files>
########################################################################
package Bigfunc;

use strict;

Filepp::Error("Bigfunc module not fully implemented yet!");

# version number of module
my $VERSION = '0.1.0';

require "function.pm";

my %Defines;
my %DefineArgs;

########################################################################
# Bigfunc keyword - same as bigdef - only difference is any keywords
# in the macro are evaluated when the macro is called rather than
# when the macro is defined.
########################################################################
sub Bigfunc
{
    my $input = shift;
    my $macrodefn = "";
    my $keywordchar = Filepp::GetKeywordchar();

    # check there are brackets () in the function name
    if($input !~ /\(/) {
	Filepp::Error("bigfunc: macro must have brackets [use macro() for 0 arguments]");
      }
    
    # find end of bigfunc
    while($input !~ /^$keywordchar\s*endbigfunc/) {
	$macrodefn = $macrodefn.$input;
	$input = Filepp::GetNextLine();
	if(!$input) { Filepp::Error("bigfunc: End of file found in bigfunc"); }
    }
    # last line of input is #endbigfunc which can be ignored
    
    ########################################################################
    # split macro up into macro and define
    ########################################################################
    # find end of macroword - assume separated by space or tab
    my $i = Filepp::GetNextWordEnd($macrodefn);
    
    # separate macro and defn (can't use split, doesn't work with '0')
    my $macro = substr($macrodefn, 0, $i);
    my $defn  = substr($macrodefn, $i);
    
    # strip leading whitespace from $defn
    if($defn) {
	$defn =~ s/^[ \t]*//;
    }
    else {
	$defn = "";
    }

    # split up macro, args and defn - delimiters = space, (, ), ','
    my @arglist = split(/([\s,\(,\),\,])/, $macro." ".$defn);
    my $macroargs = "";
    my $arg;
    
    # macro is first element in list, remove it from list
    $macro = $arglist[0];
    $arglist[0] = "";
    # loop through list until ')' and find all args
    foreach $arg (@arglist) {
	if($arg) {
	    # end of arg list, leave loop
	    if($arg eq ")") {
		$arg = "";
		last;
	    }
	    # ignore space, ',' and '('
	    elsif($arg =~ /([\s,\,,\(])/) {
		$arg = "";
	    }
	    # argument found, add to ',' separated list
	    else {
		$macroargs = $macroargs.",".$arg;
		$arg = "";
	    }
	}
    }
    $macroargs = Filepp::Strip($macroargs, ",", 1);
    # store args
    $DefineArgs{$macro} = $macroargs;
    
    Filepp::Debug("Define: macro ".$macro." has args (".$macroargs.")");
    # put rest of defn back together
    $defn = "";
    foreach $arg (@arglist) {
	$defn = $defn.$arg;
    }
    $defn = Filepp::CleanStart($defn);

    # define the macro defn pair
    $Defines{$macro} = $defn;
    
    # add a function which will call this macro
    Function::AddFunction($macro, "Bigfunc::Run");
}
Filepp::AddKeyword("bigfunc", "Bigfunc::Bigfunc");

sub Run
{
    my $input;
    my $macro = Function::Running();
    Filepp::Warning("Currently in: <$macro>");
    foreach $input (@_) {
	Filepp::Warning("<$input>");
    }
}




return 1;
########################################################################
# End of file
########################################################################
