! ==============================================================================
! Subroutine: TINT22 (LIST,EB)
! 
! Purpose: Performs a table lookup for the internal energy for two mismatch
!          pairs between two basepairs in a helix.
!
! Method: Uses the MFOLD 3.0 energy function table for RNA @ T=37.
!
! Arguments:
!
!          LIST - Array of length 4 containing the nucleotides in
!                 numerical code (A=1,C=2,G=3,U=4) for the
!                 following locations:
!
!                         (3)(5)        
!                 5' (1) A .  . X (7) 3'
!                 3' (2) U .  . Y (8) 5'
!                         (4)(6)             
!
!                 where LIST(1) = letter code for position 1 etc.
!
!            EB - (OUTPUT) MFOLD 3.0 internal loop energy of the sequence
!                 provided in LIST.
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            01/01/2015   Original Code
!
! Dependencies:
!
! Modules -
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!            Copyright (c) 2015 (Please Refer to LICENCE)
!
! ==============================================================================

      SUBROUTINE TINT22 (LIST,EB)

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        INTEGER, INTENT(IN) :: list(8)
        REAL, INTENT(INOUT) :: eb

        !=== VARIABLES ===!

        INTEGER :: i,j,k,i1,i2,i3,i4,i5,i6,i7,i8
        REAL :: au(96,16),cg(96,16),gc(96,16)
        REAL :: ua(96,16),gu(96,16),ug(96,16)

        DATA (au(1,i),i=1,16) / 2.80, 2.30, 1.70, 2.00, 2.80, 3.40, &
      & 2.00, 3.40, 1.70, 2.00, 2.10, 1.00, 2.00, 3.10, 2.20, 2.90 /
        DATA (au(2,i),i=1,16) / 2.60, 2.20, 1.60, 2.00, 2.60, 2.60, &
      & 2.00, 2.60, 1.60, 2.00, 2.00,-0.20, 2.00, 2.30, 1.10, 1.80 /
        DATA (au(3,i),i=1,16) / 1.50, 1.10, 0.50, 2.00, 1.50, 2.50, &
      & 2.00, 2.50, 0.50, 2.00, 0.90, 0.50, 2.00, 2.20, 1.80, 2.50 /
        DATA (au(4,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
      & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(5,i),i=1,16) / 2.50, 2.10, 1.50, 2.00, 2.50, 2.50, &
      & 2.00, 2.50, 1.50, 2.00, 1.90,-0.30, 2.00, 2.20, 1.00, 1.70 /
        DATA (au(6,i),i=1,16) / 3.10, 2.00, 2.40, 2.00, 2.50, 2.50, &
      & 2.00, 2.50, 2.40, 2.00, 2.40, 0.70, 2.00, 2.20, 1.90, 1.60 /
        DATA (au(7,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
      & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(8,i),i=1,16) / 3.10, 2.00, 2.40, 2.00, 2.50, 2.50, &
      & 2.00, 2.50, 2.40, 2.00, 2.40, 0.70, 2.00, 2.20, 1.90, 1.60 /
        DATA (au(9,i),i=1,16) / 1.50, 1.10, 0.50, 2.00, 1.50, 2.50, &
      & 2.00, 2.50, 0.50, 2.00, 0.90, 0.50, 2.00, 2.20, 1.80, 2.50 /
        DATA (au(10,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(11,i),i=1,16) / 2.10, 1.60, 1.00, 2.00, 2.10, 2.70, &
       & 2.00, 2.70, 1.00, 2.00, 1.40, 0.30, 2.00, 2.40, 1.50, 2.20 /
        DATA (au(12,i),i=1,16) / 2.30, 0.90, 2.10, 2.00, 1.30, 2.30, &
       & 2.00, 2.30, 2.10, 2.00, 1.70,-1.50, 2.00, 2.00,-0.20, 2.30 /
        DATA (au(13,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(14,i),i=1,16) / 3.10, 2.00, 2.40, 2.00, 2.50, 2.50, &
       & 2.00, 2.50, 2.40, 2.00, 2.40, 0.70, 2.00, 2.20, 1.90, 1.60 /
        DATA (au(15,i),i=1,16) / 1.30,-0.10, 1.10, 2.00, 0.30, 1.30, &
       & 2.00, 1.30, 1.10, 2.00, 0.70,-2.50, 2.00, 1.00,-1.20, 1.30 /
        DATA (au(16,i),i=1,16) / 2.70, 1.20, 2.40, 2.00, 1.70, 1.70, &
       & 2.00, 1.70, 2.40, 2.00, 2.00, 0.70, 2.00, 1.40, 1.90, 0.80 /
        DATA (au(17,i),i=1,16) / 2.10, 1.90, 0.10, 2.00, 1.80, 2.50, &
       & 2.00, 1.50, 0.70, 2.00, 1.80, 0.00, 2.00, 2.50, 0.40, 2.10 /
        DATA (au(18,i),i=1,16) / 2.00, 1.70, 0.00, 2.00, 1.70, 1.70, &
       & 2.00, 0.70, 0.60, 2.00, 1.60,-1.20, 2.00, 1.80,-0.80, 1.00 /
        DATA (au(19,i),i=1,16) / 0.90, 0.60,-1.10, 2.00, 0.60, 1.60, &
       & 2.00, 0.70,-0.50, 2.00, 0.50,-0.50, 2.00, 1.70,-0.10, 1.70 /
        DATA (au(20,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(21,i),i=1,16) / 1.90, 1.60,-0.10, 2.00, 1.60, 1.60, &
       & 2.00, 0.60, 0.50, 2.00, 1.50,-1.30, 2.00, 1.70,-0.90, 0.90 /
        DATA (au(22,i),i=1,16) / 2.40, 1.60, 0.80, 2.00, 1.50, 1.60, &
       & 2.00, 0.60, 1.40, 2.00, 2.10,-0.30, 2.00, 1.60, 0.10, 0.80 /
        DATA (au(23,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(24,i),i=1,16) / 2.40, 1.60, 0.80, 2.00, 1.50, 1.60, &
       & 2.00, 0.60, 1.40, 2.00, 2.10,-0.30, 2.00, 1.60, 0.10, 0.80 /
        DATA (au(25,i),i=1,16) / 0.90, 0.60,-1.10, 2.00, 0.60, 1.60, &
       & 2.00, 0.70,-0.50, 2.00, 0.50,-0.50, 2.00, 1.70,-0.10, 1.70 /
        DATA (au(26,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(27,i),i=1,16) / 1.40, 1.20,-0.60, 2.00, 1.10, 1.80, &
       & 2.00, 0.80, 0.00, 2.00, 1.10,-0.70, 2.00, 1.80,-0.30, 1.40 /
        DATA (au(28,i),i=1,16) / 1.70, 0.40, 0.50, 2.00, 0.40, 1.40, &
       & 2.00, 0.50, 1.10, 2.00, 1.30,-2.50, 2.00, 1.50,-2.10, 1.50 /
        DATA (au(29,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(30,i),i=1,16) / 2.40, 1.60, 0.80, 2.00, 1.50, 1.60, &
       & 2.00, 0.60, 1.40, 2.00, 2.10,-0.30, 2.00, 1.60, 0.10, 0.80 /
        DATA (au(31,i),i=1,16) / 0.70,-0.50,-0.50, 2.00,-0.60, 0.50, &
       & 2.00,-0.50, 0.10, 2.00, 0.40,-3.50, 2.00, 0.50,-3.10, 0.50 /
        DATA (au(32,i),i=1,16) / 2.00, 0.80, 0.80, 2.00, 0.70, 0.80, &
       & 2.00,-0.20, 1.50, 2.00, 1.70,-0.30, 2.00, 0.80, 0.10, 0.00 /
        DATA (au(33,i),i=1,16) / 2.00, 1.90, 1.00, 2.00, 2.40, 2.80, &
       & 2.00, 2.70, 1.00, 2.00, 1.80, 0.30, 2.00, 2.70, 1.80, 2.20 /
        DATA (au(34,i),i=1,16) / 1.90, 1.80, 0.90, 2.00, 2.20, 2.10, &
       & 2.00, 1.90, 0.90, 2.00, 1.60,-0.80, 2.00, 1.90, 0.70, 1.00 /
        DATA (au(35,i),i=1,16) / 0.80, 0.70,-0.20, 2.00, 1.10, 2.00, &
       & 2.00, 1.80,-0.20, 2.00, 0.50,-0.10, 2.00, 1.80, 1.40, 1.80 /
        DATA (au(36,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(37,i),i=1,16) / 1.80, 1.70, 0.80, 2.00, 2.10, 2.00, &
       & 2.00, 1.80, 0.80, 2.00, 1.50,-0.90, 2.00, 1.80, 0.60, 0.90 /
        DATA (au(38,i),i=1,16) / 2.30, 1.60, 1.70, 2.00, 2.10, 1.90, &
       & 2.00, 1.80, 1.70, 2.00, 2.10, 0.00, 2.00, 1.80, 1.50, 0.90 /
        DATA (au(39,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(40,i),i=1,16) / 2.30, 1.60, 1.70, 2.00, 2.10, 1.90, &
       & 2.00, 1.80, 1.70, 2.00, 2.10, 0.00, 2.00, 1.80, 1.50, 0.90 /
        DATA (au(41,i),i=1,16) / 0.80, 0.70,-0.20, 2.00, 1.10, 2.00, &
       & 2.00, 1.80,-0.20, 2.00, 0.50,-0.10, 2.00, 1.80, 1.40, 1.80 /
        DATA (au(42,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(43,i),i=1,16) / 1.30, 1.20, 0.30, 2.00, 1.70, 2.10, &
       & 2.00, 2.00, 0.30, 2.00, 1.10,-0.40, 2.00, 2.00, 1.10, 1.50 /
        DATA (au(44,i),i=1,16) / 1.60, 0.50, 1.40, 2.00, 0.90, 1.80, &
       & 2.00, 1.60, 1.40, 2.00, 1.30,-2.10, 2.00, 1.60,-0.60, 1.60 /
        DATA (au(45,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(46,i),i=1,16) / 2.30, 1.60, 1.70, 2.00, 2.10, 1.90, &
       & 2.00, 1.80, 1.70, 2.00, 2.10, 0.00, 2.00, 1.80, 1.50, 0.90 /
        DATA (au(47,i),i=1,16) / 0.60,-0.50, 0.40, 2.00, 0.00, 0.80, &
       & 2.00, 0.70, 0.40, 2.00, 0.40,-3.10, 2.00, 0.70,-1.60, 0.60 /
        DATA (au(48,i),i=1,16) / 1.90, 0.80, 1.80, 2.00, 1.30, 1.10, &
       & 2.00, 1.00, 1.80, 2.00, 1.70, 0.00, 2.00, 1.00, 1.60, 0.10 /
        DATA (au(49,i),i=1,16) / 2.80, 2.50, 1.50, 2.00, 2.60, 3.10, &
       & 2.00, 3.10, 1.50, 2.00, 2.10, 1.30, 2.00, 3.10, 2.30, 2.70 /
        DATA (au(50,i),i=1,16) / 2.60, 2.40, 1.40, 2.00, 2.50, 2.30, &
       & 2.00, 2.30, 1.40, 2.00, 1.90, 0.20, 2.00, 2.30, 1.20, 1.50 /
        DATA (au(51,i),i=1,16) / 1.50, 1.30, 0.30, 2.00, 1.40, 2.20, &
       & 2.00, 2.20, 0.30, 2.00, 0.80, 0.90, 2.00, 2.20, 1.90, 2.20 /
        DATA (au(52,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(53,i),i=1,16) / 2.50, 2.30, 1.30, 2.00, 2.40, 2.20, &
       & 2.00, 2.20, 1.30, 2.00, 1.80, 0.10, 2.00, 2.20, 1.10, 1.40 /
        DATA (au(54,i),i=1,16) / 3.10, 2.20, 2.20, 2.00, 2.30, 2.20, &
       & 2.00, 2.20, 2.20, 2.00, 2.40, 1.00, 2.00, 2.20, 2.00, 1.40 /
        DATA (au(55,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(56,i),i=1,16) / 3.10, 2.20, 2.20, 2.00, 2.30, 2.20, &
       & 2.00, 2.20, 2.20, 2.00, 2.40, 1.00, 2.00, 2.20, 2.00, 1.40 /
        DATA (au(57,i),i=1,16) / 1.50, 1.30, 0.30, 2.00, 1.40, 2.20, &
       & 2.00, 2.20, 0.30, 2.00, 0.80, 0.90, 2.00, 2.20, 1.90, 2.20 /
        DATA (au(58,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(59,i),i=1,16) / 2.10, 1.80, 0.80, 2.00, 1.90, 2.40, &
       & 2.00, 2.40, 0.80, 2.00, 1.40, 0.70, 2.00, 2.40, 1.60, 2.00 /
        DATA (au(60,i),i=1,16) / 2.30, 1.10, 1.90, 2.00, 1.20, 2.00, &
       & 2.00, 2.00, 1.90, 2.00, 1.60,-1.10, 2.00, 2.00,-0.10, 2.00 /
        DATA (au(61,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(62,i),i=1,16) / 3.10, 2.20, 2.20, 2.00, 2.30, 2.20, &
       & 2.00, 2.20, 2.20, 2.00, 2.40, 1.00, 2.00, 2.20, 2.00, 1.40 /
        DATA (au(63,i),i=1,16) / 1.30, 0.10, 0.90, 2.00, 0.20, 1.00, &
       & 2.00, 1.00, 0.90, 2.00, 0.70,-2.10, 2.00, 1.00,-1.10, 1.10 /
        DATA (au(64,i),i=1,16) / 2.70, 1.40, 2.20, 2.00, 1.50, 1.40, &
       & 2.00, 1.40, 2.20, 2.00, 2.00, 1.10, 2.00, 1.40, 2.00, 0.60 /
        DATA (au(65,i),i=1,16) / 2.80, 2.30, 1.70, 2.00, 2.80, 3.40, &
       & 2.00, 3.40, 1.70, 2.00, 2.10, 1.00, 2.00, 3.10, 2.20, 2.90 /
        DATA (au(66,i),i=1,16) / 2.60, 2.20, 1.60, 2.00, 2.60, 2.60, &
       & 2.00, 2.60, 1.60, 2.00, 2.00,-0.20, 2.00, 2.30, 1.10, 1.80 /
        DATA (au(67,i),i=1,16) / 1.50, 1.10, 0.50, 2.00, 1.50, 2.50, &
       & 2.00, 2.50, 0.50, 2.00, 0.90, 0.50, 2.00, 2.20, 1.80, 2.50 /
        DATA (au(68,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(69,i),i=1,16) / 2.50, 2.10, 1.50, 2.00, 2.50, 2.50, &
       & 2.00, 2.50, 1.50, 2.00, 1.90,-0.30, 2.00, 2.20, 1.00, 1.70 /
        DATA (au(70,i),i=1,16) / 3.10, 2.00, 2.40, 2.00, 2.50, 2.50, &
       & 2.00, 2.50, 2.40, 2.00, 2.40, 0.70, 2.00, 2.20, 1.90, 1.60 /
        DATA (au(71,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(72,i),i=1,16) / 3.10, 2.00, 2.40, 2.00, 2.50, 2.50, &
       & 2.00, 2.50, 2.40, 2.00, 2.40, 0.70, 2.00, 2.20, 1.90, 1.60 /
        DATA (au(73,i),i=1,16) / 1.50, 1.10, 0.50, 2.00, 1.50, 2.50, &
       & 2.00, 2.50, 0.50, 2.00, 0.90, 0.50, 2.00, 2.20, 1.80, 2.50 /
        DATA (au(74,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(75,i),i=1,16) / 2.10, 1.60, 1.00, 2.00, 2.10, 2.70, &
       & 2.00, 2.70, 1.00, 2.00, 1.40, 0.30, 2.00, 2.40, 1.50, 2.20 /
        DATA (au(76,i),i=1,16) / 2.30, 0.90, 2.10, 2.00, 1.30, 2.30, &
       & 2.00, 2.30, 2.10, 2.00, 1.70,-1.50, 2.00, 2.00,-0.20, 2.30 /
        DATA (au(77,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(78,i),i=1,16) / 3.10, 2.00, 2.40, 2.00, 2.50, 2.50, &
       & 2.00, 2.50, 2.40, 2.00, 2.40, 0.70, 2.00, 2.20, 1.90, 1.60 /
        DATA (au(79,i),i=1,16) / 1.30,-0.10, 1.10, 2.00, 0.30, 1.30, &
       & 2.00, 1.30, 1.10, 2.00, 0.70,-2.50, 2.00, 1.00,-1.20, 1.30 /
        DATA (au(80,i),i=1,16) / 2.70, 1.20, 2.40, 2.00, 1.70, 1.70, &
       & 2.00, 1.70, 2.40, 2.00, 2.00, 0.70, 2.00, 1.40, 1.90, 0.80 /
        DATA (au(81,i),i=1,16) / 2.80, 2.50, 1.50, 2.00, 2.60, 3.10, &
       & 2.00, 3.10, 1.50, 2.00, 2.10, 1.30, 2.00, 3.10, 2.30, 2.70 /
        DATA (au(82,i),i=1,16) / 2.60, 2.40, 1.40, 2.00, 2.50, 2.30, &
       & 2.00, 2.30, 1.40, 2.00, 1.90, 0.20, 2.00, 2.30, 1.20, 1.50 /
        DATA (au(83,i),i=1,16) / 1.50, 1.30, 0.30, 2.00, 1.40, 2.20, &
       & 2.00, 2.20, 0.30, 2.00, 0.80, 0.90, 2.00, 2.20, 1.90, 2.20 /
        DATA (au(84,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(85,i),i=1,16) / 2.50, 2.30, 1.30, 2.00, 2.40, 2.20, &
       & 2.00, 2.20, 1.30, 2.00, 1.80, 0.10, 2.00, 2.20, 1.10, 1.40 /
        DATA (au(86,i),i=1,16) / 3.10, 2.20, 2.20, 2.00, 2.30, 2.20, &
       & 2.00, 2.20, 2.20, 2.00, 2.40, 1.00, 2.00, 2.20, 2.00, 1.40 /
        DATA (au(87,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(88,i),i=1,16) / 3.10, 2.20, 2.20, 2.00, 2.30, 2.20, &
       & 2.00, 2.20, 2.20, 2.00, 2.40, 1.00, 2.00, 2.20, 2.00, 1.40 /
        DATA (au(89,i),i=1,16) / 1.50, 1.30, 0.30, 2.00, 1.40, 2.20, &
       & 2.00, 2.20, 0.30, 2.00, 0.80, 0.90, 2.00, 2.20, 1.90, 2.20 /
        DATA (au(90,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(91,i),i=1,16) / 2.10, 1.80, 0.80, 2.00, 1.90, 2.40, &
       & 2.00, 2.40, 0.80, 2.00, 1.40, 0.70, 2.00, 2.40, 1.60, 2.00 /
        DATA (au(92,i),i=1,16) / 2.30, 1.10, 1.90, 2.00, 1.20, 2.00, &
       & 2.00, 2.00, 1.90, 2.00, 1.60,-1.10, 2.00, 2.00,-0.10, 2.00 /
        DATA (au(93,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (au(94,i),i=1,16) / 3.10, 2.20, 2.20, 2.00, 2.30, 2.20, &
       & 2.00, 2.20, 2.20, 2.00, 2.40, 1.00, 2.00, 2.20, 2.00, 1.40 /
        DATA (au(95,i),i=1,16) / 1.30, 0.10, 0.90, 2.00, 0.20, 1.00, &
       & 2.00, 1.00, 0.90, 2.00, 0.70,-2.10, 2.00, 1.00,-1.10, 1.10 /
        DATA (au(96,i),i=1,16) / 2.70, 1.40, 2.20, 2.00, 1.50, 1.40, &
       & 2.00, 1.40, 2.20, 2.00, 2.00, 1.10, 2.00, 1.40, 2.00, 0.60 /

        DATA (cg(1,i),i=1,16) / 2.00, 1.60, 1.00, 2.00, 2.00, 2.60, &
      & 2.00, 2.60, 1.00, 2.00, 1.40, 0.20, 2.00, 2.30, 1.50, 2.20 /
        DATA (cg(2,i),i=1,16) / 2.40, 1.90, 1.30, 2.00, 2.40, 2.40, &
      & 2.00, 2.40, 1.30, 2.00, 1.70,-0.40, 2.00, 2.10, 0.80, 1.50 /
        DATA (cg(3,i),i=1,16) / 1.00, 0.60, 0.00, 2.00, 1.00, 2.00, &
      & 2.00, 2.00, 0.00, 2.00, 0.40, 0.00, 2.00, 1.70, 1.30, 2.00 /
        DATA (cg(4,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
      & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(5,i),i=1,16) / 1.90, 1.50, 0.90, 2.00, 1.90, 1.90, &
      & 2.00, 1.90, 0.90, 2.00, 1.30,-0.90, 2.00, 1.60, 0.40, 1.10 /
        DATA (cg(6,i),i=1,16) / 2.80, 1.80, 2.20, 2.00, 2.20, 2.20, &
      & 2.00, 2.20, 2.20, 2.00, 2.20, 0.40, 2.00, 1.90, 1.70, 1.40 /
        DATA (cg(7,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
      & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(8,i),i=1,16) / 2.70, 1.60, 2.00, 2.00, 2.10, 2.10, &
      & 2.00, 2.10, 2.00, 2.00, 2.00, 0.30, 2.00, 1.80, 1.50, 1.20 /
        DATA (cg(9,i),i=1,16) / 1.00, 0.60, 0.00, 2.00, 1.00, 2.00, &
      & 2.00, 2.00, 0.00, 2.00, 0.40, 0.00, 2.00, 1.70, 1.30, 2.00 /
        DATA (cg(10,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(11,i),i=1,16) / 1.80, 1.30, 0.70, 2.00, 1.80, 2.40, &
       & 2.00, 2.40, 0.70, 2.00, 1.10, 0.00, 2.00, 2.10, 1.20, 1.90 /
        DATA (cg(12,i),i=1,16) / 1.80, 0.40, 1.60, 2.00, 0.80, 1.80, &
       & 2.00, 1.80, 1.60, 2.00, 1.20,-2.00, 2.00, 1.50,-0.70, 1.80 /
        DATA (cg(13,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(14,i),i=1,16) / 2.70, 1.60, 2.00, 2.00, 2.10, 2.10, &
       & 2.00, 2.10, 2.00, 2.00, 2.00, 0.30, 2.00, 1.80, 1.50, 1.20 /
        DATA (cg(15,i),i=1,16) / 0.30,-1.10, 0.10, 2.00,-0.70, 0.30, &
       & 2.00, 0.30, 0.10, 2.00,-0.30,-3.50, 2.00, 0.00,-2.20, 0.30 /
        DATA (cg(16,i),i=1,16) / 2.20, 0.70, 1.90, 2.00, 1.20, 1.20, &
       & 2.00, 1.20, 1.90, 2.00, 1.50, 0.20, 2.00, 0.90, 1.50, 0.30 /
        DATA (cg(17,i),i=1,16) / 0.50, 1.10,-0.30, 2.00, 1.10, 1.70, &
       & 2.00, 0.70, 0.40, 2.00, 1.00, 0.10, 2.00, 1.80,-0.50, 1.50 /
        DATA (cg(18,i),i=1,16) / 0.60, 1.50, 0.10, 2.00, 1.10, 1.50, &
       & 2.00, 0.50, 0.50, 2.00, 1.40,-0.70, 2.00, 1.50,-0.60, 0.00 /
        DATA (cg(19,i),i=1,16) / 0.00,-0.70,-1.60, 2.00,-1.00,-0.60, &
       & 2.00, 0.20,-0.70, 2.00, 0.00,-0.80, 2.00, 1.20,-0.60, 0.90 /
        DATA (cg(20,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(21,i),i=1,16) / 1.30, 1.00,-0.70, 2.00, 1.00, 1.00, &
       & 2.00, 0.00, 0.70, 2.00, 0.90,-1.90, 2.00, 1.10,-1.50,-0.20 /
        DATA (cg(22,i),i=1,16) / 2.20, 1.30, 0.70, 2.00, 1.90, 1.30, &
       & 2.00, 0.30, 0.70, 2.00, 1.80,-0.30, 2.00, 1.40,-0.20,-0.10 /
        DATA (cg(23,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(24,i),i=1,16) / 2.00, 1.20, 0.40, 2.00, 1.10, 1.20, &
       & 2.00, 1.70, 1.00, 2.00, 1.70,-0.70, 2.00, 1.20,-0.30, 0.20 /
        DATA (cg(25,i),i=1,16) /-0.20,-0.40,-1.70, 2.00, 0.70, 1.10, &
       & 2.00, 0.20,-0.50, 2.00, 0.00,-0.90, 2.00, 1.20,-1.30, 0.90 /
        DATA (cg(26,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(27,i),i=1,16) / 1.10, 0.90,-0.90, 2.00, 0.80, 1.50, &
       & 2.00, 0.50,-0.20, 2.00, 0.80,-1.00, 2.00, 1.50,-0.60, 1.10 /
        DATA (cg(28,i),i=1,16) / 0.90, 0.00, 0.30, 2.00,-0.10, 1.00, &
       & 2.00, 0.00, 0.60, 2.00, 0.90,-3.00, 2.00, 1.00,-2.40, 0.60 /
        DATA (cg(29,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(30,i),i=1,16) / 2.00, 1.20, 0.40, 2.00, 1.10, 1.20, &
       & 2.00, 0.20, 0.50, 2.00, 1.70,-0.70, 2.00, 1.20,-0.10, 0.40 /
        DATA (cg(31,i),i=1,16) /-0.10,-1.60,-1.60, 2.00,-1.60,-0.60, &
       & 2.00,-1.60,-0.60, 2.00,-0.70,-4.40, 2.00,-0.50,-4.10,-1.00 /
        DATA (cg(32,i),i=1,16) / 1.40, 0.30, 0.50, 2.00, 0.30, 0.30, &
       & 2.00, 0.10, 1.40, 2.00, 1.20,-1.00, 2.00, 0.30, 0.10, 0.60 /
        DATA (cg(33,i),i=1,16) / 1.30, 1.20, 0.30, 2.00, 1.60, 2.10, &
       & 2.00, 1.90, 0.30, 2.00, 1.00,-0.40, 2.00, 1.90, 1.10, 1.40 /
        DATA (cg(34,i),i=1,16) / 1.60, 1.50, 0.60, 2.00, 2.00, 1.80, &
       & 2.00, 1.70, 0.60, 2.00, 1.40,-1.10, 2.00, 1.70, 0.40, 0.80 /
        DATA (cg(35,i),i=1,16) / 0.30, 0.20,-0.70, 2.00, 0.60, 1.50, &
       & 2.00, 1.30,-0.70, 2.00, 0.00,-0.60, 2.00, 1.30, 0.90, 1.30 /
        DATA (cg(36,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(37,i),i=1,16) / 1.20, 1.10, 0.20, 2.00, 1.50, 1.40, &
       & 2.00, 1.20, 0.20, 2.00, 0.90,-1.50, 2.00, 1.20, 0.00, 0.30 /
        DATA (cg(38,i),i=1,16) / 2.10, 1.40, 1.50, 2.00, 1.80, 1.70, &
       & 2.00, 1.50, 1.50, 2.00, 1.80,-0.20, 2.00, 1.50, 1.30, 0.60 /
        DATA (cg(39,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(40,i),i=1,16) / 1.90, 1.20, 1.30, 2.00, 1.70, 1.50, &
       & 2.00, 1.40, 1.30, 2.00, 1.70,-0.40, 2.00, 1.40, 1.10, 0.50 /
        DATA (cg(41,i),i=1,16) / 0.30, 0.20,-0.70, 2.00, 0.60, 1.50, &
       & 2.00, 1.30,-0.70, 2.00, 0.00,-0.60, 2.00, 1.30, 0.90, 1.30 /
        DATA (cg(42,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(43,i),i=1,16) / 1.00, 0.90, 0.00, 2.00, 1.40, 1.80, &
       & 2.00, 1.70, 0.00, 2.00, 0.80,-0.70, 2.00, 1.70, 0.90, 1.20 /
        DATA (cg(44,i),i=1,16) / 1.10, 0.00, 0.90, 2.00, 0.40, 1.30, &
       & 2.00, 1.10, 0.90, 2.00, 0.90,-2.60, 2.00, 1.10,-1.10, 1.10 /
        DATA (cg(45,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(46,i),i=1,16) / 1.90, 1.20, 1.30, 2.00, 1.70, 1.50, &
       & 2.00, 1.40, 1.30, 2.00, 1.70,-0.40, 2.00, 1.40, 1.10, 0.50 /
        DATA (cg(47,i),i=1,16) /-0.40,-1.50,-0.60, 2.00,-1.10,-0.20, &
       & 2.00,-0.40,-0.60, 2.00,-0.70,-4.20, 2.00,-0.40,-2.60,-0.50 /
        DATA (cg(48,i),i=1,16) / 1.40, 0.30, 1.30, 2.00, 0.80, 0.60, &
       & 2.00, 0.50, 1.30, 2.00, 1.20,-0.50, 2.00, 0.50, 1.10,-0.40 /
        DATA (cg(49,i),i=1,16) / 2.00, 1.80, 0.80, 2.00, 1.90, 2.30, &
       & 2.00, 2.30, 0.80, 2.00, 1.30, 0.60, 2.00, 2.30, 1.60, 1.90 /
        DATA (cg(50,i),i=1,16) / 2.40, 2.10, 1.10, 2.00, 2.20, 2.10, &
       & 2.00, 2.10, 1.10, 2.00, 1.70, 0.00, 2.00, 2.10, 0.90, 1.30 /
        DATA (cg(51,i),i=1,16) / 1.00, 0.80,-0.20, 2.00, 0.90, 1.70, &
       & 2.00, 1.70,-0.20, 2.00, 0.30, 0.40, 2.00, 1.70, 1.40, 1.80 /
        DATA (cg(52,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(53,i),i=1,16) / 1.90, 1.70, 0.70, 2.00, 1.80, 1.60, &
       & 2.00, 1.60, 0.70, 2.00, 1.20,-0.50, 2.00, 1.60, 0.50, 0.80 /
        DATA (cg(54,i),i=1,16) / 2.80, 2.00, 2.00, 2.00, 2.10, 1.90, &
       & 2.00, 1.90, 2.00, 2.00, 2.10, 0.80, 2.00, 1.90, 1.80, 1.10 /
        DATA (cg(55,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(56,i),i=1,16) / 2.70, 1.80, 1.80, 2.00, 1.90, 1.80, &
       & 2.00, 1.80, 1.80, 2.00, 2.00, 0.70, 2.00, 1.80, 1.60, 1.00 /
        DATA (cg(57,i),i=1,16) / 1.00, 0.80,-0.20, 2.00, 0.90, 1.70, &
       & 2.00, 1.70,-0.20, 2.00, 0.30, 0.40, 2.00, 1.70, 1.40, 1.80 /
        DATA (cg(58,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(59,i),i=1,16) / 1.80, 1.50, 0.50, 2.00, 1.60, 2.10, &
       & 2.00, 2.10, 0.50, 2.00, 1.10, 0.40, 2.00, 2.10, 1.30, 1.70 /
        DATA (cg(60,i),i=1,16) / 1.80, 0.60, 1.40, 2.00, 0.70, 1.50, &
       & 2.00, 1.50, 1.40, 2.00, 1.10,-1.60, 2.00, 1.50,-0.60, 1.60 /
        DATA (cg(61,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(62,i),i=1,16) / 2.70, 1.80, 1.80, 2.00, 1.90, 1.80, &
       & 2.00, 1.80, 1.80, 2.00, 2.00, 0.70, 2.00, 1.80, 1.60, 1.00 /
        DATA (cg(63,i),i=1,16) / 0.30,-0.90,-0.10, 2.00,-0.80, 0.00, &
       & 2.00, 0.00,-0.10, 2.00,-0.40,-3.10, 2.00, 0.00,-2.10, 0.00 /
        DATA (cg(64,i),i=1,16) / 2.20, 0.90, 1.80, 2.00, 1.00, 0.90, &
       & 2.00, 0.90, 1.80, 2.00, 1.50, 0.60, 2.00, 0.90, 1.60, 0.10 /
        DATA (cg(65,i),i=1,16) / 2.00, 1.60, 1.00, 2.00, 2.00, 2.60, &
       & 2.00, 2.60, 1.00, 2.00, 1.40, 0.20, 2.00, 2.30, 1.50, 2.20 /
        DATA (cg(66,i),i=1,16) / 2.40, 1.90, 1.30, 2.00, 2.40, 2.40, &
       & 2.00, 2.40, 1.30, 2.00, 1.70,-0.40, 2.00, 2.10, 0.80, 1.50 /
        DATA (cg(67,i),i=1,16) / 1.00, 0.60, 0.00, 2.00, 1.00, 2.00, &
       & 2.00, 2.00, 0.00, 2.00, 0.40, 0.00, 2.00, 1.70, 1.30, 2.00 /
        DATA (cg(68,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(69,i),i=1,16) / 1.90, 1.50, 0.90, 2.00, 1.90, 1.90, &
       & 2.00, 1.90, 0.90, 2.00, 1.30,-0.90, 2.00, 1.60, 0.40, 1.10 /
        DATA (cg(70,i),i=1,16) / 2.80, 1.80, 2.20, 2.00, 2.20, 2.20, &
       & 2.00, 2.20, 2.20, 2.00, 2.20, 0.40, 2.00, 1.90, 1.70, 1.40 /
        DATA (cg(71,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(72,i),i=1,16) / 2.70, 1.60, 2.00, 2.00, 2.10, 2.10, &
       & 2.00, 2.10, 2.00, 2.00, 2.00, 0.30, 2.00, 1.80, 1.50, 1.20 /
        DATA (cg(73,i),i=1,16) / 1.00, 0.60, 0.00, 2.00, 1.00, 2.00, &
       & 2.00, 2.00, 0.00, 2.00, 0.40, 0.00, 2.00, 1.70, 1.30, 2.00 /
        DATA (cg(74,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(75,i),i=1,16) / 1.80, 1.30, 0.70, 2.00, 1.80, 2.40, &
       & 2.00, 2.40, 0.70, 2.00, 1.10, 0.00, 2.00, 2.10, 1.20, 1.90 /
        DATA (cg(76,i),i=1,16) / 1.80, 0.40, 1.60, 2.00, 0.80, 1.80, &
       & 2.00, 1.80, 1.60, 2.00, 1.20,-2.00, 2.00, 1.50,-0.70, 1.80 /
        DATA (cg(77,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(78,i),i=1,16) / 2.70, 1.60, 2.00, 2.00, 2.10, 2.10, &
       & 2.00, 2.10, 2.00, 2.00, 2.00, 0.30, 2.00, 1.80, 1.50, 1.20 /
        DATA (cg(79,i),i=1,16) / 0.30,-1.10, 0.10, 2.00,-0.70, 0.30, &
       & 2.00, 0.30, 0.10, 2.00,-0.30,-3.50, 2.00, 0.00,-2.20, 0.30 /
        DATA (cg(80,i),i=1,16) / 2.20, 0.70, 1.90, 2.00, 1.20, 1.20, &
       & 2.00, 1.20, 1.90, 2.00, 1.50, 0.20, 2.00, 0.90, 1.50, 0.30 /
        DATA (cg(81,i),i=1,16) / 2.00, 1.80, 0.80, 2.00, 1.90, 2.30, &
       & 2.00, 2.30, 0.80, 2.00, 1.30, 0.60, 2.00, 2.30, 1.60, 1.90 /
        DATA (cg(82,i),i=1,16) / 2.40, 2.10, 1.10, 2.00, 2.20, 2.10, &
       & 2.00, 2.10, 1.10, 2.00, 1.70, 0.00, 2.00, 2.10, 0.90, 1.30 /
        DATA (cg(83,i),i=1,16) / 1.00, 0.80,-0.20, 2.00, 0.90, 1.70, &
       & 2.00, 1.70,-0.20, 2.00, 0.30, 0.40, 2.00, 1.70, 1.40, 1.80 /
        DATA (cg(84,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(85,i),i=1,16) / 1.90, 1.70, 0.70, 2.00, 1.80, 1.60, &
       & 2.00, 1.60, 0.70, 2.00, 1.20,-0.50, 2.00, 1.60, 0.50, 0.80 /
        DATA (cg(86,i),i=1,16) / 2.80, 2.00, 2.00, 2.00, 2.10, 1.90, &
       & 2.00, 1.90, 2.00, 2.00, 2.10, 0.80, 2.00, 1.90, 1.80, 1.10 /
        DATA (cg(87,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(88,i),i=1,16) / 2.70, 1.80, 1.80, 2.00, 1.90, 1.80, &
       & 2.00, 1.80, 1.80, 2.00, 2.00, 0.70, 2.00, 1.80, 1.60, 1.00 /
        DATA (cg(89,i),i=1,16) / 1.00, 0.80,-0.20, 2.00, 0.90, 1.70, &
       & 2.00, 1.70,-0.20, 2.00, 0.30, 0.40, 2.00, 1.70, 1.40, 1.80 /
        DATA (cg(90,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(91,i),i=1,16) / 1.80, 1.50, 0.50, 2.00, 1.60, 2.10, &
       & 2.00, 2.10, 0.50, 2.00, 1.10, 0.40, 2.00, 2.10, 1.30, 1.70 /
        DATA (cg(92,i),i=1,16) / 1.80, 0.60, 1.40, 2.00, 0.70, 1.50, &
       & 2.00, 1.50, 1.40, 2.00, 1.10,-1.60, 2.00, 1.50,-0.60, 1.60 /
        DATA (cg(93,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (cg(94,i),i=1,16) / 2.70, 1.80, 1.80, 2.00, 1.90, 1.80, &
       & 2.00, 1.80, 1.80, 2.00, 2.00, 0.70, 2.00, 1.80, 1.60, 1.00 /
        DATA (cg(95,i),i=1,16) / 0.30,-0.90,-0.10, 2.00,-0.80, 0.00, &
       & 2.00, 0.00,-0.10, 2.00,-0.40,-3.10, 2.00, 0.00,-2.10, 0.00 /
        DATA (cg(96,i),i=1,16) / 2.20, 0.90, 1.80, 2.00, 1.00, 0.90, &
       & 2.00, 0.90, 1.80, 2.00, 1.50, 0.60, 2.00, 0.90, 1.60, 0.10 /

        DATA (gc(1,i),i=1,16) / 2.10, 1.70, 1.10, 2.00, 2.10, 2.70, &
      & 2.00, 2.70, 1.10, 2.00, 1.50, 0.30, 2.00, 2.40, 1.60, 2.30 /
        DATA (gc(2,i),i=1,16) / 1.80, 1.40, 0.80, 2.00, 1.80, 1.80, &
      & 2.00, 1.80, 0.80, 2.00, 1.20,-1.00, 2.00, 1.50, 0.30, 1.00 /
        DATA (gc(3,i),i=1,16) / 0.70, 0.30,-0.30, 2.00, 0.70, 1.70, &
      & 2.00, 1.70,-0.30, 2.00, 0.10,-0.30, 2.00, 1.40, 1.00, 1.70 /
        DATA (gc(4,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
      & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(5,i),i=1,16) / 1.90, 1.40, 0.80, 2.00, 1.90, 1.90, &
      & 2.00, 1.90, 0.80, 2.00, 1.20,-0.90, 2.00, 1.60, 0.30, 1.00 /
        DATA (gc(6,i),i=1,16) / 2.50, 1.40, 1.80, 2.00, 1.90, 1.90, &
      & 2.00, 1.90, 1.80, 2.00, 1.80, 0.10, 2.00, 1.60, 1.30, 1.00 /
        DATA (gc(7,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
      & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(8,i),i=1,16) / 2.50, 1.50, 1.90, 2.00, 1.90, 1.90, &
      & 2.00, 1.90, 1.90, 2.00, 1.90, 0.10, 2.00, 1.60, 1.40, 1.10 /
        DATA (gc(9,i),i=1,16) / 0.10,-0.30,-0.90, 2.00, 0.10, 1.10, &
      & 2.00, 1.10,-0.90, 2.00,-0.50,-0.90, 2.00, 0.80, 0.40, 1.10 /
        DATA (gc(10,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(11,i),i=1,16) / 1.80, 1.30, 0.70, 2.00, 1.80, 2.40, &
       & 2.00, 2.40, 0.70, 2.00, 1.10, 0.00, 2.00, 2.10, 1.20, 1.90 /
        DATA (gc(12,i),i=1,16) / 0.40,-1.10, 0.10, 2.00,-0.60, 0.40, &
       & 2.00, 0.40, 0.10, 2.00,-0.30,-3.50, 2.00, 0.10,-2.20, 0.30 /
        DATA (gc(13,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(14,i),i=1,16) / 1.50, 0.40, 0.90, 2.00, 0.90, 0.90, &
       & 2.00, 0.90, 0.90, 2.00, 0.80,-0.90, 2.00, 0.60, 0.40, 0.00 /
        DATA (gc(15,i),i=1,16) / 0.00,-1.50,-0.30, 2.00,-1.00, 0.00, &
       & 2.00, 0.00,-0.30, 2.00,-0.70,-3.90, 2.00,-0.30,-2.60,-0.10 /
        DATA (gc(16,i),i=1,16) / 2.10, 0.70, 1.90, 2.00, 1.10, 1.10, &
       & 2.00, 1.10, 1.90, 2.00, 1.50, 0.10, 2.00, 0.80, 1.40, 0.30 /
        DATA (gc(17,i),i=1,16) / 1.50, 1.20,-0.50, 2.00, 1.20, 1.80, &
       & 2.00, 0.80, 0.10, 2.00, 1.10,-0.70, 2.00, 1.90,-0.30, 1.50 /
        DATA (gc(18,i),i=1,16) / 1.20, 0.90,-0.80, 2.00, 0.90, 0.90, &
       & 2.00, 0.00,-0.20, 2.00, 0.80,-2.00, 2.00, 1.00,-1.60, 0.20 /
        DATA (gc(19,i),i=1,16) / 0.10,-0.10,-1.90, 2.00,-0.20, 0.90, &
       & 2.00,-0.10,-1.30, 2.00,-0.20,-1.30, 2.00, 0.90,-0.90, 0.90 /
        DATA (gc(20,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(21,i),i=1,16) / 1.20, 1.00,-0.80, 2.00, 0.90, 1.00, &
       & 2.00, 0.00,-0.10, 2.00, 0.90,-1.90, 2.00, 1.00,-1.50, 0.20 /
        DATA (gc(22,i),i=1,16) / 1.80, 1.00, 0.20, 2.00, 0.90, 1.00, &
       & 2.00, 0.00, 0.90, 2.00, 1.50,-0.90, 2.00, 1.00,-0.50, 0.20 /
        DATA (gc(23,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(24,i),i=1,16) / 1.90, 1.00, 0.30, 2.00, 1.00, 1.00, &
       & 2.00, 0.00, 0.90, 2.00, 1.50,-0.90, 2.00, 1.10,-0.50, 0.30 /
        DATA (gc(25,i),i=1,16) /-0.50,-0.80,-2.60, 2.00,-0.80, 0.20, &
       & 2.00,-0.80,-1.90, 2.00,-0.90,-1.90, 2.00, 0.30,-1.50, 0.30 /
        DATA (gc(26,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(27,i),i=1,16) / 1.10, 0.90,-0.90, 2.00, 0.80, 1.50, &
       & 2.00, 0.50,-0.20, 2.00, 0.80,-1.00, 2.00, 1.50,-0.60, 1.10 /
        DATA (gc(28,i),i=1,16) /-0.30,-1.50,-1.50, 2.00,-1.60,-0.50, &
       & 2.00,-1.50,-0.90, 2.00,-0.60,-4.50, 2.00,-0.50,-4.10,-0.50 /
        DATA (gc(29,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(30,i),i=1,16) / 0.80, 0.00,-0.80, 2.00, 0.00, 0.00, &
       & 2.00,-1.00,-0.10, 2.00, 0.50,-1.90, 2.00, 0.00,-1.50,-0.70 /
        DATA (gc(31,i),i=1,16) /-0.70,-1.90,-1.90, 2.00,-2.00,-0.90, &
       & 2.00,-1.90,-1.30, 2.00,-1.00,-4.90, 2.00,-0.90,-4.50,-0.90 /
        DATA (gc(32,i),i=1,16) / 1.50, 0.20, 0.30, 2.00, 0.20, 0.20, &
       & 2.00,-0.70, 0.90, 2.00, 1.10,-0.90, 2.00, 0.30,-0.50,-0.50 /
        DATA (gc(33,i),i=1,16) / 0.50, 1.30,-0.20, 2.00, 0.60, 2.20, &
       & 2.00, 2.00, 0.00, 2.00, 1.10,-0.10, 2.00, 2.00, 0.90, 1.40 /
        DATA (gc(34,i),i=1,16) / 1.10, 1.00, 0.70, 2.00, 1.10, 1.90, &
       & 2.00, 1.10,-1.00, 2.00, 0.80,-1.60, 2.00, 1.10,-0.10, 0.30 /
        DATA (gc(35,i),i=1,16) / 0.40, 0.70,-0.50, 2.00, 0.50, 0.70, &
       & 2.00, 0.50,-0.70, 2.00,-0.20,-0.60, 2.00, 1.00, 0.60, 1.40 /
        DATA (gc(36,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(37,i),i=1,16) / 1.10, 1.00,-0.40, 2.00, 1.50, 1.30, &
       & 2.00, 1.20,-0.70, 2.00, 0.90,-1.60, 2.00, 1.20, 0.00, 0.30 /
        DATA (gc(38,i),i=1,16) / 1.70, 1.00, 1.10, 2.00, 1.50, 1.30, &
       & 2.00, 1.20,-0.60, 2.00, 1.50,-0.60, 2.00, 1.20, 1.00, 0.30 /
        DATA (gc(39,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(40,i),i=1,16) / 1.80, 1.10, 1.20, 2.00, 1.50, 1.40, &
       & 2.00, 1.20, 1.20, 2.00, 1.50,-0.50, 2.00, 1.20, 1.00, 0.30 /
        DATA (gc(41,i),i=1,16) /-0.30,-0.70,-1.70, 2.00, 0.10, 0.70, &
       & 2.00, 0.40,-1.60, 2.00,-0.90,-1.60, 2.00, 0.40, 0.30, 0.50 /
        DATA (gc(42,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(43,i),i=1,16) / 1.00, 0.90, 0.00, 2.00, 1.40, 1.80, &
       & 2.00, 1.70, 0.00, 2.00, 0.80,-0.70, 2.00, 1.70, 0.90, 1.20 /
        DATA (gc(44,i),i=1,16) /-0.50,-1.50,-1.30, 2.00,-0.60,-0.20, &
       & 2.00,-0.10,-0.60, 2.00,-0.60,-4.10, 2.00,-0.30,-2.40, 0.10 /
        DATA (gc(45,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(46,i),i=1,16) / 0.70, 0.00, 0.20, 2.00, 0.50, 0.30, &
       & 2.00, 0.20, 0.20, 2.00, 0.50,-1.60, 2.00, 1.70, 0.00, 0.10 /
        DATA (gc(47,i),i=1,16) / 0.10,-1.90,-0.90, 2.00,-0.70,-0.30, &
       & 2.00,-0.70,-0.80, 2.00,-1.00,-4.40, 2.00,-0.70,-3.00,-1.00 /
        DATA (gc(48,i),i=1,16) / 1.50,-0.20, 0.90, 2.00, 0.00,-0.10, &
       & 2.00, 0.40, 0.90, 2.00, 1.10,-1.00, 2.00, 0.20, 0.60, 0.60 /
        DATA (gc(49,i),i=1,16) / 2.10, 1.90, 0.90, 2.00, 2.00, 2.40, &
       & 2.00, 2.40, 0.90, 2.00, 1.40, 0.70, 2.00, 2.40, 1.70, 2.00 /
        DATA (gc(50,i),i=1,16) / 1.80, 1.60, 0.60, 2.00, 1.70, 1.50, &
       & 2.00, 1.50, 0.60, 2.00, 1.10,-0.60, 2.00, 1.50, 0.40, 0.70 /
        DATA (gc(51,i),i=1,16) / 0.70, 0.50,-0.50, 2.00, 0.60, 1.40, &
       & 2.00, 1.40,-0.50, 2.00, 0.00, 0.10, 2.00, 1.40, 1.10, 1.50 /
        DATA (gc(52,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(53,i),i=1,16) / 1.90, 1.60, 0.60, 2.00, 1.70, 1.60, &
       & 2.00, 1.60, 0.60, 2.00, 1.20,-0.50, 2.00, 1.60, 0.40, 0.80 /
        DATA (gc(54,i),i=1,16) / 2.50, 1.60, 1.60, 2.00, 1.70, 1.60, &
       & 2.00, 1.60, 1.60, 2.00, 1.80, 0.50, 2.00, 1.60, 1.40, 0.80 /
        DATA (gc(55,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(56,i),i=1,16) / 2.50, 1.70, 1.70, 2.00, 1.80, 1.60, &
       & 2.00, 1.60, 1.70, 2.00, 1.80, 0.50, 2.00, 1.60, 1.50, 0.80 /
        DATA (gc(57,i),i=1,16) / 0.10,-0.10,-1.10, 2.00, 0.00, 0.80, &
       & 2.00, 0.80,-1.10, 2.00,-0.60,-0.50, 2.00, 0.80, 0.50, 0.80 /
        DATA (gc(58,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(59,i),i=1,16) / 1.80, 1.50, 0.50, 2.00, 1.60, 2.10, &
       & 2.00, 2.10, 0.50, 2.00, 1.10, 0.40, 2.00, 2.10, 1.30, 1.70 /
        DATA (gc(60,i),i=1,16) / 0.40,-0.90,-0.10, 2.00,-0.80, 0.10, &
       & 2.00, 0.10,-0.10, 2.00,-0.30,-3.10, 2.00, 0.10,-2.10, 0.10 /
        DATA (gc(61,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(62,i),i=1,16) / 1.50, 0.60, 0.70, 2.00, 0.70, 0.60, &
       & 2.00, 0.60, 0.70, 2.00, 0.80,-0.50, 2.00, 0.60, 0.50,-0.20 /
        DATA (gc(63,i),i=1,16) / 0.00,-1.30,-0.50, 2.00,-1.20,-0.30, &
       & 2.00,-0.30,-0.50, 2.00,-0.70,-3.50, 2.00,-0.30,-2.50,-0.30 /
        DATA (gc(64,i),i=1,16) / 2.10, 0.90, 1.70, 2.00, 1.00, 0.80, &
       & 2.00, 0.80, 1.70, 2.00, 1.40, 0.50, 2.00, 0.80, 1.50, 0.00 /
        DATA (gc(65,i),i=1,16) / 2.10, 1.70, 1.10, 2.00, 2.10, 2.70, &
       & 2.00, 2.70, 1.10, 2.00, 1.50, 0.30, 2.00, 2.40, 1.60, 2.30 /
        DATA (gc(66,i),i=1,16) / 1.80, 1.40, 0.80, 2.00, 1.80, 1.80, &
       & 2.00, 1.80, 0.80, 2.00, 1.20,-1.00, 2.00, 1.50, 0.30, 1.00 /
        DATA (gc(67,i),i=1,16) / 0.70, 0.30,-0.30, 2.00, 0.70, 1.70, &
       & 2.00, 1.70,-0.30, 2.00, 0.10,-0.30, 2.00, 1.40, 1.00, 1.70 /
        DATA (gc(68,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(69,i),i=1,16) / 1.90, 1.40, 0.80, 2.00, 1.90, 1.90, &
       & 2.00, 1.90, 0.80, 2.00, 1.20,-0.90, 2.00, 1.60, 0.30, 1.00 /
        DATA (gc(70,i),i=1,16) / 2.50, 1.40, 1.80, 2.00, 1.90, 1.90, &
       & 2.00, 1.90, 1.80, 2.00, 1.80, 0.10, 2.00, 1.60, 1.30, 1.00 /
        DATA (gc(71,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(72,i),i=1,16) / 2.50, 1.50, 1.90, 2.00, 1.90, 1.90, &
       & 2.00, 1.90, 1.90, 2.00, 1.90, 0.10, 2.00, 1.60, 1.40, 1.10 /
        DATA (gc(73,i),i=1,16) / 0.10,-0.30,-0.90, 2.00, 0.10, 1.10, &
       & 2.00, 1.10,-0.90, 2.00,-0.50,-0.90, 2.00, 0.80, 0.40, 1.10 /
        DATA (gc(74,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(75,i),i=1,16) / 1.80, 1.30, 0.70, 2.00, 1.80, 2.40, &
       & 2.00, 2.40, 0.70, 2.00, 1.10, 0.00, 2.00, 2.10, 1.20, 1.90 /
        DATA (gc(76,i),i=1,16) / 0.40,-1.10, 0.10, 2.00,-0.60, 0.40, &
       & 2.00, 0.40, 0.10, 2.00,-0.30,-3.50, 2.00, 0.10,-2.20, 0.30 /
        DATA (gc(77,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(78,i),i=1,16) / 1.50, 0.40, 0.90, 2.00, 0.90, 0.90, &
       & 2.00, 0.90, 0.90, 2.00, 0.80,-0.90, 2.00, 0.60, 0.40, 0.00 /
        DATA (gc(79,i),i=1,16) / 0.00,-1.50,-0.30, 2.00,-1.00, 0.00, &
       & 2.00, 0.00,-0.30, 2.00,-0.70,-3.90, 2.00,-0.30,-2.60,-0.10 /
        DATA (gc(80,i),i=1,16) / 2.10, 0.70, 1.90, 2.00, 1.10, 1.10, &
       & 2.00, 1.10, 1.90, 2.00, 1.50, 0.10, 2.00, 0.80, 1.40, 0.30 /
        DATA (gc(81,i),i=1,16) / 2.10, 1.90, 0.90, 2.00, 2.00, 2.40, &
       & 2.00, 2.40, 0.90, 2.00, 1.40, 0.70, 2.00, 2.40, 1.70, 2.00 /
        DATA (gc(82,i),i=1,16) / 1.80, 1.60, 0.60, 2.00, 1.70, 1.50, &
       & 2.00, 1.50, 0.60, 2.00, 1.10,-0.60, 2.00, 1.50, 0.40, 0.70 /
        DATA (gc(83,i),i=1,16) / 0.70, 0.50,-0.50, 2.00, 0.60, 1.40, &
       & 2.00, 1.40,-0.50, 2.00, 0.00, 0.10, 2.00, 1.40, 1.10, 1.50 /
        DATA (gc(84,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(85,i),i=1,16) / 1.90, 1.60, 0.60, 2.00, 1.70, 1.60, &
       & 2.00, 1.60, 0.60, 2.00, 1.20,-0.50, 2.00, 1.60, 0.40, 0.80 /
        DATA (gc(86,i),i=1,16) / 2.50, 1.60, 1.60, 2.00, 1.70, 1.60, &
       & 2.00, 1.60, 1.60, 2.00, 1.80, 0.50, 2.00, 1.60, 1.40, 0.80 /
        DATA (gc(87,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(88,i),i=1,16) / 2.50, 1.70, 1.70, 2.00, 1.80, 1.60, &
       & 2.00, 1.60, 1.70, 2.00, 1.80, 0.50, 2.00, 1.60, 1.50, 0.80 /
        DATA (gc(89,i),i=1,16) / 0.10,-0.10,-1.10, 2.00, 0.00, 0.80, &
       & 2.00, 0.80,-1.10, 2.00,-0.60,-0.50, 2.00, 0.80, 0.50, 0.80 /
        DATA (gc(90,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(91,i),i=1,16) / 1.80, 1.50, 0.50, 2.00, 1.60, 2.10, &
       & 2.00, 2.10, 0.50, 2.00, 1.10, 0.40, 2.00, 2.10, 1.30, 1.70 /
        DATA (gc(92,i),i=1,16) / 0.40,-0.90,-0.10, 2.00,-0.80, 0.10, &
       & 2.00, 0.10,-0.10, 2.00,-0.30,-3.10, 2.00, 0.10,-2.10, 0.10 /
        DATA (gc(93,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gc(94,i),i=1,16) / 1.50, 0.60, 0.70, 2.00, 0.70, 0.60, &
       & 2.00, 0.60, 0.70, 2.00, 0.80,-0.50, 2.00, 0.60, 0.50,-0.20 /
        DATA (gc(95,i),i=1,16) / 0.00,-1.30,-0.50, 2.00,-1.20,-0.30, &
       & 2.00,-0.30,-0.50, 2.00,-0.70,-3.50, 2.00,-0.30,-2.50,-0.30 /
        DATA (gc(96,i),i=1,16) / 2.10, 0.90, 1.70, 2.00, 1.00, 0.80, &
       & 2.00, 0.80, 1.70, 2.00, 1.40, 0.50, 2.00, 0.80, 1.50, 0.00 /

        DATA (ua(1,i),i=1,16) / 2.80, 2.30, 1.70, 2.00, 2.80, 3.40, &
      & 2.00, 3.40, 1.70, 2.00, 2.10, 1.00, 2.00, 3.10, 2.20, 2.90 /
        DATA (ua(2,i),i=1,16) / 2.80, 2.30, 1.70, 2.00, 2.80, 2.80, &
      & 2.00, 2.80, 1.70, 2.00, 2.10, 0.00, 2.00, 2.50, 1.20, 1.90 /
        DATA (ua(3,i),i=1,16) / 1.70, 1.30, 0.70, 2.00, 1.70, 2.70, &
      & 2.00, 2.70, 0.70, 2.00, 1.10, 0.70, 2.00, 2.40, 2.00, 2.70 /
        DATA (ua(4,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
      & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(5,i),i=1,16) / 2.30, 1.90, 1.30, 2.00, 2.30, 2.30, &
      & 2.00, 2.30, 1.30, 2.00, 1.70,-0.50, 2.00, 2.00, 0.80, 1.50 /
        DATA (ua(6,i),i=1,16) / 3.40, 2.30, 2.70, 2.00, 2.80, 2.80, &
      & 2.00, 2.80, 2.70, 2.00, 2.70, 1.00, 2.00, 2.50, 2.20, 1.90 /
        DATA (ua(7,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
      & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(8,i),i=1,16) / 3.10, 2.00, 2.40, 2.00, 2.50, 2.50, &
      & 2.00, 2.50, 2.40, 2.00, 2.40, 0.70, 2.00, 2.20, 1.90, 1.60 /
        DATA (ua(9,i),i=1,16) / 1.70, 1.30, 0.70, 2.00, 1.70, 2.70, &
      & 2.00, 2.70, 0.70, 2.00, 1.10, 0.70, 2.00, 2.40, 2.00, 2.70 /
        DATA (ua(10,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(11,i),i=1,16) / 2.10, 1.70, 1.10, 2.00, 2.10, 2.70, &
       & 2.00, 2.70, 1.10, 2.00, 1.50, 0.30, 2.00, 2.40, 1.60, 2.30 /
        DATA (ua(12,i),i=1,16) / 2.20, 0.80, 2.00, 2.00, 1.20, 2.20, &
       & 2.00, 2.20, 2.00, 2.00, 1.60,-1.60, 2.00, 1.90,-0.30, 2.20 /
        DATA (ua(13,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(14,i),i=1,16) / 3.40, 2.30, 2.70, 2.00, 2.80, 2.80, &
       & 2.00, 2.80, 2.70, 2.00, 2.70, 1.00, 2.00, 2.50, 2.20, 1.90 /
        DATA (ua(15,i),i=1,16) / 1.00,-0.50, 0.70, 2.00, 0.00, 1.00, &
       & 2.00, 1.00, 0.70, 2.00, 0.30,-2.90, 2.00, 0.70,-1.60, 0.90 /
        DATA (ua(16,i),i=1,16) / 2.90, 1.50, 2.70, 2.00, 1.90, 1.90, &
       & 2.00, 1.90, 2.70, 2.00, 2.30, 0.90, 2.00, 1.60, 2.20, 1.10 /
        DATA (ua(17,i),i=1,16) / 2.10, 1.90, 0.10, 2.00, 1.80, 2.50, &
       & 2.00, 1.50, 0.70, 2.00, 1.80, 0.00, 2.00, 2.50, 0.40, 2.10 /
        DATA (ua(18,i),i=1,16) / 2.10, 1.90, 0.10, 2.00, 1.80, 1.90, &
       & 2.00, 0.90, 0.70, 2.00, 1.80,-1.00, 2.00, 1.90,-0.60, 1.10 /
        DATA (ua(19,i),i=1,16) / 1.10, 0.80,-0.90, 2.00, 0.80, 1.80, &
       & 2.00, 0.90,-0.30, 2.00, 0.70,-0.30, 2.00, 1.90, 0.10, 1.90 /
        DATA (ua(20,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(21,i),i=1,16) / 1.70, 1.40,-0.30, 2.00, 1.40, 1.40, &
       & 2.00, 0.40, 0.30, 2.00, 1.30,-1.50, 2.00, 1.50,-1.10, 0.70 /
        DATA (ua(22,i),i=1,16) / 2.70, 1.90, 1.10, 2.00, 1.80, 1.90, &
       & 2.00, 0.90, 1.70, 2.00, 2.40, 0.00, 2.00, 1.90, 0.40, 1.10 /
        DATA (ua(23,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(24,i),i=1,16) / 2.40, 1.60, 0.80, 2.00, 1.50, 1.60, &
       & 2.00, 0.60, 1.40, 2.00, 2.10,-0.30, 2.00, 1.60, 0.10, 0.80 /
        DATA (ua(25,i),i=1,16) / 1.10, 0.80,-0.90, 2.00, 0.80, 1.80, &
       & 2.00, 0.90,-0.30, 2.00, 0.70,-0.30, 2.00, 1.90, 0.10, 1.90 /
        DATA (ua(26,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(27,i),i=1,16) / 1.50, 1.20,-0.50, 2.00, 1.20, 1.80, &
       & 2.00, 0.80, 0.10, 2.00, 1.10,-0.70, 2.00, 1.90,-0.30, 1.50 /
        DATA (ua(28,i),i=1,16) / 1.60, 0.30, 0.40, 2.00, 0.30, 1.30, &
       & 2.00, 0.40, 1.00, 2.00, 1.20,-2.60, 2.00, 1.40,-2.20, 1.40 /
        DATA (ua(29,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(30,i),i=1,16) / 2.70, 1.90, 1.10, 2.00, 1.80, 1.90, &
       & 2.00, 0.90, 1.70, 2.00, 2.40, 0.00, 2.00, 1.90, 0.40, 1.10 /
        DATA (ua(31,i),i=1,16) / 0.30,-0.90,-0.90, 2.00,-1.00, 0.10, &
       & 2.00,-0.90,-0.30, 2.00, 0.00,-3.90, 2.00, 0.10,-3.50, 0.10 /
        DATA (ua(32,i),i=1,16) / 2.30, 1.00, 1.10, 2.00, 1.00, 1.00, &
       & 2.00, 0.00, 1.70, 2.00, 1.90,-0.10, 2.00, 1.10, 0.30, 0.30 /
        DATA (ua(33,i),i=1,16) / 2.00, 1.90, 1.00, 2.00, 2.40, 2.80, &
       & 2.00, 2.70, 1.00, 2.00, 1.80, 0.30, 2.00, 2.70, 1.80, 2.20 /
        DATA (ua(34,i),i=1,16) / 2.00, 1.90, 1.00, 2.00, 2.40, 2.20, &
       & 2.00, 2.10, 1.00, 2.00, 1.80,-0.70, 2.00, 2.10, 0.80, 1.20 /
        DATA (ua(35,i),i=1,16) / 1.00, 0.90, 0.00, 2.00, 1.30, 2.20, &
       & 2.00, 2.00, 0.00, 2.00, 0.70, 0.10, 2.00, 2.00, 1.60, 1.90 /
        DATA (ua(36,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(37,i),i=1,16) / 1.60, 1.50, 0.60, 2.00, 1.90, 1.80, &
       & 2.00, 1.60, 0.60, 2.00, 1.30,-1.10, 2.00, 1.60, 0.40, 0.70 /
        DATA (ua(38,i),i=1,16) / 2.60, 1.90, 2.00, 2.00, 2.40, 2.20, &
       & 2.00, 2.10, 2.00, 2.00, 2.40, 0.30, 2.00, 2.10, 1.80, 1.20 /
        DATA (ua(39,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(40,i),i=1,16) / 2.30, 1.60, 1.70, 2.00, 2.10, 1.90, &
       & 2.00, 1.80, 1.70, 2.00, 2.10, 0.00, 2.00, 1.80, 1.50, 0.90 /
        DATA (ua(41,i),i=1,16) / 1.00, 0.90, 0.00, 2.00, 1.30, 2.20, &
       & 2.00, 2.00, 0.00, 2.00, 0.70, 0.10, 2.00, 2.00, 1.60, 1.90 /
        DATA (ua(42,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(43,i),i=1,16) / 1.40, 1.30, 0.40, 2.00, 1.70, 2.20, &
       & 2.00, 2.00, 0.40, 2.00, 1.10,-0.30, 2.00, 2.00, 1.20, 1.50 /
        DATA (ua(44,i),i=1,16) / 1.50, 0.40, 1.30, 2.00, 0.80, 1.70, &
       & 2.00, 1.50, 1.30, 2.00, 1.20,-2.20, 2.00, 1.50,-0.70, 1.50 /
        DATA (ua(45,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(46,i),i=1,16) / 2.60, 1.90, 2.00, 2.00, 2.40, 2.20, &
       & 2.00, 2.10, 2.00, 2.00, 2.40, 0.30, 2.00, 2.10, 1.80, 1.20 /
        DATA (ua(47,i),i=1,16) / 0.20,-0.90, 0.00, 2.00,-0.40, 0.40, &
       & 2.00, 0.30, 0.00, 2.00, 0.00,-3.50, 2.00, 0.30,-2.00, 0.20 /
        DATA (ua(48,i),i=1,16) / 2.20, 1.10, 2.00, 2.00, 1.50, 1.40, &
       & 2.00, 1.20, 2.00, 2.00, 1.90, 0.30, 2.00, 1.20, 1.80, 0.30 /
        DATA (ua(49,i),i=1,16) / 2.80, 2.50, 1.50, 2.00, 2.60, 3.10, &
       & 2.00, 3.10, 1.50, 2.00, 2.10, 1.30, 2.00, 3.10, 2.30, 2.70 /
        DATA (ua(50,i),i=1,16) / 2.80, 2.50, 1.50, 2.00, 2.60, 2.50, &
       & 2.00, 2.50, 1.50, 2.00, 2.10, 0.30, 2.00, 2.50, 1.30, 1.70 /
        DATA (ua(51,i),i=1,16) / 1.70, 1.50, 0.50, 2.00, 1.60, 2.40, &
       & 2.00, 2.40, 0.50, 2.00, 1.00, 1.10, 2.00, 2.40, 2.10, 2.40 /
        DATA (ua(52,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(53,i),i=1,16) / 2.30, 2.10, 1.10, 2.00, 2.20, 2.00, &
       & 2.00, 2.00, 1.10, 2.00, 1.60,-0.10, 2.00, 2.00, 0.90, 1.20 /
        DATA (ua(54,i),i=1,16) / 3.40, 2.50, 2.50, 2.00, 2.60, 2.50, &
       & 2.00, 2.50, 2.50, 2.00, 2.70, 1.30, 2.00, 2.50, 2.30, 1.70 /
        DATA (ua(55,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(56,i),i=1,16) / 3.10, 2.20, 2.20, 2.00, 2.30, 2.20, &
       & 2.00, 2.20, 2.20, 2.00, 2.40, 1.00, 2.00, 2.20, 2.00, 1.40 /
        DATA (ua(57,i),i=1,16) / 1.70, 1.50, 0.50, 2.00, 1.60, 2.40, &
       & 2.00, 2.40, 0.50, 2.00, 1.00, 1.10, 2.00, 2.40, 2.10, 2.40 /
        DATA (ua(58,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(59,i),i=1,16) / 2.10, 1.90, 0.90, 2.00, 2.00, 2.40, &
       & 2.00, 2.40, 0.90, 2.00, 1.40, 0.70, 2.00, 2.40, 1.70, 2.00 /
        DATA (ua(60,i),i=1,16) / 2.20, 1.00, 1.80, 2.00, 1.10, 1.90, &
       & 2.00, 1.90, 1.80, 2.00, 1.50,-1.20, 2.00, 1.90,-0.20, 1.90 /
        DATA (ua(61,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(62,i),i=1,16) / 3.40, 2.50, 2.50, 2.00, 2.60, 2.50, &
       & 2.00, 2.50, 2.50, 2.00, 2.70, 1.30, 2.00, 2.50, 2.30, 1.70 /
        DATA (ua(63,i),i=1,16) / 1.00,-0.30, 0.50, 2.00,-0.20, 0.70, &
       & 2.00, 0.70, 0.50, 2.00, 0.30,-2.50, 2.00, 0.70,-1.50, 0.70 /
        DATA (ua(64,i),i=1,16) / 2.90, 1.70, 2.50, 2.00, 1.80, 1.60, &
       & 2.00, 1.60, 2.50, 2.00, 2.20, 1.30, 2.00, 1.60, 2.30, 0.80 /
        DATA (ua(65,i),i=1,16) / 2.80, 2.30, 1.70, 2.00, 2.80, 3.40, &
       & 2.00, 3.40, 1.70, 2.00, 2.10, 1.00, 2.00, 3.10, 2.20, 2.90 /
        DATA (ua(66,i),i=1,16) / 2.80, 2.30, 1.70, 2.00, 2.80, 2.80, &
       & 2.00, 2.80, 1.70, 2.00, 2.10, 0.00, 2.00, 2.50, 1.20, 1.90 /
        DATA (ua(67,i),i=1,16) / 1.70, 1.30, 0.70, 2.00, 1.70, 2.70, &
       & 2.00, 2.70, 0.70, 2.00, 1.10, 0.70, 2.00, 2.40, 2.00, 2.70 /
        DATA (ua(68,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(69,i),i=1,16) / 2.30, 1.90, 1.30, 2.00, 2.30, 2.30, &
       & 2.00, 2.30, 1.30, 2.00, 1.70,-0.50, 2.00, 2.00, 0.80, 1.50 /
        DATA (ua(70,i),i=1,16) / 3.40, 2.30, 2.70, 2.00, 2.80, 2.80, &
       & 2.00, 2.80, 2.70, 2.00, 2.70, 1.00, 2.00, 2.50, 2.20, 1.90 /
        DATA (ua(71,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(72,i),i=1,16) / 3.10, 2.00, 2.40, 2.00, 2.50, 2.50, &
       & 2.00, 2.50, 2.40, 2.00, 2.40, 0.70, 2.00, 2.20, 1.90, 1.60 /
        DATA (ua(73,i),i=1,16) / 1.70, 1.30, 0.70, 2.00, 1.70, 2.70, &
       & 2.00, 2.70, 0.70, 2.00, 1.10, 0.70, 2.00, 2.40, 2.00, 2.70 /
        DATA (ua(74,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(75,i),i=1,16) / 2.10, 1.70, 1.10, 2.00, 2.10, 2.70, &
       & 2.00, 2.70, 1.10, 2.00, 1.50, 0.30, 2.00, 2.40, 1.60, 2.30 /
        DATA (ua(76,i),i=1,16) / 2.20, 0.80, 2.00, 2.00, 1.20, 2.20, &
       & 2.00, 2.20, 2.00, 2.00, 1.60,-1.60, 2.00, 1.90,-0.30, 2.20 /
        DATA (ua(77,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(78,i),i=1,16) / 3.40, 2.30, 2.70, 2.00, 2.80, 2.80, &
       & 2.00, 2.80, 2.70, 2.00, 2.70, 1.00, 2.00, 2.50, 2.20, 1.90 /
        DATA (ua(79,i),i=1,16) / 1.00,-0.50, 0.70, 2.00, 0.00, 1.00, &
       & 2.00, 1.00, 0.70, 2.00, 0.30,-2.90, 2.00, 0.70,-1.60, 0.90 /
        DATA (ua(80,i),i=1,16) / 2.90, 1.50, 2.70, 2.00, 1.90, 1.90, &
       & 2.00, 1.90, 2.70, 2.00, 2.30, 0.90, 2.00, 1.60, 2.20, 1.10 /
        DATA (ua(81,i),i=1,16) / 2.80, 2.50, 1.50, 2.00, 2.60, 3.10, &
       & 2.00, 3.10, 1.50, 2.00, 2.10, 1.30, 2.00, 3.10, 2.30, 2.70 /
        DATA (ua(82,i),i=1,16) / 2.80, 2.50, 1.50, 2.00, 2.60, 2.50, &
       & 2.00, 2.50, 1.50, 2.00, 2.10, 0.30, 2.00, 2.50, 1.30, 1.70 /
        DATA (ua(83,i),i=1,16) / 1.70, 1.50, 0.50, 2.00, 1.60, 2.40, &
       & 2.00, 2.40, 0.50, 2.00, 1.00, 1.10, 2.00, 2.40, 2.10, 2.40 /
        DATA (ua(84,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(85,i),i=1,16) / 2.30, 2.10, 1.10, 2.00, 2.20, 2.00, &
       & 2.00, 2.00, 1.10, 2.00, 1.60,-0.10, 2.00, 2.00, 0.90, 1.20 /
        DATA (ua(86,i),i=1,16) / 3.40, 2.50, 2.50, 2.00, 2.60, 2.50, &
       & 2.00, 2.50, 2.50, 2.00, 2.70, 1.30, 2.00, 2.50, 2.30, 1.70 /
        DATA (ua(87,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(88,i),i=1,16) / 3.10, 2.20, 2.20, 2.00, 2.30, 2.20, &
       & 2.00, 2.20, 2.20, 2.00, 2.40, 1.00, 2.00, 2.20, 2.00, 1.40 /
        DATA (ua(89,i),i=1,16) / 1.70, 1.50, 0.50, 2.00, 1.60, 2.40, &
       & 2.00, 2.40, 0.50, 2.00, 1.00, 1.10, 2.00, 2.40, 2.10, 2.40 /
        DATA (ua(90,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(91,i),i=1,16) / 2.10, 1.90, 0.90, 2.00, 2.00, 2.40, &
       & 2.00, 2.40, 0.90, 2.00, 1.40, 0.70, 2.00, 2.40, 1.70, 2.00 /
        DATA (ua(92,i),i=1,16) / 2.20, 1.00, 1.80, 2.00, 1.10, 1.90, &
       & 2.00, 1.90, 1.80, 2.00, 1.50,-1.20, 2.00, 1.90,-0.20, 1.90 /
        DATA (ua(93,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ua(94,i),i=1,16) / 3.40, 2.50, 2.50, 2.00, 2.60, 2.50, &
       & 2.00, 2.50, 2.50, 2.00, 2.70, 1.30, 2.00, 2.50, 2.30, 1.70 /
        DATA (ua(95,i),i=1,16) / 1.00,-0.30, 0.50, 2.00,-0.20, 0.70, &
       & 2.00, 0.70, 0.50, 2.00, 0.30,-2.50, 2.00, 0.70,-1.50, 0.70 /
        DATA (ua(96,i),i=1,16) / 2.90, 1.70, 2.50, 2.00, 1.80, 1.60, &
       & 2.00, 1.60, 2.50, 2.00, 2.20, 1.30, 2.00, 1.60, 2.30, 0.80 /

        DATA (gu(1,i),i=1,16) / 2.80, 2.30, 1.70, 2.00, 2.80, 3.40, &
      & 2.00, 3.40, 1.70, 2.00, 2.10, 1.00, 2.00, 3.10, 2.20, 2.90 /
        DATA (gu(2,i),i=1,16) / 2.60, 2.20, 1.60, 2.00, 2.60, 2.60, &
      & 2.00, 2.60, 1.60, 2.00, 2.00,-0.20, 2.00, 2.30, 1.10, 1.80 /
        DATA (gu(3,i),i=1,16) / 1.50, 1.10, 0.50, 2.00, 1.50, 2.50, &
      & 2.00, 2.50, 0.50, 2.00, 0.90, 0.50, 2.00, 2.20, 1.80, 2.50 /
        DATA (gu(4,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
      & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(5,i),i=1,16) / 2.50, 2.10, 1.50, 2.00, 2.50, 2.50, &
      & 2.00, 2.50, 1.50, 2.00, 1.90,-0.30, 2.00, 2.20, 1.00, 1.70 /
        DATA (gu(6,i),i=1,16) / 3.10, 2.00, 2.40, 2.00, 2.50, 2.50, &
      & 2.00, 2.50, 2.40, 2.00, 2.40, 0.70, 2.00, 2.20, 1.90, 1.60 /
        DATA (gu(7,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
      & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(8,i),i=1,16) / 3.10, 2.00, 2.40, 2.00, 2.50, 2.50, &
      & 2.00, 2.50, 2.40, 2.00, 2.40, 0.70, 2.00, 2.20, 1.90, 1.60 /
        DATA (gu(9,i),i=1,16) / 1.50, 1.10, 0.50, 2.00, 1.50, 2.50, &
      & 2.00, 2.50, 0.50, 2.00, 0.90, 0.50, 2.00, 2.20, 1.80, 2.50 /
        DATA (gu(10,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(11,i),i=1,16) / 2.10, 1.60, 1.00, 2.00, 2.10, 2.70, &
       & 2.00, 2.70, 1.00, 2.00, 1.40, 0.30, 2.00, 2.40, 1.50, 2.20 /
        DATA (gu(12,i),i=1,16) / 2.30, 0.90, 2.10, 2.00, 1.30, 2.30, &
       & 2.00, 2.30, 2.10, 2.00, 1.70,-1.50, 2.00, 2.00,-0.20, 2.30 /
        DATA (gu(13,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(14,i),i=1,16) / 3.10, 2.00, 2.40, 2.00, 2.50, 2.50, &
       & 2.00, 2.50, 2.40, 2.00, 2.40, 0.70, 2.00, 2.20, 1.90, 1.60 /
        DATA (gu(15,i),i=1,16) / 1.30,-0.10, 1.10, 2.00, 0.30, 1.30, &
       & 2.00, 1.30, 1.10, 2.00, 0.70,-2.50, 2.00, 1.00,-1.20, 1.30 /
        DATA (gu(16,i),i=1,16) / 2.70, 1.20, 2.40, 2.00, 1.70, 1.70, &
       & 2.00, 1.70, 2.40, 2.00, 2.00, 0.70, 2.00, 1.40, 1.90, 0.80 /
        DATA (gu(17,i),i=1,16) / 2.10, 1.90, 0.10, 2.00, 1.80, 2.50, &
       & 2.00, 1.50, 0.70, 2.00, 1.80, 0.00, 2.00, 2.50, 0.40, 2.10 /
        DATA (gu(18,i),i=1,16) / 2.00, 1.70, 0.00, 2.00, 1.70, 1.70, &
       & 2.00, 0.70, 0.60, 2.00, 1.60,-1.20, 2.00, 1.80,-0.80, 1.00 /
        DATA (gu(19,i),i=1,16) / 0.90, 0.60,-1.10, 2.00, 0.60, 1.60, &
       & 2.00, 0.70,-0.50, 2.00, 0.50,-0.50, 2.00, 1.70,-0.10, 1.70 /
        DATA (gu(20,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(21,i),i=1,16) / 1.90, 1.60,-0.10, 2.00, 1.60, 1.60, &
       & 2.00, 0.60, 0.50, 2.00, 1.50,-1.30, 2.00, 1.70,-0.90, 0.90 /
        DATA (gu(22,i),i=1,16) / 2.40, 1.60, 0.80, 2.00, 1.50, 1.60, &
       & 2.00, 0.60, 1.40, 2.00, 2.10,-0.30, 2.00, 1.60, 0.10, 0.80 /
        DATA (gu(23,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(24,i),i=1,16) / 2.40, 1.60, 0.80, 2.00, 1.50, 1.60, &
       & 2.00, 0.60, 1.40, 2.00, 2.10,-0.30, 2.00, 1.60, 0.10, 0.80 /
        DATA (gu(25,i),i=1,16) / 0.90, 0.60,-1.10, 2.00, 0.60, 1.60, &
       & 2.00, 0.70,-0.50, 2.00, 0.50,-0.50, 2.00, 1.70,-0.10, 1.70 /
        DATA (gu(26,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(27,i),i=1,16) / 1.40, 1.20,-0.60, 2.00, 1.10, 1.80, &
       & 2.00, 0.80, 0.00, 2.00, 1.10,-0.70, 2.00, 1.80,-0.30, 1.40 /
        DATA (gu(28,i),i=1,16) / 1.70, 0.40, 0.50, 2.00, 0.40, 1.40, &
       & 2.00, 0.50, 1.10, 2.00, 1.30,-2.50, 2.00, 1.50,-2.10, 1.50 /
        DATA (gu(29,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(30,i),i=1,16) / 2.40, 1.60, 0.80, 2.00, 1.50, 1.60, &
       & 2.00, 0.60, 1.40, 2.00, 2.10,-0.30, 2.00, 1.60, 0.10, 0.80 /
        DATA (gu(31,i),i=1,16) / 0.70,-0.50,-0.50, 2.00,-0.60, 0.50, &
       & 2.00,-0.50, 0.10, 2.00, 0.40,-3.50, 2.00, 0.50,-3.10, 0.50 /
        DATA (gu(32,i),i=1,16) / 2.00, 0.80, 0.80, 2.00, 0.70, 0.80, &
       & 2.00,-0.20, 1.50, 2.00, 1.70,-0.30, 2.00, 0.80, 0.10, 0.00 /
        DATA (gu(33,i),i=1,16) / 2.00, 1.90, 1.00, 2.00, 2.40, 2.80, &
       & 2.00, 2.70, 1.00, 2.00, 1.80, 0.30, 2.00, 2.70, 1.80, 2.20 /
        DATA (gu(34,i),i=1,16) / 1.90, 1.80, 0.90, 2.00, 2.20, 2.10, &
       & 2.00, 1.90, 0.90, 2.00, 1.60,-0.80, 2.00, 1.90, 0.70, 1.00 /
        DATA (gu(35,i),i=1,16) / 0.80, 0.70,-0.20, 2.00, 1.10, 2.00, &
       & 2.00, 1.80,-0.20, 2.00, 0.50,-0.10, 2.00, 1.80, 1.40, 1.80 /
        DATA (gu(36,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(37,i),i=1,16) / 1.80, 1.70, 0.80, 2.00, 2.10, 2.00, &
       & 2.00, 1.80, 0.80, 2.00, 1.50,-0.90, 2.00, 1.80, 0.60, 0.90 /
        DATA (gu(38,i),i=1,16) / 2.30, 1.60, 1.70, 2.00, 2.10, 1.90, &
       & 2.00, 1.80, 1.70, 2.00, 2.10, 0.00, 2.00, 1.80, 1.50, 0.90 /
        DATA (gu(39,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(40,i),i=1,16) / 2.30, 1.60, 1.70, 2.00, 2.10, 1.90, &
       & 2.00, 1.80, 1.70, 2.00, 2.10, 0.00, 2.00, 1.80, 1.50, 0.90 /
        DATA (gu(41,i),i=1,16) / 0.80, 0.70,-0.20, 2.00, 1.10, 2.00, &
       & 2.00, 1.80,-0.20, 2.00, 0.50,-0.10, 2.00, 1.80, 1.40, 1.80 /
        DATA (gu(42,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(43,i),i=1,16) / 1.30, 1.20, 0.30, 2.00, 1.70, 2.10, &
       & 2.00, 2.00, 0.30, 2.00, 1.10,-0.40, 2.00, 2.00, 1.10, 1.50 /
        DATA (gu(44,i),i=1,16) / 1.60, 0.50, 1.40, 2.00, 0.90, 1.80, &
       & 2.00, 1.60, 1.40, 2.00, 1.30,-2.10, 2.00, 1.60,-0.60, 1.60 /
        DATA (gu(45,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(46,i),i=1,16) / 2.30, 1.60, 1.70, 2.00, 2.10, 1.90, &
       & 2.00, 1.80, 1.70, 2.00, 2.10, 0.00, 2.00, 1.80, 1.50, 0.90 /
        DATA (gu(47,i),i=1,16) / 0.60,-0.50, 0.40, 2.00, 0.00, 0.80, &
       & 2.00, 0.70, 0.40, 2.00, 0.40,-3.10, 2.00, 0.70,-1.60, 0.60 /
        DATA (gu(48,i),i=1,16) / 1.90, 0.80, 1.80, 2.00, 1.30, 1.10, &
       & 2.00, 1.00, 1.80, 2.00, 1.70, 0.00, 2.00, 1.00, 1.60, 0.10 /
        DATA (gu(49,i),i=1,16) / 2.80, 2.50, 1.50, 2.00, 2.60, 3.10, &
       & 2.00, 3.10, 1.50, 2.00, 2.10, 1.30, 2.00, 3.10, 2.30, 2.70 /
        DATA (gu(50,i),i=1,16) / 2.60, 2.40, 1.40, 2.00, 2.50, 2.30, &
       & 2.00, 2.30, 1.40, 2.00, 1.90, 0.20, 2.00, 2.30, 1.20, 1.50 /
        DATA (gu(51,i),i=1,16) / 1.50, 1.30, 0.30, 2.00, 1.40, 2.20, &
       & 2.00, 2.20, 0.30, 2.00, 0.80, 0.90, 2.00, 2.20, 1.90, 2.20 /
        DATA (gu(52,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(53,i),i=1,16) / 2.50, 2.30, 1.30, 2.00, 2.40, 2.20, &
       & 2.00, 2.20, 1.30, 2.00, 1.80, 0.10, 2.00, 2.20, 1.10, 1.40 /
        DATA (gu(54,i),i=1,16) / 3.10, 2.20, 2.20, 2.00, 2.30, 2.20, &
       & 2.00, 2.20, 2.20, 2.00, 2.40, 1.00, 2.00, 2.20, 2.00, 1.40 /
        DATA (gu(55,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(56,i),i=1,16) / 3.10, 2.20, 2.20, 2.00, 2.30, 2.20, &
       & 2.00, 2.20, 2.20, 2.00, 2.40, 1.00, 2.00, 2.20, 2.00, 1.40 /
        DATA (gu(57,i),i=1,16) / 1.50, 1.30, 0.30, 2.00, 1.40, 2.20, &
       & 2.00, 2.20, 0.30, 2.00, 0.80, 0.90, 2.00, 2.20, 1.90, 2.20 /
        DATA (gu(58,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(59,i),i=1,16) / 2.10, 1.80, 0.80, 2.00, 1.90, 2.40, &
       & 2.00, 2.40, 0.80, 2.00, 1.40, 0.70, 2.00, 2.40, 1.60, 2.00 /
        DATA (gu(60,i),i=1,16) / 2.30, 1.10, 1.90, 2.00, 1.20, 2.00, &
       & 2.00, 2.00, 1.90, 2.00, 1.60,-1.10, 2.00, 2.00,-0.10, 2.00 /
        DATA (gu(61,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(62,i),i=1,16) / 3.10, 2.20, 2.20, 2.00, 2.30, 2.20, &
       & 2.00, 2.20, 2.20, 2.00, 2.40, 1.00, 2.00, 2.20, 2.00, 1.40 /
        DATA (gu(63,i),i=1,16) / 1.30, 0.10, 0.90, 2.00, 0.20, 1.00, &
       & 2.00, 1.00, 0.90, 2.00, 0.70,-2.10, 2.00, 1.00,-1.10, 1.10 /
        DATA (gu(64,i),i=1,16) / 2.70, 1.40, 2.20, 2.00, 1.50, 1.40, &
       & 2.00, 1.40, 2.20, 2.00, 2.00, 1.10, 2.00, 1.40, 2.00, 0.60 /
        DATA (gu(65,i),i=1,16) / 2.80, 2.30, 1.70, 2.00, 2.80, 3.40, &
       & 2.00, 3.40, 1.70, 2.00, 2.10, 1.00, 2.00, 3.10, 2.20, 2.90 /
        DATA (gu(66,i),i=1,16) / 2.60, 2.20, 1.60, 2.00, 2.60, 2.60, &
       & 2.00, 2.60, 1.60, 2.00, 2.00,-0.20, 2.00, 2.30, 1.10, 1.80 /
        DATA (gu(67,i),i=1,16) / 1.50, 1.10, 0.50, 2.00, 1.50, 2.50, &
       & 2.00, 2.50, 0.50, 2.00, 0.90, 0.50, 2.00, 2.20, 1.80, 2.50 /
        DATA (gu(68,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(69,i),i=1,16) / 2.50, 2.10, 1.50, 2.00, 2.50, 2.50, &
       & 2.00, 2.50, 1.50, 2.00, 1.90,-0.30, 2.00, 2.20, 1.00, 1.70 /
        DATA (gu(70,i),i=1,16) / 3.10, 2.00, 2.40, 2.00, 2.50, 2.50, &
       & 2.00, 2.50, 2.40, 2.00, 2.40, 0.70, 2.00, 2.20, 1.90, 1.60 /
        DATA (gu(71,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(72,i),i=1,16) / 3.10, 2.00, 2.40, 2.00, 2.50, 2.50, &
       & 2.00, 2.50, 2.40, 2.00, 2.40, 0.70, 2.00, 2.20, 1.90, 1.60 /
        DATA (gu(73,i),i=1,16) / 1.50, 1.10, 0.50, 2.00, 1.50, 2.50, &
       & 2.00, 2.50, 0.50, 2.00, 0.90, 0.50, 2.00, 2.20, 1.80, 2.50 /
        DATA (gu(74,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(75,i),i=1,16) / 2.10, 1.60, 1.00, 2.00, 2.10, 2.70, &
       & 2.00, 2.70, 1.00, 2.00, 1.40, 0.30, 2.00, 2.40, 1.50, 2.20 /
        DATA (gu(76,i),i=1,16) / 2.30, 0.90, 2.10, 2.00, 1.30, 2.30, &
       & 2.00, 2.30, 2.10, 2.00, 1.70,-1.50, 2.00, 2.00,-0.20, 2.30 /
        DATA (gu(77,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(78,i),i=1,16) / 3.10, 2.00, 2.40, 2.00, 2.50, 2.50, &
       & 2.00, 2.50, 2.40, 2.00, 2.40, 0.70, 2.00, 2.20, 1.90, 1.60 /
        DATA (gu(79,i),i=1,16) / 1.30,-0.10, 1.10, 2.00, 0.30, 1.30, &
       & 2.00, 1.30, 1.10, 2.00, 0.70,-2.50, 2.00, 1.00,-1.20, 1.30 /
        DATA (gu(80,i),i=1,16) / 2.70, 1.20, 2.40, 2.00, 1.70, 1.70, &
       & 2.00, 1.70, 2.40, 2.00, 2.00, 0.70, 2.00, 1.40, 1.90, 0.80 /
        DATA (gu(81,i),i=1,16) / 2.80, 2.50, 1.50, 2.00, 2.60, 3.10, &
       & 2.00, 3.10, 1.50, 2.00, 2.10, 1.30, 2.00, 3.10, 2.30, 2.70 /
        DATA (gu(82,i),i=1,16) / 2.60, 2.40, 1.40, 2.00, 2.50, 2.30, &
       & 2.00, 2.30, 1.40, 2.00, 1.90, 0.20, 2.00, 2.30, 1.20, 1.50 /
        DATA (gu(83,i),i=1,16) / 1.50, 1.30, 0.30, 2.00, 1.40, 2.20, &
       & 2.00, 2.20, 0.30, 2.00, 0.80, 0.90, 2.00, 2.20, 1.90, 2.20 /
        DATA (gu(84,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(85,i),i=1,16) / 2.50, 2.30, 1.30, 2.00, 2.40, 2.20, &
       & 2.00, 2.20, 1.30, 2.00, 1.80, 0.10, 2.00, 2.20, 1.10, 1.40 /
        DATA (gu(86,i),i=1,16) / 3.10, 2.20, 2.20, 2.00, 2.30, 2.20, &
       & 2.00, 2.20, 2.20, 2.00, 2.40, 1.00, 2.00, 2.20, 2.00, 1.40 /
        DATA (gu(87,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(88,i),i=1,16) / 3.10, 2.20, 2.20, 2.00, 2.30, 2.20, &
       & 2.00, 2.20, 2.20, 2.00, 2.40, 1.00, 2.00, 2.20, 2.00, 1.40 /
        DATA (gu(89,i),i=1,16) / 1.50, 1.30, 0.30, 2.00, 1.40, 2.20, &
       & 2.00, 2.20, 0.30, 2.00, 0.80, 0.90, 2.00, 2.20, 1.90, 2.20 /
        DATA (gu(90,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(91,i),i=1,16) / 2.10, 1.80, 0.80, 2.00, 1.90, 2.40, &
       & 2.00, 2.40, 0.80, 2.00, 1.40, 0.70, 2.00, 2.40, 1.60, 2.00 /
        DATA (gu(92,i),i=1,16) / 2.30, 1.10, 1.90, 2.00, 1.20, 2.00, &
       & 2.00, 2.00, 1.90, 2.00, 1.60,-1.10, 2.00, 2.00,-0.10, 2.00 /
        DATA (gu(93,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (gu(94,i),i=1,16) / 3.10, 2.20, 2.20, 2.00, 2.30, 2.20, &
       & 2.00, 2.20, 2.20, 2.00, 2.40, 1.00, 2.00, 2.20, 2.00, 1.40 /
        DATA (gu(95,i),i=1,16) / 1.30, 0.10, 0.90, 2.00, 0.20, 1.00, &
       & 2.00, 1.00, 0.90, 2.00, 0.70,-2.10, 2.00, 1.00,-1.10, 1.10 /
        DATA (gu(96,i),i=1,16) / 2.70, 1.40, 2.20, 2.00, 1.50, 1.40, &
       & 2.00, 1.40, 2.20, 2.00, 2.00, 1.10, 2.00, 1.40, 2.00, 0.60 /

        DATA (ug(1,i),i=1,16) / 2.80, 2.30, 1.70, 2.00, 2.80, 3.40, &
      & 2.00, 3.40, 1.70, 2.00, 2.10, 1.00, 2.00, 3.10, 2.20, 2.90 /
        DATA (ug(2,i),i=1,16) / 2.80, 2.30, 1.70, 2.00, 2.80, 2.80, &
      & 2.00, 2.80, 1.70, 2.00, 2.10, 0.00, 2.00, 2.50, 1.20, 1.90 /
        DATA (ug(3,i),i=1,16) / 1.70, 1.30, 0.70, 2.00, 1.70, 2.70, &
      & 2.00, 2.70, 0.70, 2.00, 1.10, 0.70, 2.00, 2.40, 2.00, 2.70 /
        DATA (ug(4,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
      & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(5,i),i=1,16) / 2.30, 1.90, 1.30, 2.00, 2.30, 2.30, &
      & 2.00, 2.30, 1.30, 2.00, 1.70,-0.50, 2.00, 2.00, 0.80, 1.50 /
        DATA (ug(6,i),i=1,16) / 3.40, 2.30, 2.70, 2.00, 2.80, 2.80, &
      & 2.00, 2.80, 2.70, 2.00, 2.70, 1.00, 2.00, 2.50, 2.20, 1.90 /
        DATA (ug(7,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
      & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(8,i),i=1,16) / 3.10, 2.00, 2.40, 2.00, 2.50, 2.50, &
      & 2.00, 2.50, 2.40, 2.00, 2.40, 0.70, 2.00, 2.20, 1.90, 1.60 /
        DATA (ug(9,i),i=1,16) / 1.70, 1.30, 0.70, 2.00, 1.70, 2.70, &
      & 2.00, 2.70, 0.70, 2.00, 1.10, 0.70, 2.00, 2.40, 2.00, 2.70 /
        DATA (ug(10,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(11,i),i=1,16) / 2.10, 1.70, 1.10, 2.00, 2.10, 2.70, &
       & 2.00, 2.70, 1.10, 2.00, 1.50, 0.30, 2.00, 2.40, 1.60, 2.30 /
        DATA (ug(12,i),i=1,16) / 2.20, 0.80, 2.00, 2.00, 1.20, 2.20, &
       & 2.00, 2.20, 2.00, 2.00, 1.60,-1.60, 2.00, 1.90,-0.30, 2.20 /
        DATA (ug(13,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(14,i),i=1,16) / 3.40, 2.30, 2.70, 2.00, 2.80, 2.80, &
       & 2.00, 2.80, 2.70, 2.00, 2.70, 1.00, 2.00, 2.50, 2.20, 1.90 /
        DATA (ug(15,i),i=1,16) / 1.00,-0.50, 0.70, 2.00, 0.00, 1.00, &
       & 2.00, 1.00, 0.70, 2.00, 0.30,-2.90, 2.00, 0.70,-1.60, 0.90 /
        DATA (ug(16,i),i=1,16) / 2.90, 1.50, 2.70, 2.00, 1.90, 1.90, &
       & 2.00, 1.90, 2.70, 2.00, 2.30, 0.90, 2.00, 1.60, 2.20, 1.10 /
        DATA (ug(17,i),i=1,16) / 2.10, 1.90, 0.10, 2.00, 1.80, 2.50, &
       & 2.00, 1.50, 0.70, 2.00, 1.80, 0.00, 2.00, 2.50, 0.40, 2.10 /
        DATA (ug(18,i),i=1,16) / 2.10, 1.90, 0.10, 2.00, 1.80, 1.90, &
       & 2.00, 0.90, 0.70, 2.00, 1.80,-1.00, 2.00, 1.90,-0.60, 1.10 /
        DATA (ug(19,i),i=1,16) / 1.10, 0.80,-0.90, 2.00, 0.80, 1.80, &
       & 2.00, 0.90,-0.30, 2.00, 0.70,-0.30, 2.00, 1.90, 0.10, 1.90 /
        DATA (ug(20,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(21,i),i=1,16) / 1.70, 1.40,-0.30, 2.00, 1.40, 1.40, &
       & 2.00, 0.40, 0.30, 2.00, 1.30,-1.50, 2.00, 1.50,-1.10, 0.70 /
        DATA (ug(22,i),i=1,16) / 2.70, 1.90, 1.10, 2.00, 1.80, 1.90, &
       & 2.00, 0.90, 1.70, 2.00, 2.40, 0.00, 2.00, 1.90, 0.40, 1.10 /
        DATA (ug(23,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(24,i),i=1,16) / 2.40, 1.60, 0.80, 2.00, 1.50, 1.60, &
       & 2.00, 0.60, 1.40, 2.00, 2.10,-0.30, 2.00, 1.60, 0.10, 0.80 /
        DATA (ug(25,i),i=1,16) / 1.10, 0.80,-0.90, 2.00, 0.80, 1.80, &
       & 2.00, 0.90,-0.30, 2.00, 0.70,-0.30, 2.00, 1.90, 0.10, 1.90 /
        DATA (ug(26,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(27,i),i=1,16) / 1.50, 1.20,-0.50, 2.00, 1.20, 1.80, &
       & 2.00, 0.80, 0.10, 2.00, 1.10,-0.70, 2.00, 1.90,-0.30, 1.50 /
        DATA (ug(28,i),i=1,16) / 1.60, 0.30, 0.40, 2.00, 0.30, 1.30, &
       & 2.00, 0.40, 1.00, 2.00, 1.20,-2.60, 2.00, 1.40,-2.20, 1.40 /
        DATA (ug(29,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(30,i),i=1,16) / 2.70, 1.90, 1.10, 2.00, 1.80, 1.90, &
       & 2.00, 0.90, 1.70, 2.00, 2.40, 0.00, 2.00, 1.90, 0.40, 1.10 /
        DATA (ug(31,i),i=1,16) / 0.30,-0.90,-0.90, 2.00,-1.00, 0.10, &
       & 2.00,-0.90,-0.30, 2.00, 0.00,-3.90, 2.00, 0.10,-3.50, 0.10 /
        DATA (ug(32,i),i=1,16) / 2.30, 1.00, 1.10, 2.00, 1.00, 1.00, &
       & 2.00, 0.00, 1.70, 2.00, 1.90,-0.10, 2.00, 1.10, 0.30, 0.30 /
        DATA (ug(33,i),i=1,16) / 2.00, 1.90, 1.00, 2.00, 2.40, 2.80, &
       & 2.00, 2.70, 1.00, 2.00, 1.80, 0.30, 2.00, 2.70, 1.80, 2.20 /
        DATA (ug(34,i),i=1,16) / 2.00, 1.90, 1.00, 2.00, 2.40, 2.20, &
       & 2.00, 2.10, 1.00, 2.00, 1.80,-0.70, 2.00, 2.10, 0.80, 1.20 /
        DATA (ug(35,i),i=1,16) / 1.00, 0.90, 0.00, 2.00, 1.30, 2.20, &
       & 2.00, 2.00, 0.00, 2.00, 0.70, 0.10, 2.00, 2.00, 1.60, 1.90 /
        DATA (ug(36,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(37,i),i=1,16) / 1.60, 1.50, 0.60, 2.00, 1.90, 1.80, &
       & 2.00, 1.60, 0.60, 2.00, 1.30,-1.10, 2.00, 1.60, 0.40, 0.70 /
        DATA (ug(38,i),i=1,16) / 2.60, 1.90, 2.00, 2.00, 2.40, 2.20, &
       & 2.00, 2.10, 2.00, 2.00, 2.40, 0.30, 2.00, 2.10, 1.80, 1.20 /
        DATA (ug(39,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(40,i),i=1,16) / 2.30, 1.60, 1.70, 2.00, 2.10, 1.90, &
       & 2.00, 1.80, 1.70, 2.00, 2.10, 0.00, 2.00, 1.80, 1.50, 0.90 /
        DATA (ug(41,i),i=1,16) / 1.00, 0.90, 0.00, 2.00, 1.30, 2.20, &
       & 2.00, 2.00, 0.00, 2.00, 0.70, 0.10, 2.00, 2.00, 1.60, 1.90 /
        DATA (ug(42,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(43,i),i=1,16) / 1.40, 1.30, 0.40, 2.00, 1.70, 2.20, &
       & 2.00, 2.00, 0.40, 2.00, 1.10,-0.30, 2.00, 2.00, 1.20, 1.50 /
        DATA (ug(44,i),i=1,16) / 1.50, 0.40, 1.30, 2.00, 0.80, 1.70, &
       & 2.00, 1.50, 1.30, 2.00, 1.20,-2.20, 2.00, 1.50,-0.70, 1.50 /
        DATA (ug(45,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(46,i),i=1,16) / 2.60, 1.90, 2.00, 2.00, 2.40, 2.20, &
       & 2.00, 2.10, 2.00, 2.00, 2.40, 0.30, 2.00, 2.10, 1.80, 1.20 /
        DATA (ug(47,i),i=1,16) / 0.20,-0.90, 0.00, 2.00,-0.40, 0.40, &
       & 2.00, 0.30, 0.00, 2.00, 0.00,-3.50, 2.00, 0.30,-2.00, 0.20 /
        DATA (ug(48,i),i=1,16) / 2.20, 1.10, 2.00, 2.00, 1.50, 1.40, &
       & 2.00, 1.20, 2.00, 2.00, 1.90, 0.30, 2.00, 1.20, 1.80, 0.30 /
        DATA (ug(49,i),i=1,16) / 2.80, 2.50, 1.50, 2.00, 2.60, 3.10, &
       & 2.00, 3.10, 1.50, 2.00, 2.10, 1.30, 2.00, 3.10, 2.30, 2.70 /
        DATA (ug(50,i),i=1,16) / 2.80, 2.50, 1.50, 2.00, 2.60, 2.50, &
       & 2.00, 2.50, 1.50, 2.00, 2.10, 0.30, 2.00, 2.50, 1.30, 1.70 /
        DATA (ug(51,i),i=1,16) / 1.70, 1.50, 0.50, 2.00, 1.60, 2.40, &
       & 2.00, 2.40, 0.50, 2.00, 1.00, 1.10, 2.00, 2.40, 2.10, 2.40 /
        DATA (ug(52,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(53,i),i=1,16) / 2.30, 2.10, 1.10, 2.00, 2.20, 2.00, &
       & 2.00, 2.00, 1.10, 2.00, 1.60,-0.10, 2.00, 2.00, 0.90, 1.20 /
        DATA (ug(54,i),i=1,16) / 3.40, 2.50, 2.50, 2.00, 2.60, 2.50, &
       & 2.00, 2.50, 2.50, 2.00, 2.70, 1.30, 2.00, 2.50, 2.30, 1.70 /
        DATA (ug(55,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(56,i),i=1,16) / 3.10, 2.20, 2.20, 2.00, 2.30, 2.20, &
       & 2.00, 2.20, 2.20, 2.00, 2.40, 1.00, 2.00, 2.20, 2.00, 1.40 /
        DATA (ug(57,i),i=1,16) / 1.70, 1.50, 0.50, 2.00, 1.60, 2.40, &
       & 2.00, 2.40, 0.50, 2.00, 1.00, 1.10, 2.00, 2.40, 2.10, 2.40 /
        DATA (ug(58,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(59,i),i=1,16) / 2.10, 1.90, 0.90, 2.00, 2.00, 2.40, &
       & 2.00, 2.40, 0.90, 2.00, 1.40, 0.70, 2.00, 2.40, 1.70, 2.00 /
        DATA (ug(60,i),i=1,16) / 2.20, 1.00, 1.80, 2.00, 1.10, 1.90, &
       & 2.00, 1.90, 1.80, 2.00, 1.50,-1.20, 2.00, 1.90,-0.20, 1.90 /
        DATA (ug(61,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(62,i),i=1,16) / 3.40, 2.50, 2.50, 2.00, 2.60, 2.50, &
       & 2.00, 2.50, 2.50, 2.00, 2.70, 1.30, 2.00, 2.50, 2.30, 1.70 /
        DATA (ug(63,i),i=1,16) / 1.00,-0.30, 0.50, 2.00,-0.20, 0.70, &
       & 2.00, 0.70, 0.50, 2.00, 0.30,-2.50, 2.00, 0.70,-1.50, 0.70 /
        DATA (ug(64,i),i=1,16) / 2.90, 1.70, 2.50, 2.00, 1.80, 1.60, &
       & 2.00, 1.60, 2.50, 2.00, 2.20, 1.30, 2.00, 1.60, 2.30, 0.80 /
        DATA (ug(65,i),i=1,16) / 2.80, 2.30, 1.70, 2.00, 2.80, 3.40, &
       & 2.00, 3.40, 1.70, 2.00, 2.10, 1.00, 2.00, 3.10, 2.20, 2.90 /
        DATA (ug(66,i),i=1,16) / 2.80, 2.30, 1.70, 2.00, 2.80, 2.80, &
       & 2.00, 2.80, 1.70, 2.00, 2.10, 0.00, 2.00, 2.50, 1.20, 1.90 /
        DATA (ug(67,i),i=1,16) / 1.70, 1.30, 0.70, 2.00, 1.70, 2.70, &
       & 2.00, 2.70, 0.70, 2.00, 1.10, 0.70, 2.00, 2.40, 2.00, 2.70 /
        DATA (ug(68,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(69,i),i=1,16) / 2.30, 1.90, 1.30, 2.00, 2.30, 2.30, &
       & 2.00, 2.30, 1.30, 2.00, 1.70,-0.50, 2.00, 2.00, 0.80, 1.50 /
        DATA (ug(70,i),i=1,16) / 3.40, 2.30, 2.70, 2.00, 2.80, 2.80, &
       & 2.00, 2.80, 2.70, 2.00, 2.70, 1.00, 2.00, 2.50, 2.20, 1.90 /
        DATA (ug(71,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(72,i),i=1,16) / 3.10, 2.00, 2.40, 2.00, 2.50, 2.50, &
       & 2.00, 2.50, 2.40, 2.00, 2.40, 0.70, 2.00, 2.20, 1.90, 1.60 /
        DATA (ug(73,i),i=1,16) / 1.70, 1.30, 0.70, 2.00, 1.70, 2.70, &
       & 2.00, 2.70, 0.70, 2.00, 1.10, 0.70, 2.00, 2.40, 2.00, 2.70 /
        DATA (ug(74,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(75,i),i=1,16) / 2.10, 1.70, 1.10, 2.00, 2.10, 2.70, &
       & 2.00, 2.70, 1.10, 2.00, 1.50, 0.30, 2.00, 2.40, 1.60, 2.30 /
        DATA (ug(76,i),i=1,16) / 2.20, 0.80, 2.00, 2.00, 1.20, 2.20, &
       & 2.00, 2.20, 2.00, 2.00, 1.60,-1.60, 2.00, 1.90,-0.30, 2.20 /
        DATA (ug(77,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(78,i),i=1,16) / 3.40, 2.30, 2.70, 2.00, 2.80, 2.80, &
       & 2.00, 2.80, 2.70, 2.00, 2.70, 1.00, 2.00, 2.50, 2.20, 1.90 /
        DATA (ug(79,i),i=1,16) / 1.00,-0.50, 0.70, 2.00, 0.00, 1.00, &
       & 2.00, 1.00, 0.70, 2.00, 0.30,-2.90, 2.00, 0.70,-1.60, 0.90 /
        DATA (ug(80,i),i=1,16) / 2.90, 1.50, 2.70, 2.00, 1.90, 1.90, &
       & 2.00, 1.90, 2.70, 2.00, 2.30, 0.90, 2.00, 1.60, 2.20, 1.10 /
        DATA (ug(81,i),i=1,16) / 2.80, 2.50, 1.50, 2.00, 2.60, 3.10, &
       & 2.00, 3.10, 1.50, 2.00, 2.10, 1.30, 2.00, 3.10, 2.30, 2.70 /
        DATA (ug(82,i),i=1,16) / 2.80, 2.50, 1.50, 2.00, 2.60, 2.50, &
       & 2.00, 2.50, 1.50, 2.00, 2.10, 0.30, 2.00, 2.50, 1.30, 1.70 /
        DATA (ug(83,i),i=1,16) / 1.70, 1.50, 0.50, 2.00, 1.60, 2.40, &
       & 2.00, 2.40, 0.50, 2.00, 1.00, 1.10, 2.00, 2.40, 2.10, 2.40 /
        DATA (ug(84,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(85,i),i=1,16) / 2.30, 2.10, 1.10, 2.00, 2.20, 2.00, &
       & 2.00, 2.00, 1.10, 2.00, 1.60,-0.10, 2.00, 2.00, 0.90, 1.20 /
        DATA (ug(86,i),i=1,16) / 3.40, 2.50, 2.50, 2.00, 2.60, 2.50, &
       & 2.00, 2.50, 2.50, 2.00, 2.70, 1.30, 2.00, 2.50, 2.30, 1.70 /
        DATA (ug(87,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(88,i),i=1,16) / 3.10, 2.20, 2.20, 2.00, 2.30, 2.20, &
       & 2.00, 2.20, 2.20, 2.00, 2.40, 1.00, 2.00, 2.20, 2.00, 1.40 /
        DATA (ug(89,i),i=1,16) / 1.70, 1.50, 0.50, 2.00, 1.60, 2.40, &
       & 2.00, 2.40, 0.50, 2.00, 1.00, 1.10, 2.00, 2.40, 2.10, 2.40 /
        DATA (ug(90,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(91,i),i=1,16) / 2.10, 1.90, 0.90, 2.00, 2.00, 2.40, &
       & 2.00, 2.40, 0.90, 2.00, 1.40, 0.70, 2.00, 2.40, 1.70, 2.00 /
        DATA (ug(92,i),i=1,16) / 2.20, 1.00, 1.80, 2.00, 1.10, 1.90, &
       & 2.00, 1.90, 1.80, 2.00, 1.50,-1.20, 2.00, 1.90,-0.20, 1.90 /
        DATA (ug(93,i),i=1,16) / 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, &
       & 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00, 2.00 /
        DATA (ug(94,i),i=1,16) / 3.40, 2.50, 2.50, 2.00, 2.60, 2.50, &
       & 2.00, 2.50, 2.50, 2.00, 2.70, 1.30, 2.00, 2.50, 2.30, 1.70 /
        DATA (ug(95,i),i=1,16) / 1.00,-0.30, 0.50, 2.00,-0.20, 0.70, &
       & 2.00, 0.70, 0.50, 2.00, 0.30,-2.50, 2.00, 0.70,-1.50, 0.70 /
        DATA (ug(96,i),i=1,16) / 2.90, 1.70, 2.50, 2.00, 1.80, 1.60, &
       & 2.00, 1.60, 2.50, 2.00, 2.20, 1.30, 2.00, 1.60, 2.30, 0.80 /


        !         (3)(5)         !
        ! 5' (1) A .  . X (7) 3' !
        ! 3' (2) U .  . Y (8) 5' !
        !         (4)(6)         !

        i1 = list(1)
        i2 = list(2)
        i3 = list(3)
        i4 = list(4)
        i5 = list(5)
        i6 = list(6)
        i7 = list(7)
        i8 = list(8)

        j = 4 * i3 - 4 + i4
        k = 4 * i5 - 4 + i6

        IF ( i7 == 1 .and. i8 == 4 ) j = j + 0
        IF ( i7 == 2 .and. i8 == 3 ) j = j + 16
        IF ( i7 == 3 .and. i8 == 2 ) j = j + 32
        IF ( i7 == 4 .and. i8 == 1 ) j = j + 48
        IF ( i7 == 3 .and. i8 == 4 ) j = j + 64
        IF ( i7 == 4 .and. i8 == 3 ) j = j + 80

        IF ( i1 == 1 .and. i2 == 4 ) eb = eb + au(j,k)
        IF ( i1 == 2 .and. i2 == 3 ) eb = eb + cg(j,k)
        IF ( i1 == 3 .and. i2 == 2 ) eb = eb + gc(j,k)
        IF ( i1 == 4 .and. i2 == 1 ) eb = eb + ua(j,k)
        IF ( i1 == 3 .and. i2 == 4 ) eb = eb + gu(j,k)
        IF ( i1 == 4 .and. i2 == 3 ) eb = eb + ug(j,k)

        RETURN

      END SUBROUTINE TINT22
