! ==============================================================================
! Subroutine: MRNA_INIT (RNA,IBSP)
! 
! Purpose: Adds a new RNA to the end of the MRNA list and initializes
!          its data structures and possible reactions.
!
! Method:  The info array holds the following information:
!
!          istate = info(1,i) --> state of the RNA or enzyme object
!            ipro = info(2,i) --> protein number bound to the helix
!           ileaf = info(3,i) --> link to the first helix in the multi-loop
!           iroot = info(4,i) --> link to the root helix (or 0 if ext loop)
!            iloc = info(5,i) --> 5' nt of closing base pair
!            jloc = info(6,i) --> 3' nt of closing base pair
!
! Arguments:
!
!             RNA - Class structure containing information on the
!                   RNA and its possible reactions.
!            IBSP - Current secondary structure of the RNA.
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            01/01/2019   Original Code
!
! Dependancies:
!
! Modules - RNADATA
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!            Copyright (c) 2019 (Please Refer to LICENCE)
!
! ==============================================================================

      SUBROUTINE MRNA_INIT (RNA)

        USE RNAData, ONLY : nnuc

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        TYPE(MRNA), INTENT(INOUT) :: rna

        !=== VARIABLES ===!

        INTEGER :: i,imin,imax


        !=== Initialize RNA Data ===!


        rna% ihead = 1
        rna% iadd = 2

        rna% inext(:) = 0
        rna% iprev(:) = 0
        rna% ilist(1) = 0

        DO i=2,mxobj
        rna% ilist(i) = i
        ENDDO

        rna% info(:,:) = 0

        !== Zero Partial Sum Table ===!

        rna% a(:) = 0.0d0
        rna% atot(:,:) = 0.0d0
        rna% psum(:,:) = 0.0d0

        !=== Initial RNA Structure ===!

        rna% ibsp(:) = 0

        imin = 1
        imax = nnuc

        !=== Compute RBS Binding Reactions ===!

        CALL RBS_REAC (rna,imin,imax)

        !=== Compute Folding Times ===!

!        CALL FOLD_REAC (rna,imin,imax)

        rna% tnext = 1.0d9
        rna% ifold = 1

        RETURN

      END SUBROUTINE MRNA_INIT
