! ==============================================================================
! Subroutine: RESUM (RNA,INDX,A)
!
! Purpose: Re-sums the partial sum table in the mRNA class for entry IDX.
!
! Method: Uses a binary tree to store a partial sum table of reaction
!         propensities.
!
! Arguments:
!
!             RNA - Class structure containing information on the
!                   RNA and its possible reactions.
!             INDX- RNA object number to resum the partial sum table.
!             A   - Array of the reaction propensities for the object
!                   for each protein type (1-MXPRO).
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            01/01/2019   Original Code
!
! Dependancies:
!
! Modules -
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!            Copyright (c) 2019 (Please Refer to LICENCE)
!
! ==============================================================================

      SUBROUTINE RESUM (RNA,INDX,A)

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        TYPE(MRNA), INTENT(INOUT) :: rna
        INTEGER, INTENT(IN) :: indx

        DOUBLE PRECISION, INTENT(IN) :: a(0:mxpro)

        !=== VARIABLES ===!

        INTEGER :: i,j,k,n,n1,n2,ip


        !=== Reset total propensity ===!

        rna% atot(:,indx) = a(:)

        !=== Index into psum ===!

        i = indx
        IF ( MOD(indx,2) == 0 ) i = i - 1


        !=== Resum Partial Sum Table ===!

        n = 1
        n1= 2
        n2= 4

        rna% psum(:,i) = rna% atot(:,i+0) + rna% atot(:,i+1)

        DO WHILE ( n1 < mxobj )

          i = INT(i/n2) * n2 + n1

          j = i - n
          k = i + n

          rna% psum(:,i) = rna% psum(:,j) + rna% psum(:,k)

          n  = n1
          n1 = n2
          n2 = 2 * n2

        ENDDO

        n = mxobj/2

        rna% a(:) = rna% psum(:,n)

        RETURN

      END SUBROUTINE RESUM
