! ==============================================================================
! Subroutine: BARRIER_MH (IBSP,JBSP,N,EB)
! 
! Purpose: Constructs a direct path between two RNA folding states (A and B)
!          and returns the smallest energy barrier encountered along the path.
!
! Method:  Morgan-Higgs greedy method:
!          (PAPER)
!
! Arguments:
!
!          IBSP - (INPUT) Array of dimension N containing the
!                 information on base pairs in fold state A.
!                 IBSP(i) = j [i base pairs with j]
!                 IBSP(i) = 0 [i is single stranded]
!          JBSP - (INPUT) Array of dimension N containing the
!                 information on base pairs in fold state B.
!             N - (INPUT) Number of nucleotides in the sequence.
!            EB - (OUTPUT) Maximum Barrier energy encountered.
!
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            01/01/2019   Original Code
!
! Dependencies:
!
! Modules -
! Functions -
! Subroutines - GETLOOPS, DELTAG, QUICKSORT
!
! Author(s): Eric Dykeman
!            Copyright (c) 2019 (Please Refer to LICENCE)
!
! ==============================================================================

      SUBROUTINE BARRIER_MH (IBSP,JBSP,N,EB)

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        INTEGER, INTENT(IN) :: n
        INTEGER, INTENT(IN) :: ibsp(n),jbsp(n)

        DOUBLE PRECISION, INTENT(OUT) :: eb

        !=== VARAIBLES ===!

        DOUBLE PRECISION, PARAMETER :: einf = 1.0000d+9
        INTEGER, PARAMETER :: ni = 128

        INTEGER :: i,j,k,ip,jp,im,jm,indx,jndx
        INTEGER :: imv,nmv,ndel,np,mxp,icnt,itot

        INTEGER :: iwrk(ni*n),ipath(ni*n),itemp(ni*n)
        INTEGER :: idist(ni,ni),id(ni,ni),imoves(n)
        INTEGER :: loop(n),nh(n),ns(n),kbsp(n)

        DOUBLE PRECISION :: ewrk(ni*n),etot(ni),emax(ni),emin(ni)
        DOUBLE PRECISION :: et(ni),e1(ni),e2(ni),ei,ej,dg,EPATH(ni*n),ETMP(ni*n)

        LOGICAL :: ok
         character :: fld(n)

        eb = einf

        nmv = 0

        !=== Generate Move List ===!

        DO i=1,n

          j = ibsp(i)

          !=== BP to DEL ===!

          IF ( j > i .and. j /= jbsp(i) ) THEN
            nmv = nmv + 1
            imoves(nmv) = i
          ENDIF

        ENDDO

        ndel = nmv

        DO i=1,n

          !=== BP to ADD ===!

          j = jbsp(i)

          IF ( j > i .and. j /= ibsp(i) ) THEN
            nmv = nmv + 1
            imoves(nmv) = i
          ENDIF

        ENDDO
  !      do i=1,nmv
  !      if ( i <= ndel ) write(11,*)'Del ',imoves(i),ibsp(imoves(i))
  !      if ( i  > ndel ) write(11,*)'Add ',imoves(i),jbsp(imoves(i))
  !      enddo

        !=== MORGAN HIGGS ===!

        mxp = 1

        DO WHILE ( mxp <= ni )

          !=== Initialize Starting Path ===!

          np = 1

          emax(1) = 0.0d0
          emin(1) = 0.0d0
          etot(1) = 0.0d0

          idist(:,:) = 0

          DO im=1,nmv
          ipath(im) = imoves(im)
          ENDDO
   !         write(12,*)'mxp = ',mxp

          !=== FIND PATH from A to B ===!

          DO imv=1,nmv

            !=== Calculate Energies ===!

            indx = 0
            itot = 0

            DO ip=1,np

              kbsp(:) = ibsp(:)

              DO im=1,nmv
              IF ( ipath(indx+im) == 0 ) THEN

                i = imoves(im)

                IF ( im <= ndel ) THEN
                  j = ibsp(i)
                  kbsp(i) = 0
                  kbsp(j) = 0
                ELSE
                  j = jbsp(i)
                  kbsp(i) = j
                  kbsp(j) = i
                ENDIF

              ENDIF
              ENDDO

              CALL GETLOOPS (kbsp,loop,nh,ns,n)

              DO im=1,nmv
              IF ( ipath(indx+im) /= 0 ) THEN

                i = imoves(im)

                ok = .false.

                IF ( im <= ndel ) THEN
                  j = ibsp(i)
                  ok = .true.
                ELSE
                  j = jbsp(i)
                  IF ( kbsp(i) == 0 .and. kbsp(j) == 0 ) THEN
                  IF ( loop(i) == loop(j) ) ok = .true.
                  ENDIF
                ENDIF

                IF ( ok ) THEN

                  CALL DELTAG (kbsp,loop,nh,ns,i,j,dg)

!                  call ESTRUC (kbsp,1,ei)
!                  if ( im <=ndel ) then
!                  kbsp(i) = 0
!                  kbsp(j) = 0
!                  call estruc (kbsp,1,ej)
!                  kbsp(i) = j
!                  kbsp(j) = i
!                  else
!                  kbsp(i) = j
!                  kbsp(j) = i
!                  call estruc (kbsp,1,ej)
!                  kbsp(i) = 0
!                  kbsp(j) = 0
!                  endif
!                   if ( dabs(ej-ei-dg) >= 0.01d0 ) then
!                   write(88,*)i,j,ei,ej,ej-ei,dg
!                   call v2ct (kbsp,fld,'V',n)
!                   write(88,'(200A1)')(fld(k),k=1,n)
!                   endif

                  itot = itot + 1
                  iwrk(itot) = indx + im
                  ewrk(itot) = dg + etot(ip)

                ENDIF

              ENDIF
              ENDDO

              indx = indx + nmv

            ENDDO

            !=== Sort Energies ===!

            CALL QUICKSORT (iwrk,ewrk,itot)
    !          do i=1,MIN(ni,itot)
    !          indx = iwrk(i)
    !          ei = ewrk(i)

    !          ip = indx - 1
    !          im = MOD(ip,nmv) + 1
    !          ip = INT(ip/nmv) + 1
   !                 write(12,*)'Low ',i,ip,im,ei,ei-etot(ip)
    !          enddo
            i = 0
            np = 0

            !=== PATH SELECTION ===!

            DO WHILE ( np < mxp .and. i < itot )

              i = i + 1

              indx = iwrk(i)
              ei = ewrk(i)

              ip = indx - 1
              im = MOD(ip,nmv) + 1
              ip = INT(ip/nmv) + 1

              IF ( ei > eb ) EXIT

              !=== Check for Path Duplicate ===!

              ok = .true.

              IF ( np > 0 ) THEN

                DO j=1,np

                  jndx = iwrk(j)

                  jp = jndx - 1
                  jm = MOD(jp,nmv) + 1
                  jp = INT(jp/nmv) + 1
 
                  IF ( ip < jp ) THEN
                    icnt = idist(ip,jp)
                  ELSE
                    icnt = idist(jp,ip)
                  ENDIF

                  k = (ip-1) * nmv + jm

                  IF ( ipath(k) == 0 ) THEN
                    icnt = icnt - 1
                  ELSE  
                    icnt = icnt + 1
                  ENDIF

                  k = (jp-1) * nmv + im

                  IF ( ipath(k) == 0 ) THEN
                    icnt = icnt - 1
                  ELSE
                    icnt = icnt + 1
                  ENDIF

                  id(j,np+1) = icnt

                  IF ( icnt == 0 ) THEN

                    ok = .false.

                    !=== Take Minimum Barrier Path ===!

                    IF ( emax(ip) < emax(jp) ) THEN
                      iwrk(j) = iwrk(i)
                      ewrk(j) = ewrk(i)
                    ENDIF

                    EXIT

                  ENDIF

                ENDDO

              ENDIF

              !=== Add New Path? ===!

              IF ( ok ) THEN

                np = np + 1

                iwrk(np) = iwrk(i)
                ewrk(np) = ewrk(i)

              ENDIF

            ENDDO

            !=== END PATH SELECTION ===!

            !=== Copy Selected Paths ===!

            k = 0

            DO i=1,np

              indx = iwrk(i)
              ei = ewrk(i)

              ip = indx - 1
              im = MOD(ip,nmv) + 1
              ip = INT(ip/nmv) + 1

              et(i) = ei
              e1(i) = emax(ip)
              e2(i) = emin(ip)

              IF ( ei > e1(i) ) e1(i) = ei
              IF ( ei < e2(i) ) e2(i) = ei
 !                   write(12,*)i,ip,im,et(i),et(i)-etot(ip),e1(i)
              indx = (ip-1) * nmv

              DO j=1,nmv
              itemp(k+j) = ipath(indx+j)
              ETMP(k+j) = epath(indx+j)
              ENDDO

              itemp(k+im) = 0
              ETMP(k+imv) = et(i)

              k = k + nmv

            ENDDO

            etot(:) = et(:)
            emax(:) = e1(:)
            emin(:) = e2(:)

            EPATH(:) = ETMP(:)

            ipath(:) = itemp(:)
            idist(:,:) = id(:,:)

          ENDDO

          !=== END FIND PATH ===!


          !=== Get Minimum Barrier ===!

          eb = emax(1)
        !    write(*,*)'mxp = ',mxp,eb

          !=== Increase Maximum Number of Paths ===!

          mxp = 2 * mxp

        ENDDO
        ! do i=1,nmv
        ! write(13,*)i,epath(i)
        ! enddo
        RETURN

      END SUBROUTINE BARRIER_MH
