! ==============================================================================
! Subroutine: GETLOOPS (IBSP,LOOP,NH,NS,N)
! 
! Purpose: Calculates a loop index number for each nucleotide in an RNA
!          sequence along with the number of helix and ss nt in each loop.
!
! Method:
!
! Arguments:
!
!          IBSP - (INPUT) Array of dimension N containing the
!                 information on base pairs in RNA fold.
!                 IBSP(i) = j [i base pairs with j]
!                 IBSP(i) = 0 [i is single stranded]
!          LOOP - (OUTPUT) Array containing loop numbers for each
!                 nucleotide in the sequence.
!            NH - (OUTPUT) Array containing the number of helix in each loop.
!            NS - (OUTPUT) Array containing the number of ss nt in each loop.
!             N - (INPUT) Number of nucleotides in the sequence.
!
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            01/01/2019   Original Code
!
! Dependencies:
!
! Modules -
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!            Copyright (c) 2019 (Please Refer to LICENCE)
!
! ==============================================================================

      SUBROUTINE GETLOOPS (IBSP,LOOP,NH,NS,N)

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        INTEGER, INTENT(IN) :: n,ibsp(n)
        INTEGER, INTENT(OUT) :: loop(n),nh(n),ns(n)

        !=== VARAIBLES ===!

        INTEGER :: i,j,ilp,nl


        nl = 1
        ilp = 1

        nh(1) = 0
        ns(1) = 0

        !=== Identify Loops ===!

        DO i=1,n

          j = ibsp(i)

          IF ( j > i ) THEN

            loop(j) = ilp

            !=== Helix Count ===!

            IF ( ilp > 0 ) nh(ilp) = nh(ilp) + 1

            !=== New Loop? ===!

            IF ( ibsp(i+1) == j-1 ) THEN

              ilp = 0

            ELSE

              nl = nl + 1

              ilp = nl

              nh(nl) = 1
              ns(nl) = 0

            ENDIF

            loop(i) = ilp

          ELSEIF ( j > 0 ) THEN

            ilp = loop(i)

          ELSEIF ( j == 0 ) THEN

            loop(i) = ilp

            !=== Single Stranded Count ===!

            IF ( ilp > 0 ) ns(ilp) = ns(ilp) + 1

          ENDIF

        ENDDO

        RETURN

      END SUBROUTINE GETLOOPS
