! ==============================================================================
! Module: CONSTANTS
! 
! Purpose: Contains various constants needed for calculating rates and 
!          converting between units.
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            01/01/2019   Original Code
!
! Contains:
!
! Modules -
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!            Copyright (c) 2019 (Please Refer to LICENCE)
!
! ==============================================================================

      MODULE CONSTANTS

        IMPLICIT NONE

        !=== PARAMETERS ===!

        INTEGER, PARAMETER :: mxnt = 8192
        INTEGER, PARAMETER :: nmax = 8390656  != mxnt*(mxnt + 1)/2!

        INTEGER, PARAMETER :: mxobj = 256
        INTEGER, PARAMETER :: mxrna = 8192
        INTEGER, PARAMETER :: mxpro = 14
        INTEGER, PARAMETER :: nstand= 20

        INTEGER, PARAMETER :: i5p_ribo = 24
        INTEGER, PARAMETER :: i3p_ribo = 17
        INTEGER, PARAMETER :: i5p_sdsq = 14
        INTEGER, PARAMETER :: i3p_sdsq = 2

        DOUBLE PRECISION, PARAMETER :: cfac  = 0.16605389210321896964d-2 !(um^3)*(uM)!
        DOUBLE PRECISION, PARAMETER :: gcons = 1.987206d-3
        DOUBLE PRECISION, PARAMETER :: tinf  = 1.000000d10
        DOUBLE PRECISION, PARAMETER :: r_fold= 3.000000d+7

        !=== VARIABLES ===!

        DOUBLE PRECISION, SAVE :: beta = 0.16225023135094183147d1
        DOUBLE PRECISION, SAVE :: temp = 310.150d0
        DOUBLE PRECISION, SAVE :: vol  = 1.00d0

        !=== Global Variables ===!

        INTEGER, SAVE :: nrna
        INTEGER, SAVE :: iqueue_rna(mxrna)

        DOUBLE PRECISION, SAVE :: time,xribo_tot
        DOUBLE PRECISION, SAVE :: psum_rna(0:mxpro,mxrna)

      END MODULE CONSTANTS
