! ==============================================================================
! Module: PROTEIN
! 
! Purpose: Contains the variables for the proteins which can bind to RNA
!          or bind to ribosomes/replicases on the RNA.
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            01/01/2019   Original Code
!
! Contains:
!
! Modules - CONSTANTS
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!            Copyright (c) 2019 (Please Refer to LICENCE)
!
! ==============================================================================

      MODULE PROTEIN

        USE Constants, ONLY : mxpro

        IMPLICIT NONE

        !=== VARIABLES ===!

        INTEGER, SAVE :: npro(mxpro)

        !=== Cellular Proteins that bind mRNA/Enzymes ===!

        !=== Protein IDs ===!

        INTEGER, PARAMETER :: id_30pi = 1
        INTEGER, PARAMETER :: id_50s  = 2
        INTEGER, PARAMETER :: id_tcx  = 3
        INTEGER, PARAMETER :: id_efg  = 4
        INTEGER, PARAMETER :: id_rf1  = 5
        INTEGER, PARAMETER :: id_rf2  = 6
        INTEGER, PARAMETER :: id_rf3  = 7
        INTEGER, PARAMETER :: id_rrf  = 8
        INTEGER, PARAMETER :: id_if3  = 9

        !=== Synthesized Proteins ===!

        INTEGER, PARAMETER :: id_coat = 10
        INTEGER, PARAMETER :: id_rdrp = 11
        INTEGER, PARAMETER :: id_apro = 12
        INTEGER, PARAMETER :: id_lys  = 13

        !=== Cellular Proteins and Small Molecules ===!

        !=== 30S Initiation ===!

        INTEGER, SAVE :: n_ifac(6)
        INTEGER, SAVE :: n_ribo(6)

        !=== Elongation/Recycling ===!

        INTEGER, SAVE :: n_elong(10)
        INTEGER, SAVE :: n_rfac(6)

        !=== Aminos and TRNAs ===!

        INTEGER, SAVE :: nars_aa(20)
        INTEGER, SAVE :: nars(20)
        INTEGER, SAVE :: naa(20)

        INTEGER, SAVE :: ntcx(65)
        INTEGER, SAVE :: ntrna_aa(65)
        INTEGER, SAVE :: ntrna(65)

        !=== NxPs ===!

        INTEGER, SAVE :: n_ntp(4),n_ndp(4),n_nmp(4)
!STATS
        integer, save :: ncount(7),ntr_tot(65)
        integer, save :: nstats(5)

      END MODULE PROTEIN
