! ==============================================================================
! Module: RIBOSOME
! 
! Purpose: Contains the kinetic parameters for reactions related to
!          the ribosome.
!
!          For a list of parameters see:
!
!          Dykeman (2019)
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            01/01/2019   Original Code
!
! Contains:
!
! Modules -
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!            Copyright (c) 2019 (Please Refer to LICENCE)
!
! ==============================================================================

      MODULE RIBOSOME

        IMPLICIT NONE

        !=== ALLOCATABLE ARRAYS ===!

        !=== VARIABLES ===!

        !=== 30S:PIC Formation ===!

        DOUBLE PRECISION, SAVE :: r_pic_f(4)
        DOUBLE PRECISION, SAVE :: r_pic_b(4)

        !=== Ribosome 30PIC Binding ===!

        DOUBLE PRECISION, SAVE :: r_b1f,r_b1b
        DOUBLE PRECISION, SAVE :: r_b2f,r_b2b
        DOUBLE PRECISION, SAVE :: r_b3f

        !=== Ribosome Initiation ===!

        DOUBLE PRECISION, SAVE :: r_i1f,r_i1b
        DOUBLE PRECISION, SAVE :: r_i2f,r_i2b

        DOUBLE PRECISION, SAVE :: r_i3
        DOUBLE PRECISION, SAVE :: r_i4f
        DOUBLE PRECISION, SAVE :: r_i4b
        DOUBLE PRECISION, SAVE :: r_i5
        DOUBLE PRECISION, SAVE :: r_i6
        DOUBLE PRECISION, SAVE :: r_i7
        DOUBLE PRECISION, SAVE :: r_i8

        !=== Ribosome Elongation ===!

        DOUBLE PRECISION, SAVE :: r_e1f
        DOUBLE PRECISION, SAVE :: r_e1b
        DOUBLE PRECISION, SAVE :: r_e2f(64,64)
        DOUBLE PRECISION, SAVE :: r_e2b(64,64)
        DOUBLE PRECISION, SAVE :: r_e3(64,64)
        DOUBLE PRECISION, SAVE :: r_e4(64,64)
        DOUBLE PRECISION, SAVE :: r_e5(64,64)
        DOUBLE PRECISION, SAVE :: r_e6(64,64)

        !=== Ribosome Translocation ===!

        DOUBLE PRECISION, SAVE :: r_e7f,r_e7b
        DOUBLE PRECISION, SAVE :: r_e8,r_e9,r_e10

        !=== Ribosome Termination ===!

        DOUBLE PRECISION, SAVE :: r_t1f(64,2)
        DOUBLE PRECISION, SAVE :: r_t1b(64,2)
        DOUBLE PRECISION, SAVE :: r_t2(64,2)

        DOUBLE PRECISION, SAVE :: r_t3f,r_t3b
        DOUBLE PRECISION, SAVE :: r_t4f,r_t4b
        DOUBLE PRECISION, SAVE :: r_t5(2),r_t9(2)
        DOUBLE PRECISION, SAVE :: r_t6,r_t7,r_t8

        !=== Ribosome Recycling ===!

        DOUBLE PRECISION, SAVE :: r_r1f,r_r1b
        DOUBLE PRECISION, SAVE :: r_r2f,r_r2b
        DOUBLE PRECISION, SAVE :: r_r3,r_r4

        !=== Ribosome Scanning ===!

      END MODULE RIBOSOME
