! ==============================================================================
! Subroutine: SETUP_FOLDING (FILENAME,FLAG)
! 
! Purpose: Reads in the RNA energy data files and sets up some tables.
!
! Method:
!
! Arguments:
!
!        FILENAME - (CHARAC)  Name of the file containing new parameters.
!            FLAG - (LOGICAL) If  TRUE: Read in new parameters.
!                             if FALSE: Use Default parameters.
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            01/01/2019   Original Code
!
! Dependancies:
!
! Modules - FOLDING, RNADATA, CONSTANTS
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!            Copyright (c) 2019 (Please Refer to LICENCE)
!
! ==============================================================================

      SUBROUTINE SETUP_FOLDING (FILENAME,FLAG)

        USE Folding,  ONLY : iwc,eaup,eau
        USE RNAData,  ONLY : indx_col,indx_row
        USE Constants,ONLY : mxnt


        IMPLICIT NONE

        !=== ARGUMENTS ===!

        CHARACTER (LEN=255), INTENT(IN) :: filename
        LOGICAL, INTENT(IN) :: flag

        !=== VARIABLES ===!

        INTEGER :: i,k


        !=== Open Parameter File ===!

        IF ( flag ) OPEN (UNIT=101,FILE=filename,STATUS='Unknown')


        !=== Setup Parameter Tables ===!

        CALL TSTACK (flag)

        CALL TINT (flag)

        CALL TMISC (flag)

        IF ( flag ) CLOSE(UNIT=101)


        !=== Setup Watson/Crick Tables ===!

        !=== A=1,C=2,G=3,U=4 ===!

        iwc(:,:) = 0
        iwc(1,4) = 1
        iwc(2,3) = 2
        iwc(3,2) = 3
        iwc(3,4) = 4
        iwc(4,1) = 5
        iwc(4,3) = 6

        eaup(:,:) = 0.0d0
        eaup(1,4) = eau
        eaup(4,1) = eau
        eaup(3,4) = eau
        eaup(4,3) = eau

        !=== Setup Row and Column Index Arrays ===!

        k = 1

        DO i=1,mxnt

          indx_col(i) = i + k
          k = indx_col(i)

        ENDDO

        k = 0
        indx_row(1) = 0

        DO i=1,mxnt-1

          indx_row(i+1) = mxnt - i + k
          k = indx_row(i+1)

        ENDDO

        RETURN

      END SUBROUTINE SETUP_FOLDING
