! ==============================================================================
! Subroutine: SETUP_RIBOSOME (FILENAME,FLAG)
! 
! Purpose: Reads in the ribosomal kinetic rate data files.
!
! Method:
!
! Arguments:
!
!        FILENAME - (CHARAC)  Name of the file containing new parameters.
!            FLAG - (LOGICAL) If  TRUE: Read in new parameters.
!                             if FALSE: Use Default parameters.
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            01/01/2019   Original Code
!
! Dependancies:
!
! Modules -
! Functions -
! Subroutines - TRIBO
!
! Author(s): Eric Dykeman
!            Copyright (c) 2019 (Please Refer to LICENCE)
!
! ==============================================================================

      SUBROUTINE SETUP_RIBOSOME (FILENAME,FLAG)

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        CHARACTER (LEN=255), INTENT(IN) :: filename
        LOGICAL, INTENT(IN) :: flag

        !=== VARIABLES ===!

        INTEGER :: i,k


        !=== Open Parameter File ===!

        IF ( flag ) OPEN (UNIT=101,FILE=filename,STATUS='Unknown')


        !=== Setup Parameter Tables ===!

        CALL TRIBO (flag)

        IF ( flag ) CLOSE(UNIT=101)

        RETURN

      END SUBROUTINE SETUP_RIBOSOME
