! ==============================================================================
! Module: CLASS_MRNA
! 
! Purpose: A FORTRAN class structure containing subroutines and data
!          elements required for monitoring the state of an mRNA
!          in the Ribosome protein synthesis model.
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            01/01/2019   Original Code
!
! Dependancies:
!
! Modules - CONSTANTS
! Functions -
! Subroutines - 
!
! Author(s): Eric Dykeman
!            Copyright (c) 2019 (Please Refer to LICENCE)
!
! ==============================================================================

      MODULE CLASS_MRNA

        USE Constants, ONLY : mxnt,mxobj,mxpro,time

        IMPLICIT NONE

        PRIVATE

        PUBLIC :: MRNA_INIT, MRNA_FIRE

        TYPE, PUBLIC :: MRNA

          !=== RNA Fold Info ===!

          INTEGER :: ibsp(mxnt)
          INTEGER :: icdn(mxnt)
          INTEGER :: nnuc

          !=== RNA Object Info ===!

          INTEGER :: ihead
          INTEGER :: iadd

          INTEGER :: inext(mxobj)
          INTEGER :: iprev(mxobj)
          INTEGER :: ilist(mxobj)

          INTEGER :: info(6,mxobj)

          !=== Folding Times ===!

          INTEGER :: ifold

          DOUBLE PRECISION :: tnext,t(mxobj)
          DOUBLE PRECISION :: tau_hpn(0:5,mxobj)
          DOUBLE PRECISION :: tau_mlp(0:5,mxobj)

          !=== Total Reaction Flux ===!

          DOUBLE PRECISION :: a(0:mxpro)
          DOUBLE PRECISION :: atot(0:mxpro,mxobj)
          DOUBLE PRECISION :: psum(0:mxpro,mxobj)

        END TYPE MRNA

        CONTAINS

        INCLUDE 'resum.f90'

        INCLUDE 'mrna_fire.f90'
        INCLUDE 'mrna_init.f90'

        INCLUDE 'rbs_fire.f90'
        INCLUDE 'rbs_reac.f90'

        INCLUDE 'ribo_fire.f90'
        INCLUDE 'ribo_reac.f90'

!        INCLUDE 'pro_fire.f90'
!        INCLUDE 'pro_reac.f90'

!        INCLUDE 'fold_fire.f90'
!        INCLUDE 'fold_reac.f90'

      END MODULE CLASS_MRNA
