! ==============================================================================
! Subroutine: CHECK_ENE (IBSP,I5,I3,IFLG)
! 
! Purpose: Checks if the MES of hairpins on the [i5-i3] RNA fragment
!          is less than the energy of the current fold on [i5-i3]. 
!
! Method:
!
! Arguments:
!
!          IBSP - Array of dimension (NNUC) containing the information
!                 on base pairs in the RNA fold.
!                 IBSP(i) = j [i base pairs with j]
!                 IBSP(i) = 0 [i is single stranded]
!            I5 - (INPUT) 5' end of sequence fragment.
!            I3 - (INPUT) 3' end of sequence fragment.
!          IFLG - (OUTPUT) Logical output. 
!                    EMIN = Energy of MES Hairpin fold.
!                       E = Energy of current fold.
!                 IFLG = TRUE  ( IF EMIN  < E )
!                 IFLG = FALSE ( IF EMIN >= E )
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            01/01/2019   Original Code
!
! Dependencies:
!
! Modules - FOLDING, RNADATA, CONSTANTS
! Functions -
! Subroutines - EDANGLE
!
! Author(s): Eric Dykeman
!            Copyright (c) 2019 (Please Refer to LICENCE)
!
! ==============================================================================

      SUBROUTINE CHECK_ENE (IBSP,I5,I3,IFLG)

        USE RNAData,   ONLY : v,vr,vb,iseq,indx_col,indx_row,nnuc
        USE Folding,   ONLY : prec,eaup
        USE Constants, ONLY : mxnt,nmax


        IMPLICIT NONE

        !=== ARGUMENTS ===!

        INTEGER, INTENT(IN) :: i5,i3
        INTEGER, INTENT(IN) :: ibsp(mxnt)

        LOGICAL, INTENT(OUT) :: iflg

        !=== VARIABLES ===!

        INTEGER :: k,ip,jp,kp,ij,ilast

        DOUBLE PRECISION :: e5,e3,ed,e,emin


        iflg = .false.


        !=== Min Energy ===!

        ij = indx_col(i3) - i5

        emin = v(ij)

        !=== Current Energy ===!

        e = 0.0d0
        e3 = 0.0d0

        k = i5
        ilast = 0

        DO WHILE ( k <= i3 )

          IF ( ibsp(k) /= 0 ) THEN

            ip = k
            jp = ibsp(k)

            !=== 5P Dangle Energy ===!

            kp = ip - 1

            e5 = 0.0d0

            IF ( kp >= i5 .and. kp <= i3 ) THEN
            IF ( ibsp(kp) == 0 ) THEN
              CALL EDANGLE (ip,jp,kp,e5)
            ENDIF
            ENDIF

            IF ( ilast == kp ) THEN
              ed = MIN(e3,e5)
            ELSE
              ed = e3 + e5
            ENDIF

            e = e + ed + eaup(iseq(ip),iseq(jp))

            !=== Add Hairpin Energy ===!

            ij = indx_col(jp) - ip

            e = e + vb(ij)

            !=== 3P Dangle Energy ===!

            kp = jp + 1
            ilast = kp

            e3 = 0.0d0

            IF ( kp >= i5 .and. kp <= i3 ) THEN
            IF ( ibsp(kp) == 0 ) THEN
              CALL EDANGLE (ip,jp,kp,e3)
            ENDIF
            ENDIF

            IF ( k /= i3 ) k = ibsp(k)

          ENDIF

          k = k + 1

        ENDDO

        e = e + e3

        IF ( e-emin > prec ) iflg = .true.

        RETURN

      END SUBROUTINE CHECK_ENE
