! ==============================================================================
! Subroutine: CELL_REAC (ATOT)
! 
! Purpose: Computes the reaction propensity for possible background
!          reactions that can occur in the host cell.
!
! Method:
!
! Arguments:
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            01/01/2019   Original Code
!
! Dependancies:
!
! Modules - PROTEIN, RIBOSOME
! Functions - RANDOM
! Subroutines -
!
! Author(s): Eric Dykeman
!            Copyright (c) 2019 (Please Refer to LICENCE)
!
! ==============================================================================

      SUBROUTINE CELL_REAC (ATOT)

        USE Ribosome, ONLY : r_pic_f,r_pic_b
        USE Protein

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        DOUBLE PRECISION, INTENT(OUT) :: atot

        !=== VARIABLES ===!

        INTEGER :: i,i1,i2

        DOUBLE PRECISION :: rf,rb,x1,x2,x3
        DOUBLE PRECISION :: fac = 1.660538d-3


        atot = 0.0d0

        !=== 30S:PIC Formation ===!

        !=== IF3 Binding ===!

        x1 = DBLE(n_ifac(5))
        x2 = DBLE(n_ribo(1))
        x3 = DBLE(n_ribo(2))

        rf = r_pic_f(1) * x1 * x2
        rb = r_pic_b(1) * x3

        atot = atot + rf + rb

        !=== IF2:GTP Binding ===!

        x1 = DBLE(n_ifac(4))
        x2 = DBLE(n_ribo(2))
        x3 = DBLE(n_ribo(3))

        rf = r_pic_f(2) * x1 * x2
        rb = r_pic_b(2) * x3

        atot = atot + rf + rb

        !=== IF1 Binding ===!

        x1 = DBLE(n_ifac(1))
        x2 = DBLE(n_ribo(3))
        x3 = DBLE(n_ribo(4))

        rf = r_pic_f(3) * x1 * x2
        rb = r_pic_b(3) * x3

        atot = atot + rf + rb

        !=== FMET Binding ===!

        x1 = DBLE(n_ifac(6))
        x2 = DBLE(n_ribo(4))
        x3 = DBLE(n_ribo(5))

        rf = r_pic_f(4) * x1 * x2
        rb = r_pic_b(4) * x3

        atot = atot + rf + rb


        !=== TCX Formation ===!

        DO i=1,64

          x1 = DBLE(ntrna_aa(i))
          x2 = DBLE(n_elong(4))
          x3 = DBLE(ntcx(i))

          rf = 1.50d0 * fac * x1 * x2
          rb = 1.30d-3 * x3

          atot = atot + rf + rb

        ENDDO


        !=== GTP/GDP EXCHANGE ===!

        !=== EFTS Binding ===!

        !---EFTU---!

        x1 = DBLE(n_elong(1))
        x2 = DBLE(n_elong(2))
        x3 = DBLE(n_elong(5))

        rf = 1.0d1 * fac * x1 * x2
        rb = 0.03d0 * x3

        atot = atot + rf + rb

        !---EFTU:GDP---!

        x1 = DBLE(n_elong(1))
        x2 = DBLE(n_elong(3))
        x3 = DBLE(n_elong(6))

        rf = 6.0d1 * fac * x1 * x2
        rb = 350.0d0 * x3

        atot = atot + rf + rb

        !---EFTU:GTP---!

        x1 = DBLE(n_elong(1))
        x2 = DBLE(n_elong(4))
        x3 = DBLE(n_elong(7))

        rf = 3.0d1 * fac * x1 * x2
        rb = 60.0d0 * x3

        atot = atot + rf + rb

        !=== EFTU GTP Binding ===!

        !---EFTU---!

        x1 = DBLE(n_ntp(3))
        x2 = DBLE(n_elong(2))
        x3 = DBLE(n_elong(4))

        rf = 0.5d0 * fac * x1 * x2
        rb = 0.03d0 * x3

        atot = atot + rf + rb

        !---EFTU:TS---!

        x1 = DBLE(n_ntp(3))
        x2 = DBLE(n_elong(5))
        x3 = DBLE(n_elong(7))

        rf = 6.0d0 * fac * x1 * x2
        rb = 85.0d0 * x3

        atot = atot + rf + rb

        !=== EFTU GDP Binding ===!

        !---EFTU---!

        x1 = DBLE(n_ndp(3))
        x2 = DBLE(n_elong(2))
        x3 = DBLE(n_elong(3))

        rf = 2.0d0 * fac * x1 * x2
        rb = 0.002d0 * x3

        atot = atot + rf + rb

        !---EFTU:TS---!

        x1 = DBLE(n_ndp(3))
        x2 = DBLE(n_elong(5))
        x3 = DBLE(n_elong(6))

        rf = 1.40d1 * fac * x1 * x2
        rb = 125.0d0 * x3

        atot = atot + rf + rb

        !=== IF2 - GTP Binding ===!

        x1 = DBLE(n_ntp(3))
        x2 = DBLE(n_ifac(2))
        x3 = DBLE(n_ifac(4))

        rf = 1.0d1 * fac * x1 * x2
        rb = 67.0d0 * x3

        atot = atot + rf + rb

        !=== IF2 - GDP Binding ===!

        x1 = DBLE(n_ndp(3))
        x2 = DBLE(n_ifac(2))
        x3 = DBLE(n_ifac(3))

        rf = 1.0d1 * fac * x1 * x2
        rb = 16.0d0 * x3

        atot = atot + rf + rb

        !=== EFG - GTP Binding ===!

        x1 = DBLE(n_ntp(3))
        x2 = DBLE(n_elong(8))
        x3 = DBLE(n_elong(10))

        rf = 0.58d0 * fac * x1 * x2
        rb = 13.0d0 * x3

        atot = atot + rf + rb

        !=== EFG - GDP Binding ===!

        x1 = DBLE(n_ndp(3))
        x2 = DBLE(n_elong(8))
        x3 = DBLE(n_elong(9))

        rf = 7.50d0 * fac * x1 * x2
        rb = 300.0d0 * x3

        atot = atot + rf + rb

        !=== RF3 - GTP Binding ===!

        x1 = DBLE(n_ntp(3))
        x2 = DBLE(n_rfac(3))
        x3 = DBLE(n_rfac(5))

        rf = 1.0d1 * fac * x1 * x2
        rb = 0.20d0 * x3

        atot = atot + rf + rb

        !=== RF3 - GDP Binding ===!

        x1 = DBLE(n_ndp(3))
        x2 = DBLE(n_rfac(3))
        x3 = DBLE(n_rfac(4))

        rf = 3.0d1 * fac * x1 * x2
        rb = 0.15d0 * x3

        atot = atot + rf + rb

        RETURN

      END SUBROUTINE CELL_REAC
