! ==============================================================================
! Subroutine: CONVERT (GSEQ,ISEQ,NN,IERR)
! 
! Purpose: Converts a character sequence of A C G U into numerical code.
!
! Method: Converts a nucleic acid sequence to the following numerical
!         code:
!
!              A = 1
!              C = 2
!              G = 3
!            T/U = 4
!
! Arguments:
!
!          GSEQ - (INPUT) Array of length NN containing the sequence
!                 of characters to be converted into numbers.
!          ISEQ - (OUTPUT) Array of length NN containing the sequence
!                 in the numerical code.
!            NN - Number of characters in the sequence.
!          IERR - IF sequence converted OK returns 0.
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            01/01/2019   Original Code
!
! Dependancies:
!
! Modules -
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!            Copyright (c) 2019 (Please Refer to LICENCE)
!
! ==============================================================================

      SUBROUTINE CONVERT (GSEQ,ISEQ,NN,IERR)

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        INTEGER, INTENT(IN) :: nn
        INTEGER, INTENT(OUT) :: iseq(nn)
        INTEGER, INTENT(OUT) :: ierr

        CHARACTER, INTENT(IN) :: gseq(nn)

        !=== VARIABLES ===!

        INTEGER :: i


        ierr = 0

        DO i=1,nn

          iseq(i) = 0

          IF ( gseq(i) == 'A' ) iseq(i) = 1
          IF ( gseq(i) == 'a' ) iseq(i) = 1

          IF ( gseq(i) == 'C' ) iseq(i) = 2
          IF ( gseq(i) == 'c' ) iseq(i) = 2

          IF ( gseq(i) == 'G' ) iseq(i) = 3
          IF ( gseq(i) == 'g' ) iseq(i) = 3

          IF ( gseq(i) == 'U' ) iseq(i) = 4
          IF ( gseq(i) == 'u' ) iseq(i) = 4

          IF ( gseq(i) == 'T' ) iseq(i) = 4
          IF ( gseq(i) == 't' ) iseq(i) = 4

          IF ( iseq(i) == 0 ) ierr = 1

        ENDDO

        RETURN

      END SUBROUTINE CONVERT
