! ==============================================================================
! Subroutine: LOCATEHLX (IBSP,IHLX,N)
!
! Purpose: Given an RNA secondary structure, identifies the locations of the
!          helices, i.e. continuous base-pairing only interupted by bulges. 
!
! Method:
!
! Arguments:
!
!           IBSP -  Array containing the base-pairing information.
!                   IBSP(i) = j (i base-pairs with j)
!                   IBSP(i) = 0 (i is single stranded)
!           IHLX -  Array containing the helix information.
!                   IHLX(i) = j (nt i is part of helix number j)
!              N -  Number of nucleotides in the sequence. 
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            01/01/2018   Original Code
!
! Dependancies:
!
! Modules -
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!            Copyright (c) 2018 (Please Refer to LICENCE)
!
! ==============================================================================

      SUBROUTINE LOCATEHLX (IBSP,IHLX,N)

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        INTEGER, INTENT(IN) :: n
        INTEGER, INTENT(IN) :: ibsp(n)
        INTEGER, INTENT(OUT) :: ihlx(n)

        !=== VARIABLES ===!

        INTEGER :: i,j,k,l,ip,jp,nh
        INTEGER :: is,istk(n)


        i = 1
        j = 0
        is = 0
        nh = 0

        ihlx(:) = 0

        DO WHILE ( ibsp(i) < i .and. i < n )
          i = i + 1
        ENDDO

        IF ( i == n ) RETURN


        DO k=1,n

          !=== Closing BP ===!

          IF ( ibsp(k) < k .and. ibsp(k) > 0 ) j = k


          !=== Opening BP ===!

          IF ( ibsp(k) > k .or. k == n ) THEN

            IF ( ibsp(i) >= j .and. j /= 0 ) THEN

              !=== HP HELIX ===!

              nh = nh + 1

              i = istk(is)
              i = ibsp(i)

              ihlx(i:j) = nh

              i = ibsp(j)
              j = istk(is)

              ihlx(i:j) = nh

              DO WHILE ( istk(is) >= i )
                is = is - 1
                IF ( is == 0 ) EXIT
              ENDDO

              i = k
              j = 0

            ELSEIF ( j /= 0 ) THEN

              !=== HP HELIX ===!

              nh = nh + 1

              l = istk(is)

              ihlx(i:l) = nh

              DO WHILE ( istk(is) >= i )
                is = is - 1
                IF ( is == 0 ) EXIT
              ENDDO

              l = ibsp(l)
              i = ibsp(i)

              ihlx(l:i) = nh

              !=== ML HELIX ===!

              i = ibsp(j)

              DO WHILE ( istk(is) >= i )

                nh = nh + 1

                jp = istk(is)
                ip = jp

                DO WHILE ( ihlx(ip) == 0 )
                  is = is - 1
                  ip = istk(is)
                  IF ( ip == i ) EXIT
                ENDDO

                ihlx(ip:jp) = -nh

                ip = ibsp(ip)
                jp = ibsp(jp)

                ihlx(jp:ip) = -nh

                is = is - 1
                IF ( is == 0 ) EXIT

              ENDDO

              i = k
              j = 0

            ENDIF

            is = is + 1
            istk(is) = k

            IF ( i == k .and. k /= n ) ihlx(k) = 1

          ENDIF

        ENDDO

        RETURN

      END SUBROUTINE LOCATEHLX
