! ==============================================================================
! Subroutine: QUICKSORT (ID,E,N)
! 
! Purpose: Sorts a list of energies from lowest to highest.
!
! Method: Numerical Recipies in FORTRAN
!
! Arguments:
!
!             ID  - (IN/OUT) Array of dimension (N) containing id numbers
!                   to be sorted at the same time as E
!              E  - (IN/OUT) Array of dimension (N) containing the
!                   energies to be sorted.
!              N  - Total number of energies in the list.
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            01/01/2019   Original Code
!
! Dependancies:
!
! Modules -
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!            Copyright (c) 2019 (Please Refer to LICENCE)
!
! ==============================================================================

      SUBROUTINE QUICKSORT (ID,E,N)

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        INTEGER, INTENT(IN) :: n
        INTEGER, INTENT(INOUT) :: id(n)

        DOUBLE PRECISION, INTENT(INOUT) :: e(n)

        !=== VARIABLES ===!

        INTEGER, PARAMETER :: m = 7
        INTEGER, PARAMETER :: ns = 100

        INTEGER :: i,j,k,is,il,ir
        INTEGER :: istk(ns),itmp,ii

        DOUBLE PRECISION :: etmp,ee


        is = 0
        il = 1
        ir = n

 1      IF ( ir - il < m ) THEN

          DO i=il+1,ir

            ii = id(i)
            ee =  e(i)

            DO j=i-1,il,-1

              IF ( e(j) <= ee ) GOTO 2

              id(j+1) = id(j)
               e(j+1) =  e(j)

            ENDDO

            j = il - 1

 2          id(j+1) = ii
             e(j+1) = ee

          ENDDO

          IF ( is == 0 ) RETURN

          ir = istk(is)
          il = istk(is-1)
          is = is - 2

        ELSE

          k = (il + ir) / 2

          itmp = id(k)
          id(k) = id(il+1)
          id(il+1) = itmp

          etmp = e(k)
          e(k) = e(il+1)
          e(il+1) = etmp

          IF ( e(il) > e(ir) ) THEN

            itmp = id(il)
            id(il) = id(ir)
            id(ir) = itmp

            etmp = e(il)
            e(il) = e(ir)
            e(ir) = etmp

          ENDIF

          IF ( e(il+1) > e(ir) ) THEN

            itmp = id(il+1)
            id(il+1) = id(ir)
            id(ir) = itmp

            etmp = e(il+1)
            e(il+1) = e(ir)
            e(ir) = etmp

          ENDIF

          IF ( e(il) > e(il+1) ) THEN

            itmp = id(il)
            id(il) = id(il+1)
            id(il+1) = itmp

            etmp = e(il)
            e(il) = e(il+1)
            e(il+1) = etmp

          ENDIF

          i = il + 1
          j = ir

          ii = id(il+1)
          ee =  e(il+1)

 3        CONTINUE

          i = i + 1

          IF ( e(i) < ee ) GOTO 3

 4        CONTINUE

          j = j - 1

          IF ( e(j) > ee ) GOTO 4

          IF ( j < i ) GOTO 5

          itmp = id(i)
          id(i) = id(j)
          id(j) = itmp

          etmp = e(i)
          e(i) = e(j)
          e(j) = etmp

          GOTO 3

 5        id(il+1) = id(j)
          id(j) = ii

          e(il+1) = e(j)
          e(j) = ee

          is = is + 2

          IF ( is > ns ) THEN

            WRITE(*,*)'ERROR: ns too small in quicksort.'
            STOP

          ENDIF

          IF ( ir-i+1 >= j-il ) THEN

            istk(is) = ir
            istk(is-1) = i
            ir = j - 1

          ELSE

            istk(is) = j - 1
            istk(is-1) = il
            il = i

          ENDIF

        ENDIF

        GOTO 1

        RETURN

      END SUBROUTINE QUICKSORT
