! ==============================================================================
! Module: FOLDING
! 
! Purpose: Contains the parameter arrays needed for computing the secondary
!          structure of an RNA sequence.
!
!          For a list of parameters see:
!
!          A. M. Zuker, "Algorithms and thermodynamics for RNA secondary
!          structure predicitions: A practical guide".
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            01/01/2019   Original Code
!
! Contains:
!
! Modules -
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!            Copyright (c) 2019 (Please Refer to LICENCE)
!
! ==============================================================================

      MODULE FOLDING

        IMPLICIT NONE

        !=== PARAMETERS ===!

        DOUBLE PRECISION, PARAMETER :: einf = 1.0d+9
        DOUBLE PRECISION, PARAMETER :: prec = 1.0d-2 

        INTEGER, PARAMETER :: loop = 3
        INTEGER, PARAMETER :: mxas = 30
        INTEGER, PARAMETER :: mxlp = 30
        INTEGER, PARAMETER :: mxt4 = 200
        INTEGER, PARAMETER :: mxbp = 1000000

        !=== VARIABLES ===!

        DOUBLE PRECISION, SAVE :: eninio(5),eaup(4,4)
        DOUBLE PRECISION, SAVE :: enf1(3),enf2(3),epc(3)
        DOUBLE PRECISION, SAVE :: epg,eau

        DOUBLE PRECISION, SAVE :: elp_hp(30)
        DOUBLE PRECISION, SAVE :: elp_bu(30)
        DOUBLE PRECISION, SAVE :: elp_in(30)

        DOUBLE PRECISION, SAVE :: dng_5p(6,4)
        DOUBLE PRECISION, SAVE :: dng_3p(6,4)

        DOUBLE PRECISION, SAVE :: stk_bp(6,6)
        DOUBLE PRECISION, SAVE :: stk_hp(6,16)
        DOUBLE PRECISION, SAVE :: stk_in(6,16)

        DOUBLE PRECISION, SAVE :: stk_11(6,6,16)
        DOUBLE PRECISION, SAVE :: stk_12(6,6,16,4)
        DOUBLE PRECISION, SAVE :: stk_22(6,6,16,16)

        DOUBLE PRECISION, SAVE :: elp_t4(mxt4)
        CHARACTER(LEN=6), SAVE :: seq_t4(mxt4)

        INTEGER, SAVE :: iwc(4,4),nt4

      END MODULE FOLDING
