! ==============================================================================
! Module: RNADATA
! 
! Purpose: Contains the information about the mRNA sequence including
!          folding energy arrays for computing MFE folds and the possible
!          ribosomal binding sites (RBS) along with the off rates for the
!          30S:PIC at these sites. 
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            01/01/2019   Original Code
!
! Contains:
!
! Modules - CONSTANTS
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!            Copyright (c) 2019 (Please Refer to LICENCE)
!
! ==============================================================================

      MODULE RNADATA

        USE Constants, ONLY : mxnt,nmax

        IMPLICIT NONE

        !=== Sequence Info ===!

        INTEGER, SAVE :: nnuc
        INTEGER, SAVE :: iseq(mxnt)

        CHARACTER, SAVE :: seq(mxnt)

        !=== Ribosome Binding Sites ===!

        INTEGER, SAVE :: nrbs
        INTEGER, SAVE :: link_rbs(mxnt)
        INTEGER, SAVE :: list_rbs(mxnt)

        DOUBLE PRECISION, SAVE :: rbs_on(mxnt)
        DOUBLE PRECISION, SAVE :: rbs_off(mxnt)

        DOUBLE PRECISION, SAVE :: r_standby(mxnt)
        DOUBLE PRECISION, SAVE :: r_nostand(mxnt)

        !=== Codons / Protein  Info ===!

        INTEGER, SAVE :: icdn(mxnt)

        !=== Ground State Fold ===!

        INTEGER, SAVE :: link_gsf(mxnt)
        INTEGER, SAVE :: ibsp_gsf(mxnt)

        !=== Folding Arrays ===!

        INTEGER, SAVE :: indx_row(nmax)
        INTEGER, SAVE :: indx_col(nmax)

        DOUBLE PRECISION, SAVE :: v(nmax),vr(nmax),vb(nmax)

      END MODULE RNADATA
