! ==============================================================================
! Subroutine: SETUP_RNA (FILENAME)
! 
! Purpose: Reads in the RNA sequence, the ground state fold, and calculates
!          the folding arrays, codon numbers, and Ribosomal Binding Sites.
!
! Method:
!
! Arguments:
!
!        FILENAME - (CHARAC)  Name of the file containing the RNA sequence
!                             and RNA fold info.
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            01/01/2019   Original Code
!
! Dependancies:
!
! Modules - RNADATA
! Functions -
! Subroutines - SD_DELTAG, FILL_CT
!
! Author(s): Eric Dykeman
!            Copyright (c) 2019 (Please Refer to LICENCE)
!
! ==============================================================================

      SUBROUTINE SETUP_RNA (FILENAME)

        USE RNAData, ONLY : seq,iseq,icdn,nnuc,mxnt,&
                          & link_gsf,ibsp_gsf

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        CHARACTER (LEN=255) :: filename

        !=== VARIABLES ===!

        INTEGER :: i,i1,i2,i3,ic

        CHARACTER (LEN=10000) :: file_line
        CHARACTER :: fld(mxnt)


        !=== Read in RNA Seq/Fld ===!

        OPEN (UNIT=101,FILE=filename,STATUS='Unknown')

        READ(101,*)file_line

        nnuc = LEN_TRIM(file_line)

        IF ( nnuc > mxnt ) THEN

          WRITE(*,*)'ERROR: number of nucleotides > mxnt '
          STOP

        ENDIF

        READ(file_line,'(10000A1)')(seq(i),i=1,nnuc)

!        READ(101,*)file_line

!        READ(file_line,'(10000A1)')(fld(i),i=1,nnuc)

        CLOSE (UNIT=101)


        !=== Convert Sequence to Numerical Code ===!

        CALL CONVERT (seq,iseq,nnuc,ic)

        IF ( ic /= 0 ) THEN

          WRITE(*,*)'ERROR: non-ACGU letter in sequence '
          STOP

        ENDIF

        !=== Convert Vienna Fold to Base-Pair ===!

!        CALL V2CT (ibsp_gsf,fld,'C',nnuc)

        !=== Determine Ground State Fold Links ===!

        !ECD To setup later
        link_gsf(:) = 0

        !=== Determine Codon Numbers ===!

        icdn(:) = 0

        DO i=1,nnuc-2

          i1 = iseq(i+0)
          i2 = iseq(i+1)
          i3 = iseq(i+2)

          ic = ( i1 - 1 )
          ic = ic * 4 + ( i2 - 1 )
          ic = ic * 4 + ( i3 - 1 )

          ic = ic + 1

          icdn(i) = ic

        ENDDO

        !=== Identify Ribosomal Binding Sites ===!

!        CALL SD_DELTAG

        !=== Fill Folding Arrays ===!

!        CALL FILL_CT

        RETURN

      END SUBROUTINE SETUP_RNA
