! ==============================================================================
! Subroutine: HESSIANNBP [ENM VERSION]
! 
! Purpose: Computes the hessian coefficents for Non-Bonded pair
!          interactions. HNPAIR is an array that stores the first and
!          second derivates of the potential V(R) between atom pairs.
!
! Method:  Cornell et al., J. Am. Chem. Soc. 117, 5179 (1995).
!
!          HNPAIR(1,i) = dV/dR   -- First Derivative of V(R)
!          HNPAIR(2,i) = d2V/dR2 -- Second Derivative of V(R)
!
! Arguments:
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules - SystemParam
! Functions -
! Subroutines - NEIGHBORMAP, SYMMETRYMAP
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      SUBROUTINE HESSIANNBP

        USE SystemParam, ONLY : hnpair,nnpair,isym

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        !=== VARIABLES ===!

        DOUBLE PRECISION, PARAMETER :: spring = 2.0d-2
        INTEGER :: i


        !=== Calculate Neighbormap ===!

        IF ( isym == 0 ) THEN

          CALL NEIGHBORMAP

        ELSE

          CALL SYMMETRYMAP

        ENDIF


        !=== ENM Terms ===!

        IF ( ALLOCATED(hnpair) ) DEALLOCATE(hnpair)

        IF ( nnpair == 0 ) RETURN

        ALLOCATE (hnpair(2,nnpair))

        DO i=1,nnpair

          hnpair(1,i) = 0.0d0
          hnpair(2,i) = spring

        ENDDO

        RETURN

      END SUBROUTINE HESSIANNBP
