! ==============================================================================
! Subroutine: HESSIANNBP
! 
! Purpose: Computes the hessian coefficents for Non-Bonded pair
!          interactions. HNPAIR is an array that stores the first and
!          second derivates of the potential V(R) between atom pairs.
!
! Method:  Cornell et al., J. Am. Chem. Soc. 117, 5179 (1995).
!
!          HNPAIR(1,i) = dV/dR   -- First Derivative of V(R)
!          HNPAIR(2,i) = d2V/dR2 -- Second Derivative of V(R)
!
! Arguments:
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules - SystemParam
! Functions -
! Subroutines - ESTATICH, EXCLUDEDH, SCALEDH
!               NEIGHBORMAP, SYMMETRYMAP
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      SUBROUTINE HESSIANNBP

        USE SystemParam, ONLY : hnpair,nnpair,isym,igb,icou,ivdw

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        !=== VARIABLES ===!

        INTEGER :: i


        IF ( icou == 0 .and. ivdw == 0 ) RETURN

        !=== Calculate Neighbormap ===!

        IF ( isym == 0 ) THEN

          CALL NEIGHBORMAP

        ELSE

          CALL SYMMETRYMAP

        ENDIF

        IF ( ALLOCATED(hnpair) ) DEALLOCATE(hnpair)

        IF ( nnpair /= 0 ) THEN

          ALLOCATE( hnpair(2,nnpair) )

          hnpair = 0.0d0

        ENDIF


        !=== Non-Bonded Terms ===!

        IF ( igb /= 0 ) THEN

          CALL GBORNH

        ELSE

          CALL ESTATICH

        ENDIF

        !=== Excluded Correction ===!

        CALL EXCLUDEDH

        !=== Scaled Correction ===!

        CALL SCALEDH

        RETURN

      END SUBROUTINE HESSIANNBP
