! ==============================================================================
! Subroutine: CHKOPTIONS
! 
! Purpose: Checks user defined options for mistakes and inconsistancies.
!
! Method:
!
! Arguments:
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules - SystemParam
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      SUBROUTINE CHKOPTIONS

        USE SystemParam

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        !=== VARIABLES ===!

        LOGICAL :: ierr


        !=== Check Settings ===!

        ierr = .false.

        IF ( isym /= 0 ) THEN

          IF ( ipbc /= 0 ) THEN

            ierr = .true.

            IF ( myproc == 0 ) THEN
            WRITE(4,*)'ERROR: Saguaro can not perform a group theory'
            WRITE(4,*)'calculation with periodic boundaries.'
            ENDIF

          ENDIF

          IF ( isim == 1 ) THEN

            ierr = .true.

            IF ( myproc == 0 ) THEN
            WRITE(4,*)'ERROR: performing this simulation with group'
            WRITE(4,*)'theory can not be done.'
            WRITE(4,*)'Please check isim setting, isim = ',isim
            ENDIF

          ENDIF

        ENDIF

        IF ( ipbc > 0 .and. icrd < 3 ) THEN

          ierr = .true.

          IF ( myproc == 0 ) THEN
          WRITE(4,*)'ERROR: for ipbc = ',ipbc
          WRITE(4,*)'icrd must be set to either 3 or 4'
          ENDIF

        ENDIF

        IF ( igb /= 0 ) THEN

          IF ( icou /= 1 ) THEN

            ierr = .true.

            IF ( myproc == 0 ) THEN
            WRITE(4,*)'ERROR: icou /= 1 conflicts with igb = ',igb
            WRITE(4,*)'If you wish to turn off coulomb interations'
            WRITE(4,*)'then please set igb = 0'
            ENDIF

          ENDIF

          IF ( diel == 1.0d0 ) THEN

            ierr = .true.

            IF ( myproc == 0 ) THEN
            WRITE(4,*)'ERROR: dielectric constant must be set'
            WRITE(4,*)'to something greater than one.'
            WRITE(4,*)'Suggestion -- diel = 80.0 for water.'
            ENDIF

          ENDIF

          IF ( ipbc == 2 ) THEN

            ierr = .true.

            IF ( myproc == 0 ) THEN
            WRITE(4,*)'ERROR: Saguaro is not able to do pressure'
            WRITE(4,*)'coupling within the generalized Born model.'
            ENDIF

          ENDIF

        ENDIF

        IF ( igb == 0 .and. igbsa /= 0 ) THEN

          ierr = .true.

          IF ( myproc == 0 ) THEN
          WRITE(4,*)'ERROR: SASA calculation must be turned off unless'
          WRITE(4,*)'the generalized Born model is in use.'
          ENDIF

        ENDIF

        IF ( ishk /= 0 ) THEN

          IF ( isim /= 1 ) THEN

            ierr = .true.

            IF ( myproc == 0 ) THEN
            WRITE(4,*)'ERROR: SHAKE must be off for this simulation.'
            ENDIF

          ENDIF

          IF ( ipbc == 2 ) THEN

            ierr = .true.

            IF ( myproc == 0 ) THEN
            WRITE(4,*)'ERROR: SHAKE can not be used in a constant'
            WRITE(4,*)'pressure simulation yet.'
            ENDIF

          ENDIF

        ENDIF

        IF ( ipbc == 2 ) THEN

          IF ( itc == 1 .and. ipc == 2 ) THEN

            ierr = .true.

            IF ( myproc == 0 ) THEN
            WRITE(4,*)'ERROR: must have itc = 0,2 with ipc = 2'
            ENDIF

          ENDIF

          IF ( itc == 2 .and. ipc == 1 ) THEN

            ierr = .true.

            IF ( myproc == 0 ) THEN
            WRITE(4,*)'ERROR: must have itc = 0,1 with ipc = 1'
            ENDIF

          ENDIF

        ENDIF


        !=== Stop if an error occured ===!

        IF ( ierr ) THEN

          IF ( mpijob ) CALL CLOSEMPI

          STOP

        ENDIF

        RETURN

      END SUBROUTINE CHKOPTIONS
