! ==============================================================================
! Subroutine: GETGTPARAMS
! 
! Purpose: Reads in the group symmetry operators an character table for
!          a simulation that uses group theory.
!
! Method:
!
! Arguments:
!
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules - SystemParam
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      SUBROUTINE GETGTPARAMS

        USE SystemParam, ONLY : grot,gchar,lcls,ncls,ngrp,irep,myproc

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        !=== VARIABLES ===!

        INTEGER :: i,j,n,jstart,jend
        INTEGER, DIMENSION(:), ALLOCATABLE :: iwrk

        CHARACTER (LEN=5) :: cname,ctitle


        !=== Read in Symmetry File ===!

        READ(12,*)ngrp

        ALLOCATE (grot(3,3,ngrp))

        DO i=1,ngrp

          READ(12,*)grot(1,1,i),grot(1,2,i),grot(1,3,i)
          READ(12,*)grot(2,1,i),grot(2,2,i),grot(2,3,i)
          READ(12,*)grot(3,1,i),grot(3,2,i),grot(3,3,i)

        ENDDO


        !=== Read in Character Table File ===!

        READ(13,*)ncls

        ALLOCATE (gchar(ncls,ncls),lcls(ngrp),iwrk(ncls))

        gchar = 0.0d0

        READ(13,*)ctitle,(iwrk(i),cname,i=1,ncls)

        IF ( myproc == 0 ) THEN

          WRITE(4,*)'Symmetry group is ',ctitle

        ENDIF

        DO i=1,ncls

          READ(13,*)cname,(gchar(i,j),j=1,ncls)

          IF ( i == irep .and. myproc == 0 ) THEN

            WRITE(4,*)'Working with Irred. representation ',cname

          ENDIF

        ENDDO

        !=== Get List of Classes ===!

        n = 0

        DO i=1,ncls

          jstart = n + 1
          jend = n + iwrk(i)

          DO j=jstart,jend

            lcls(j) = i

          ENDDO

          n = n + iwrk(i)

        ENDDO

        DEALLOCATE (iwrk)

        RETURN

      END SUBROUTINE GETGTPARAMS
