! ==============================================================================
! Subroutine: GETOPTIONS
! 
! Purpose: Reads in the system options via a namelist. Default values
!          are set for each option.
!
! Method:
!
! Arguments:
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules - SystemParam
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      SUBROUTINE GETOPTIONS

        USE SystemParam

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        !=== VARIABLES ===!


        NAMELIST /options/ cut,scut,bxgrd,diel,kappa,tole,tols,tolf,&
                         & sfc,sfv,beta,temp,btemp,taut,taup,pres,comp,&
                         & tstep,nsteps,nse,nsv,nsc,nsmap,nsbk,nev,&
                         & maxsi,nord,isim,icrd,ipbc,isym,irep,ircp,&
                         & iout,imin,itc,ipc,ips,igb,igbsa,ishk,ibd,&
                         & iag,idh,icou,ivdw,iseed,ismth

        !=== Set Default Values ===!

        cut = 8.0d0              !Cutoff distance in angstroms
        scut = 6.0d0             !Starting cutoff for smoothing
        bxgrd = 2.0d0            !Grid box dimension for neighbormaping
        diel = 1.0d0             !Dielectric constant
        kappa = 0.0d0            !Debey-Huckel screening parameter
        tole = 1.0d-5            !Tolerance for energies in Ewald sums
        tols = 5.0d-4            !Tolerance for SHAKE distances
        tolf = 0.01d0            !Tolerance for forces in minimization
        sfc = 1.2d0              !Scaling for 1-4 coulumb interaction
        sfv = 2.0d0              !Scaling for 1-4 vdw interactions
        beta = 0.20d0            !Damping factor for Fennell-Gezelter
        temp = 300.0d0           !Inital system Temperature (K)
        btemp = 300.0d0          !Bath Temperature (K)
        taut = 1.0d0             !Temperature coupling constant (ps)
        taup = 1.0d0             !Pressure coupling constant (ps)
        pres = 1.013d0           !System target presure (Bar)
        comp = 4.46d-5           !Compressabilty of solvent (1/Bar)
        tstep = 1.0d-3           !Time step (ps)

        nsteps = 5000            !Number of simulation steps
        nse = 0                  !Output frequency for energies
        nsv = 0                  !Output frequency for velocities
        nsc = 0                  !Output frequency for coordinates
        nsmap = 25               !Number of steps between neighbormapping
        nsbk = 0                 !Number of steps between writting backup
        nev = 1                  !Number of eigenvectors to find
        maxsi = 100              !Maximum number of SHAKE iterations
        nord = 4                 !Interpolation order for particle mesh Ewald

        isim = 1                 !Flag for simulation type
        icrd = 3                 !Flag for coordinate format
        ipbc = 1                 !Flag for periodic boundary type
        isym = 0                 !Flag for symmetry
        irep = 1                 !Flag for irreducible representation
        ircp = 1                 !Flag for reciprocal space sum method
        iout = 0                 !Flag for water output
        imin = 1                 !Flag for minimization procedure
        itc = 1                  !Flag for Temperature coupling
        ipc = 1                  !Flag for Pressure coupling
        ips = 1                  !Flag for Pressure scaling
        igb = 0                  !Flag for generalized Born model
        igbsa = 0                !Flag for SASA calculation
        ishk = 0                 !Flag for SHAKE
        ibd = 1                  !Flag to compute bond interactions
        iag = 1                  !Flag to compute angle Interactions
        idh = 1                  !Flag to compute dihedral Interactions
        icou = 1                 !Flag to compute coulomb Interactions
        ivdw = 1                 !Flag to compute VDW Interactions
        ismth = 0                !Flag for smoothing function
        iseed = 7104             !Seed for random number generator


        !=== Read in New Values ===!

        READ(1,NML=options)

        RETURN

      END SUBROUTINE GETOPTIONS
