! ==============================================================================
! Subroutine: GETPARAMS
! 
! Purpose: Reads in the parameter file containing the energy parameters
!          and the coordinate file containing atomic positions.
!
! Method:
!
! Arguments:
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules - SystemParam
! Functions -
! Subroutines - CROSS, MAXWELLDIST, ZEROP, GETMYJOBS, CLOSEMPI
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      SUBROUTINE GETPARAMS

        USE SystemParam

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        !=== VARIABLES ===!

        INTEGER :: i,j,n,is,ie

        DOUBLE PRECISION :: fac

        CHARACTER :: atype

        DOUBLE PRECISION, PARAMETER :: cfac = 3.79447729792d0
        DOUBLE PRECISION, PARAMETER :: rad = 1.74532925199432954743d-2


        !=== Constant Dielectric Simulation ===!

        fac = cfac

        IF ( diel > 1.0d0 .and. igb == 0 ) THEN

          fac = cfac / DSQRT(diel)

        ENDIF


        !=== Read in Parameter File ===!

        READ(2,*)nat,nbd,nhbd,nag,ndh,nex,n14

        SELECT CASE (ishk)

          CASE (0)

            nubd = nbd
            ncbd = 0

          CASE (1)

            nubd = nbd - nhbd
            ncbd = nhbd

          CASE (2)

            ncbd = nbd
            nubd = 0

          CASE DEFAULT

            IF ( myproc == 0 ) THEN

              WRITE(4,*)'ERROR: ishk must range from 0 to 2'
              WRITE(4,*)'ishk = ',ishk

            ENDIF

            IF ( mpijob ) CALL CLOSEMPI

            STOP

        END SELECT


        !=== Allocate Arrays ===!

        ALLOCATE (dvdw(2,nat),rat(3,nat),vel(3,nat))
        ALLOCATE (q(nat),itype(nat),amass(nat))


        !=== Read in Data ===!

        READ(2,*)(amass(i),q(i),dvdw(1,i),dvdw(2,i),i=1,nat)

        DO i=1,nat

          q(i) = fac * q(i)

        ENDDO

        IF ( ncbd /= 0 ) THEN

          ALLOCATE (lcbd(2,ncbd),dcbd(2,ncbd))

          READ(2,*)(lcbd(1,i),lcbd(2,i),dcbd(1,i),dcbd(2,i),i=1,ncbd)

        ENDIF

        IF ( nubd /= 0 ) THEN

          CALL GETMYJOBS (is,ie,nubd,mpijob,myproc,nproc)

          n = ie - is + 1

          ALLOCATE (lubd(2,n),dubd(2,n))

          j = 0

          DO i=1,nubd
          IF ( i >= is .and. i <= ie ) THEN

            j = j + 1
            READ(2,*)lubd(1,j),lubd(2,j),dubd(1,j),dubd(2,j)

          ELSE

            READ(2,*)

          ENDIF
          ENDDO

          nubd = n

        ENDIF

        IF ( nag /= 0 ) THEN

          CALL GETMYJOBS (is,ie,nag,mpijob,myproc,nproc)

          n = ie - is + 1

          ALLOCATE (langl(3,n),dangl(2,n))

          j = 0

          DO i=1,nag
          IF ( i >= is .and. i <= ie ) THEN

            j = j + 1
            READ(2,*)langl(1,j),langl(2,j),langl(3,j),&
                   & dangl(1,j),dangl(2,j)

          ELSE

            READ(2,*)

          ENDIF
          ENDDO

          nag = n

          DO i=1,nag

            dangl(2,i) = rad * dangl(2,i)

          ENDDO

        ENDIF

        IF ( ndh /= 0 ) THEN

          CALL GETMYJOBS (is,ie,ndh,mpijob,myproc,nproc)

          n = ie - is + 1

          ALLOCATE (ldihd(4,n),ddihd(3,n))

          j = 0

          DO i=1,ndh
          IF ( i >= is .and. i <= ie ) THEN

            j = j + 1
            READ(2,*)ldihd(1,j),ldihd(2,j),ldihd(3,j),ldihd(4,j),&
                   & ddihd(1,j),ddihd(2,j),ddihd(3,j)

          ELSE

            READ(2,*)

          ENDIF
          ENDDO

          ndh = n

          DO i=1,ndh

            ddihd(2,i) = rad * ddihd(2,i)

          ENDDO

        ENDIF

        IF ( nex /= 0 ) THEN

          CALL GETMYJOBS (is,ie,nex,mpijob,myproc,nproc)

          IF ( isim == 2 ) THEN
            is = 1
            ie = nex
          ENDIF

          n = ie - is + 1

          ALLOCATE (lex(2,n))

          j = 0

          DO i=1,nex
          IF ( i >= is .and. i <= ie ) THEN

            j = j + 1
            READ(2,*)lex(1,j),lex(2,j)

          ELSE

            READ(2,*)

          ENDIF
          ENDDO

          nex = n

        ENDIF

        IF ( n14 /= 0 ) THEN

          CALL GETMYJOBS (is,ie,n14,mpijob,myproc,nproc)

          IF ( isim == 2 ) THEN
            is = 1
            ie = n14
          ENDIF

          n = ie - is + 1

          ALLOCATE (l14(2,n))

          j = 0

          DO i=1,n14
          IF ( i >= is .and. i <= ie ) THEN

            j = j + 1
            READ(2,*)l14(1,j),l14(2,j)

          ELSE

            READ(2,*)

          ENDIF
          ENDDO

          n14 = n

        ENDIF


        !=== Read in Coordinate File ===!

        READ(3,*)n,time

        IF ( n /= nat .and. myproc == 0 ) THEN

          WRITE(4,*)'ERROR: the number of atoms in the coordinate file'
          WRITE(4,*)'does not match the number in the parameter file.'

          IF ( mpijob ) CALL CLOSEMPI

          STOP

        ENDIF

        IF ( icrd < 1 .or. icrd > 4 ) THEN

          IF ( myproc == 0 ) THEN

            WRITE(4,*)'ERROR: icrd = ',iCRD
            WRITE(4,*)'Is not a valid choice.'

          ENDIF

          IF ( mpijob ) CALL CLOSEMPI

          STOP

        ENDIF

        IF ( icrd == 1 .or. icrd == 3 ) THEN

          READ(3,*)(itype(i),rat(1,i),rat(2,i),rat(3,i),i=1,nat)

        ENDIF

        IF ( icrd == 2 .or. icrd == 4 ) THEN

          READ(3,*)(itype(i),rat(1,i),rat(2,i),rat(3,i),&
                  & vel(1,i),vel(2,i),vel(3,i),i=1,nat)

        ENDIF

        IF ( icrd == 3 .or. icrd == 4 ) THEN

          READ(3,*)dlv(1,1),dlv(1,2),dlv(1,3)
          READ(3,*)dlv(2,1),dlv(2,2),dlv(2,3)
          READ(3,*)dlv(3,1),dlv(3,2),dlv(3,3)

        ENDIF


        !=== Read in Molecule File ===!

        nout = 0

        READ(11,*)n,nmol

        IF ( n /= nat .and. myproc == 0 ) THEN

          WRITE(4,*)'ERROR: the number of atoms in the molecule file'
          WRITE(4,*)'does not match the number in the parameter file.'

          IF ( mpijob ) CALL CLOSEMPI

          STOP

        ENDIF

        ALLOCATE (lmol(nat),imol(2,nmol))

        DO i=1,nmol

          imol(1,i) = 0
          imol(2,i) = 1

        ENDDO

        DO i=1,nat

          READ(11,*)j,atype

          lmol(i) = imol(1,j)
          imol(1,j) = i

          IF ( atype == 'A' ) THEN

            imol(2,j) = 1
            nout = nout + 1

          ELSE

            imol(2,j) = 0

          ENDIF

        ENDDO

        IF ( iout == 0 ) nout = nat


        !=== Reciprocal Lattice vectors ===!

        vol = 0.0d0

        IF ( icrd == 3 .or. icrd == 4 ) THEN

          CALL CROSS (dlv(:,2),dlv(:,3),rlv(1,:))
          CALL CROSS (dlv(:,3),dlv(:,1),rlv(2,:))
          CALL CROSS (dlv(:,1),dlv(:,2),rlv(3,:))

          vol = rlv(1,1) * dlv(1,1) + rlv(1,2) * dlv(2,1) &
            & + rlv(1,3) * dlv(3,1)

          DO i=1,3

            rlv(1,i) = rlv(1,i) / vol
            rlv(2,i) = rlv(2,i) / vol
            rlv(3,i) = rlv(3,i) / vol

          ENDDO

        ENDIF

        !=== Set Up Maxwell Distribution ===!

        IF ( icrd == 1 .or. icrd == 3 ) THEN

          IF ( temp /= 0.0d0 ) THEN

            CALL MAXWELLDIST (temp,amass,nat,iseed,vel)

          ENDIF

          CALL ZEROP (rat,vel,amass,nat)

        ENDIF

        RETURN

      END SUBROUTINE GETPARAMS
