! ==============================================================================
! Subroutine: OUTPUTMD (EK,EB,EA,ED,EC,EV,ISTEP)
! 
! Purpose: Writes out data during a molecular dynamics simulation.
!
! Method:
!
! Arguments:
!
!          EK    - Total Kinetic Energy of the system.
!          EB    - Total Energy due to bonds.
!          EA    - Total Energy due to angles.
!          ED    - Total Energy due to dihedrals.
!          EC    - Total Energy due to coulomb.
!          EV    - Total Energy due to vdw.
!          ISTEP - Current MD Step.
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules - SystemParam
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      SUBROUTINE OUTPUTMD (EK,EB,EA,ED,EC,EV,ISTEP)

        USE SystemParam, ONLY : rat,vel,dlv,temp,time,itype,imol,lmol,&
                              & nat,nse,nsv,nsc,nmol,nout,iout,ipbc

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        INTEGER, INTENT(IN) :: istep

        DOUBLE PRECISION, INTENT(IN) :: ek,eb,ea,ed,ec,ev

        !=== VARIABLES ===!

        INTEGER :: i,j

        DOUBLE PRECISION :: e

        CHARACTER (LEN=60) :: fmat


        !=== Output Energies ===!

        IF ( nse /= 0 ) THEN

          IF ( istep == 1 ) THEN

            fmat = '(9A12)'

            WRITE(7,fmat)'# TIME(ps)',' EBOND(eV)',' EANGL(eV)',&
                        &' EDIHD(eV)',' ECOUL(eV)','  EVDW(eV)',&
                        &'  EKIN(eV)','  ETOT(eV)','   TEMP(K)'

          ENDIF

          IF ( MODULO(istep,nse) == 0 ) THEN

            fmat = '(9F12.4)'

            e = eb + ea + ed + ec + ev + ek

            WRITE(7,fmat)time,eb,ea,ed,ec,ev,ek,e,temp

          ENDIF

        ENDIF


        !=== Output Velocities ===!

        IF ( nsv /= 0 ) THEN

          IF ( MODULO(istep,nsv) == 0 ) THEN

            IF ( iout == 0 ) THEN

              fmat = '(I8,E16.8)'

              WRITE(8,fmat)nat,time

              fmat = '(I3,3F13.7)'

              WRITE(8,fmat)(itype(i),vel(1,i),vel(2,i),vel(3,i),i=1,nat)

            ELSE

              fmat = '(I8,E16.8)'

              WRITE(8,fmat)nout,time

              fmat = '(I3,3F13.7)'

              DO i=1,nmol
              IF ( imol(2,i) /= 0 ) THEN

                j = imol(1,i)

                DO WHILE ( j /= 0 )

                  WRITE(8,fmat)itype(j),vel(1,j),vel(2,j),vel(3,j)

                  j = lmol(j)

                ENDDO

              ENDIF
              ENDDO

            ENDIF

          ENDIF

        ENDIF


        !=== Output Coordinates ===!

        IF ( nsc /= 0 ) THEN

          IF ( MODULO(istep,nsc) == 0 ) THEN

            IF ( iout == 0 ) THEN

              fmat = '(I8,E16.8)'

              WRITE(9,fmat)nat,time

              fmat = '(I3,3F13.7)'

              WRITE(9,fmat)(itype(i),rat(1,i),rat(2,i),rat(3,i),i=1,nat)

            ELSE

              fmat = '(I8,E16.8)'

              WRITE(9,fmat)nout,time

              fmat = '(I3,3F13.7)'

              DO i=1,nmol
              IF ( imol(2,i) /= 0 ) THEN

                j = imol(1,i)

                DO WHILE ( j /= 0 )

                  WRITE(9,fmat)itype(j),rat(1,j),rat(2,j),rat(3,j)

                  j = lmol(j)

                ENDDO

              ENDIF
              ENDDO

            ENDIF

            IF ( ipbc /= 0 ) THEN

              fmat = '(3F13.7)'

              WRITE(9,fmat)dlv(1,1),dlv(1,2),dlv(1,3)
              WRITE(9,fmat)dlv(2,1),dlv(2,2),dlv(2,3)
              WRITE(9,fmat)dlv(3,1),dlv(3,2),dlv(3,3)

            ENDIF

          ENDIF

        ENDIF

        RETURN

      END SUBROUTINE OUTPUTMD
