! ==============================================================================
! Subroutine: OUTPUTMIN (EK,EB,EA,ED,EC,EV,FRMS,NAT,ISTEP)
! 
! Purpose: Writes out energy data during minimization.
!
! Method:
!
! Arguments:
!
!          EK    - Total Kinetic Energy of the system.
!          EB    - Total Energy due to bonds.
!          EA    - Total Energy due to angles.
!          ED    - Total Energy due to dihedrals.
!          EC    - Total Energy due to coulomb.
!          EV    - Total Energy due to vdw.
!          FRMS  - Root Mean Squared force Sqrt(<F|F>/NAT).
!          NAT   - Total number of atoms in the system.
!          ISTEP - Current Minimization Step.
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules - 
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      SUBROUTINE OUTPUTMIN (EK,EB,EA,ED,EC,EV,FRMS,NAT,ISTEP)

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        INTEGER, INTENT(IN) :: nat,istep

        DOUBLE PRECISION, INTENT(IN) :: ek,eb,ea,ed,ec,ev,frms

        !=== VARIABLES ===!

        DOUBLE PRECISION :: e,temp
        DOUBLE PRECISION, PARAMETER :: boltz = 8.61734315d-5

        CHARACTER (LEN=60) :: fmat


        temp = DBLE(nat) * boltz
        temp = 1.50d0 * temp
        temp = ek / temp

        !=== Output Energies ===!

        IF ( istep == 1 ) THEN

          fmat = '(8A12,A13)'

          WRITE(7,fmat)'# STEP NUM',' EBOND(eV)',' EANGL(eV)',&
                      &' EDIHD(eV)',' ECOUL(eV)','  EVDW(eV)',&
                      &'  ETOT(eV)','   TEMP(K)',' RMSF(eV/A)'

        ENDIF

        fmat = '(I12,7E12.4,E13.5)'

        e = eb + ea + ed + ec + ev

        WRITE(7,fmat)istep,eb,ea,ed,ec,ev,e,temp,frms

        RETURN

      END SUBROUTINE OUTPUTMIN
