! ==============================================================================
! Subroutine: OUTPUTVIBE (A,B,C,D,E,DF,XLAM,ISTEP)
! 
! Purpose: Writes out info on the phonon functional during a vibes simulation.
!
! Method:
!
! Arguments:
!
!          A     - Cubic coefficent of the minimization equation.
!          B     - Quadratic coefficent of the minimization equation.
!          C     - Linear coefficent of the minimization equation.
!          D     - Constant coefficent of the minimization equation.
!          E     - Total Energy of the phonon functional = TR(H).
!          DF    - Squared magnitude of the phonon functional
!                  gradient <G|G>.
!          XLAM  - Step size used for search direction.
!          ISTEP - Current VIBE Step.
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules - 
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      SUBROUTINE OUTPUTVIBE (A,B,C,D,E,DF,XLAM,ISTEP)

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        INTEGER, INTENT(IN) :: istep

        DOUBLE PRECISION, INTENT(IN) :: a,b,c,d,e,df,xlam

        !=== VARIABLES ===!

        DOUBLE PRECISION :: x

        CHARACTER (LEN=60) :: fmat


        !=== Output Phonon Functional Info ===!

        IF ( istep == 1 ) THEN

          fmat = '(7A12,A18)'

          WRITE(7,fmat)'# STEP NUM','  X3 COEFF','  X2 COEFF',&
                      &'  X1 COEFF','  X0 COEFF','    LAMBDA',&
                      &'  GRADIENT','  TRACE [H+H(1-S)]'

        ENDIF

        x = DSQRT(df)

        fmat = '(I12,6E12.4,F18.10)'

        WRITE(7,fmat)istep,a,b,c,d,xlam,x,e

        RETURN

      END SUBROUTINE OUTPUTVIBE
