! ==============================================================================
! Subroutine: CROSS (A,B,C)
! 
! Purpose: Computes the cross product of two vectors A and B
!
! Method: C = A X B
!
! Arguments:
!
!           A - Array of length 3 containing the first vector.
!           B - Array of length 3 containing the second vector.
!           C - Array of length 3 containing A X B. (OUTPUT)
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules -
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      SUBROUTINE CROSS (A,B,C)

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        DOUBLE PRECISION, INTENT(IN) :: a(3),b(3)
        DOUBLE PRECISION, INTENT(OUT) :: c(3)

        !=== VARIABLES ===!


        c(1) = a(2) * b(3) - a(3) * b(2)
        c(2) = a(3) * b(1) - a(1) * b(3)
        c(3) = a(1) * b(2) - a(2) * b(1)

        RETURN

      END SUBROUTINE CROSS
