! ==============================================================================
! Function: DERFC (X)
! 
! Purpose: Computes the complementary error function of argument x.
!
! Method: DERFC = ERFC(x)
!
!         Where ERFC is computed using 7.1.26 from Abromowitz and Stegun.
!         The absolute error is: |error| < 1.5 E-7
!
! Arguments:
!
!           X - Double precision argument.
!               DERFC returns the value of ERFC(X)
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules -
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      DOUBLE PRECISION FUNCTION DERFC (X)

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        DOUBLE PRECISION, INTENT(IN) :: x

        !=== VARIABLES ===!

        DOUBLE PRECISION :: t,y,z

        DOUBLE PRECISION, PARAMETER :: one = 1.000000000d0
        DOUBLE PRECISION, PARAMETER :: zero = 0.00000000d0
        DOUBLE PRECISION, PARAMETER :: a1 =  2.548295920d-1
        DOUBLE PRECISION, PARAMETER :: a2 = -2.844967360d-1
        DOUBLE PRECISION, PARAMETER :: a3 =  1.421413741d0
        DOUBLE PRECISION, PARAMETER :: a4 = -1.453152027d0
        DOUBLE PRECISION, PARAMETER :: a5 =  1.061405429d0
        DOUBLE PRECISION, PARAMETER :: p1 =  3.275911000d-1


        z = DABS(x)

        t = one / ( one + p1 * z )

        y = (((( a5 * t + a4 ) * t + a3 ) * t + a2 ) * t + a1 ) * t

        y = y * DEXP(-z*z)

        y = one - y

        IF ( x < zero ) THEN

          DERFC = one + y

        ELSE

          DERFC = one - y

        ENDIF

        RETURN

      END FUNCTION DERFC
