! ==============================================================================
! Function: DIERFC (Y)
! 
! Purpose: Computes the INVERSE complementary error function of argument Y.
!
! Method: DIERFC = X = ERFC^{-1}(Y)
!
!         Where Y = ERFC(X) and ERFC is the complementary error function.
!
! Arguments:
!
!           Y - Double precision argument.
!               DIERFC returns the value of X where Y = ERFC(X)
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules -
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      DOUBLE PRECISION FUNCTION DIERFC (Y)

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        DOUBLE PRECISION, INTENT(IN) :: y

        !=== VARIABLES ===!

        DOUBLE PRECISION :: s,t,u,v,w,x

        DOUBLE PRECISION :: pa,pb,qa,qb,qc,qd
        DOUBLE PRECISION :: p(0:22),q(0:4)

        DOUBLE PRECISION, PARAMETER :: zero = 0.00000000000d0
        DOUBLE PRECISION, PARAMETER :: half = 0.50000000000d0
        DOUBLE PRECISION, PARAMETER :: one = 1.000000000000d0
        DOUBLE PRECISION, PARAMETER :: two = 2.000000000000d0


        !=== Set Constants ===!

        pa = 3.97886080735226000d+00
        pb = 1.20782237635245222d-01

        qa = 9.16461398268964d-01
        qb = 2.31729200323405d-01
        qc = 4.88826640273108d-01
        qd = 1.24610454613712d-01

        q(0) =  4.99999303439796d-01
        q(1) =  1.16065025341614d-01
        q(2) =  1.50689047360223d-01
        q(3) =  2.69999308670029d-01
        q(4) = -7.28846765585675d-02

        p(0)  =  2.44044510593190935d-01
        p(1)  =  4.34397492331430115d-01
        p(2)  =  6.86265948274097816d-01
        p(3)  =  9.56464974744799006d-01
        p(4)  =  1.16374581931560831d+00
        p(5)  =  1.21448730779995237d+00
        p(6)  =  1.05375024970847138d+00
        p(7)  =  7.13657635868730364d-01
        p(8)  =  3.16847638520135944d-01
        p(9)  =  1.47297938331485121d-02
        p(10) = -1.05872177941595488d-01
        p(11) = -7.43424357241784861d-02
        p(12) =  2.20995927012179067d-03
        p(13) =  3.46494207789099922d-02
        p(14) =  1.42961988697898018d-02
        p(15) = -1.18598117047771104d-02
        p(16) = -1.12749169332504870d-02
        p(17) =  3.39721910367775861d-03
        p(18) =  6.85649426074558612d-03
        p(19) = -7.71708358954120939d-04
        p(20) = -3.51287146129100025d-03
        p(21) =  1.05739299623423047d-04
        p(22) =  1.12648096188977922d-03


        s = y

        IF ( y > one ) s = two - y

        t = qa - DLOG(s)

        u = DSQRT(t)

        v = ( qc + DLOG(u) ) / t

        w = one / ( u + qb )

        x = u * ( one - v * ( half + v * qd ) ) - &
          & (((( q(4) * w + q(3) ) * w + q(2) ) * w + &
          & q(1) ) * w + q(0) ) * w

        w = pa / ( pa + x )

        u = w - half

        v = ((((((((( p(22) * u + p(21) ) * u + p(20) ) * u + &
          & p(19) ) * u + p(18) ) * u + p(17) ) * u + p(16) ) * u + &
          & p(15) ) * u + p(14) ) * u + p(13) ) * u + p(12)

        v = (((((((((((( v * u + p(11) ) * u + p(10) ) * u + &
          & p(9) ) * u + p(8) ) * u + p(7) ) * u + p(6) ) * u + &
          & p(5) ) * u + p(4) ) * u + p(3) ) * u + p(2) ) * u + &
          & p(1) ) * u + p(0) ) * w - s * DEXP(x*x - pb)

        x = x + v * ( one + x * v )

        IF ( y > one ) x = -x

        DIERFC = x

        RETURN

      END FUNCTION DIERFC
