! ==============================================================================
! Subroutine: RVECTOR (A,N,ISEED)
! 
! Purpose: Generates a normalized random vector with N components.
!
! Method: For each component of the vector, a number on the interval
!         [-00,00] is generated with a guassian probability distribution.
!
! Arguments:
!
!           A     - Array of length N containing the random vector.
!           N     - Number of components in the vector.
!           ISEED - Four byte integer seed for the random number
!                   generator.
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules -
! Functions - RANDOM, DIERFC
! Subroutines -
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      SUBROUTINE RVECTOR (A,N,ISEED)

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        INTEGER, INTENT(IN) :: n
        INTEGER, INTENT(INOUT) :: iseed

        DOUBLE PRECISION, INTENT(INOUT) :: a(n)

        !=== VARIABLES ===!

        INTEGER :: i

        DOUBLE PRECISION :: x
        DOUBLE PRECISION :: RANDOM,DIERFC


        DO i=1,n

          x = 2.0d0 * RANDOM(iseed)

          a(i) = DIERFC(x)

        ENDDO

        x = 0.0d0

        DO i=1,n

          x = x + a(i) * a(i)

        ENDDO

        x = 1.0d0 / DSQRT(x)

        DO i=1,n

          a(i) = x * a(i)

        ENDDO

        RETURN

      END SUBROUTINE RVECTOR
