! ==============================================================================
! Subroutine: CLOSEMPI
! 
! Purpose: Finalizes an MPI run.
!
! Method:
!
! Arguments:
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules -
! Functions -
! Subroutines - MPI_FINALIZE
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      SUBROUTINE CLOSEMPI

        USE SystemParam, ONLY : mpijob,myproc,nproc

        IMPLICIT NONE

        INCLUDE 'mpif.h'

        !=== ARGUMENTS ===!

        !=== VARIABLES ===!

        INTEGER :: ierr 


        CALL MPI_FINALIZE (ierr)

        IF ( ierr /= 0 .and. myproc == 0 ) THEN

          WRITE(*,*)'ERROR: MPI failed to close properly.'
          WRITE(*,*)'MPI error code -- ierr = ',ierr

        ENDIF

        RETURN

      END SUBROUTINE CLOSEMPI
