! ==============================================================================
! Subroutine: GETMYJOBS (ISTART,IEND,NLOOP,MPIJOB,MYPROC,NPROC)
! 
! Purpose: Breaks up a loop (from [1,n]) evenly over a given number
!          of processors. Each processor gets a sequential portion
!          of the total loop.
!
! Method:
!
! Arguments:
!
!           ISTART - The starting value for the portion of the loop
!                    given to processor MYPROC. (OUTPUT)
!           IEND   - The ending value for the portion of the loop
!                    given to processor MYPROC. (OUTPUT)
!           NLOOP  - The number of items in the loop.
!           MPIJOB - If running MPI then MPIJOB = .TRUE.
!                    If not running MPI then MPIJOB = .FALSE.
!           MYPROC - Processor number of this machine.
!           NPROC  - Total number of processors.
!
! History:
!
! Version    Date         Comment
! --------   ----------   -----------------------
!            10/01/2010   Original Code
!
! Dependancies:
!
! Modules -
! Functions -
! Subroutines -
!
! Author(s): Eric Dykeman
!
! ==============================================================================

      SUBROUTINE GETMYJOBS (ISTART,IEND,NLOOP,MPIJOB,MYPROC,NPROC)

        IMPLICIT NONE

        !=== ARGUMENTS ===!

        INTEGER, INTENT(OUT) :: istart,iend
        INTEGER, INTENT(IN) :: nloop,myproc,nproc

        LOGICAL, INTENT(IN) :: mpijob

        !=== VARIABLES ===!

        INTEGER :: i


        istart = 1
        iend = nloop

        IF ( .not. mpijob ) RETURN


        IF ( myproc + 1 > nloop ) THEN

          istart = 0
          iend = 0

          RETURN

        ENDIF


        i = nloop / nproc

        istart = i * myproc + 1
        iend = i * ( myproc + 1 )

        i = MODULO(nloop,nproc)

        IF ( myproc + 1 < i ) THEN

          istart = istart + myproc
          iend = iend + myproc + 1

        ELSE

          istart = istart + i
          iend = iend + i

        ENDIF

        RETURN

      END SUBROUTINE GETMYJOBS
